/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.cbor;

import java.io.IOException;
import java.io.OutputStream;

public class Encoder {
    public static byte[] encodeUtf8(String value) {
        byte[] bytes = new byte[Encoder.calculateUtf8Length(value)];
        Encoder.encodeUtf8(value, bytes, 0);
        return bytes;
    }

    public static int encodeUtf8(String value, byte[] dst, int dstOffset) {
        int originalOffset = dstOffset;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c2;
            int c = value.charAt(i);
            if (c <= 127) {
                dst[dstOffset++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                dst[dstOffset++] = (byte)(0xC0 | c >> 6);
                dst[dstOffset++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c <= 56319 && i + 1 < len && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = 65536 + ((c & 0x3FF) << 10 | c2 & 0x3FF);
                ++i;
                dst[dstOffset++] = (byte)(0xF0 | c >> 18);
                dst[dstOffset++] = (byte)(0x80 | c >> 12 & 0x3F);
                dst[dstOffset++] = (byte)(0x80 | c >> 6 & 0x3F);
                dst[dstOffset++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            dst[dstOffset++] = (byte)(0xE0 | c >> 12);
            dst[dstOffset++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dstOffset++] = (byte)(0x80 | c & 0x3F);
        }
        return dstOffset - originalOffset;
    }

    public static void encodeUtf8(String value, OutputStream out) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c2;
            int c = value.charAt(i);
            if (c <= 127) {
                out.write(c);
                continue;
            }
            if (c <= 2047) {
                out.write(0xC0 | c >> 6);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c <= 56319 && i + 1 < len && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = 65536 + ((c & 0x3FF) << 10 | c2 & 0x3FF);
                ++i;
                out.write(0xF0 | c >> 18);
                out.write(0x80 | c >> 12 & 0x3F);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            out.write(0xE0 | c >> 12);
            out.write(0x80 | c >> 6 & 0x3F);
            out.write(0x80 | c & 0x3F);
        }
    }

    public static int calculateUtf8Length(String value) {
        int len;
        int encodedLen = len = value.length();
        for (int i = 0; i < len; ++i) {
            char c2;
            char c = value.charAt(i);
            if (c <= '\u007f') continue;
            ++encodedLen;
            if (c <= '\u07ff') continue;
            ++encodedLen;
            if (c < '\ud800' || c > '\udbff' || i + 1 >= len || (c2 = value.charAt(i + 1)) < '\udc00' || c2 > '\udfff') continue;
            ++i;
        }
        return encodedLen;
    }

    public static int float32to16(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }

    public static int calculateCborFieldSize(long value) {
        if ((value ^= value >> 63) < 24L) {
            return 1;
        }
        if (value < 256L) {
            return 2;
        }
        if (value < 65536L) {
            return 3;
        }
        if (value < 0x100000000L) {
            return 5;
        }
        return 9;
    }

    public static int appendCborTypePrefix(byte[] dst, int offset, int type, long value) {
        if (value < 24L) {
            dst[offset++] = (byte)((long)type + value);
        } else {
            if (value < 256L) {
                dst[offset++] = (byte)(type + 24);
            } else {
                if (value < 65536L) {
                    dst[offset++] = (byte)(type + 25);
                } else {
                    if (value < 0x100000000L) {
                        dst[offset++] = (byte)(type + 26);
                    } else {
                        dst[offset++] = (byte)(type + 27);
                        dst[offset++] = (byte)(value >> 56);
                        dst[offset++] = (byte)(value >> 48);
                        dst[offset++] = (byte)(value >> 40);
                        dst[offset++] = (byte)(value >> 32);
                    }
                    dst[offset++] = (byte)(value >> 24);
                    dst[offset++] = (byte)(value >> 16);
                }
                dst[offset++] = (byte)(value >> 8);
            }
            dst[offset++] = (byte)value;
        }
        return offset;
    }

    public static int prependCborTypePrefix(byte[] dst, int offset, int type, long value) {
        if (value < 24L) {
            dst[--offset] = (byte)((long)type + value);
        } else {
            dst[--offset] = (byte)value;
            if (value < 256L) {
                type += 24;
            } else {
                dst[--offset] = (byte)(value >> 8);
                if (value < 65536L) {
                    type += 25;
                } else {
                    dst[--offset] = (byte)(value >> 16);
                    dst[--offset] = (byte)(value >> 24);
                    if (value < 0x100000000L) {
                        type += 26;
                    } else {
                        dst[--offset] = (byte)(value >> 32);
                        dst[--offset] = (byte)(value >> 40);
                        dst[--offset] = (byte)(value >> 48);
                        dst[--offset] = (byte)(value >> 56);
                        type += 27;
                    }
                }
            }
            dst[--offset] = (byte)type;
        }
        return offset;
    }

    public static int prependCborInteger(byte[] dst, int offset, long value) {
        long signum = value >> 63;
        return Encoder.prependCborTypePrefix(dst, offset, 0 | (int)signum & 0x20, value ^ signum);
    }

    public static boolean isDecimal(String number) {
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return true;
        }
        return false;
    }

    public static void flipCopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) throws IOException {
        if (length > src.length - srcOffset) {
            throw new IllegalArgumentException("Provided length does not exist in array: " + length);
        }
        if (length > dst.length - dstOffset) {
            throw new IllegalArgumentException("Provided length does not fit into array: " + length);
        }
        for (int i = 0; i < length; ++i) {
            dst[dstOffset + i] = ~src[srcOffset + i];
        }
    }
}

