/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.ExceptionTranslator;

public class BatchWriteItemRequestEncoder
extends RequestEncoder<BatchWriteItemRequest> {
    private static final int MAX_WRITE_BATCH_SIZE = 25;
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final SimpleCache<List<String>, Long> attributeListIdCache;
    private final AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable;

    public BatchWriteItemRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, SimpleCache<List<String>, Long> attributeListIdCache, AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals, AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.attributeListIdCache = attributeListIdCache;
        this.tableProjOrdinals = tableProjOrdinals;
        this.keysPerTable = keysPerTable;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, BatchWriteItemRequest request, ChannelPromise promise) throws Exception {
        if (request.requestItems() == null) {
            throw new IllegalArgumentException("1 validation error detected: Value '" + request.requestItems() + "' at 'requestItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        HashMap<String, List> requestByTable = new HashMap<String, List>();
        for (Map.Entry requestEntry : request.requestItems().entrySet()) {
            if (CollectionUtils.isNullOrEmpty((Collection)((Collection)requestEntry.getValue()))) continue;
            requestByTable.put((String)requestEntry.getKey(), (List)requestEntry.getValue());
        }
        HashMap tableKeysMap = new HashMap();
        HashMap attributeListIdMap = new HashMap();
        CompletableFuture[] tableKeysFutures = new CompletableFuture[requestByTable.size()];
        ArrayList futures = new ArrayList();
        int totalRequests = 0;
        int count = 0;
        for (Map.Entry requestEntry : requestByTable.entrySet()) {
            String tableName = (String)requestEntry.getKey();
            RequestValidator.validateTableName(tableName);
            List writeRequests = (List)requestEntry.getValue();
            if ((totalRequests += writeRequests.size()) > 25) {
                throw new IllegalArgumentException("Batch size should be less than 25");
            }
            tableKeysFutures[count] = this.cache.get(tableName).thenApply(tableKeys -> {
                tableKeysMap.put(tableName, tableKeys);
                Long[] attributeListIds = new Long[writeRequests.size()];
                int index = 0;
                for (WriteRequest writeRequest : writeRequests) {
                    if (writeRequest == null) {
                        ++index;
                        continue;
                    }
                    RequestValidator.validate(writeRequest);
                    if (writeRequest.putRequest() != null) {
                        PutRequest putRequest = writeRequest.putRequest();
                        Map attributes = putRequest.item();
                        RequestValidator.validateBatchWriteItem(attributes);
                        futures.add(AttributeValueEncoder.getAttributeListId(attributes, tableKeys, this.attributeListIdCache, attributeListIds, index));
                    }
                    attributeListIdMap.put(tableName, attributeListIds);
                    ++index;
                }
                return null;
            });
            ++count;
        }
        if (totalRequests == 0) {
            throw new IllegalArgumentException("1 validation error detected: Value '" + requestByTable + "' at 'requestItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        CompletableFuture.allOf(tableKeysFutures).whenComplete((placeholder0, ex) -> {
            if (ex != null) {
                promise.setFailure(ex);
            } else {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((placeholder, exception) -> {
                    try {
                        this.encodeAndWrite(ctx, request, promise, requestByTable, tableKeysMap, attributeListIdMap);
                    }
                    catch (Exception e) {
                        promise.setFailure((Throwable)e);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, BatchWriteItemRequest request, ChannelPromise promise, Map<String, List<WriteRequest>> requestByTable, Map<String, List<AttributeDefinition>> tableKeysMap, Map<String, Long[]> attributeListIdMap) throws Exception {
        SegmentPool.Segment requestTail;
        SegmentPool.Segment requestHead = requestTail = this.segmentPool.alloc();
        SegmentPool.Segment keyHead = this.segmentPool.alloc();
        SegmentPool.Segment valueHead = this.segmentPool.alloc();
        this.keysPerTable.compareAndSet(null, new HashMap());
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(AttributeValueEncoder.UnsignedComparator.INSTANCE);
        ByteBuf buffer = ctx.alloc().buffer();
        DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);
        try {
            requestTail = this.segmentPool.chainAppendCborMapPrefix(requestTail, requestByTable.size());
            for (Map.Entry<String, List<WriteRequest>> requestEntry : requestByTable.entrySet()) {
                String tableName = requestEntry.getKey();
                List<WriteRequest> writeRequests = requestEntry.getValue();
                List<AttributeDefinition> tableKeys = tableKeysMap.get(tableName);
                this.keysPerTable.get().put(tableName, tableKeys);
                keySet.clear();
                requestTail = this.segmentPool.chainAppendCborString(requestTail, tableName);
                int maxSizeHeaderLen = Encoder.calculateCborFieldSize(writeRequests.size() * 2);
                requestTail = this.segmentPool.chainRequire(requestTail, maxSizeHeaderLen);
                requestTail.mEnd += maxSizeHeaderLen;
                SegmentPool.Segment itemArrayStartSegment = requestTail;
                int itemArrayStartOffset = requestTail.mEnd;
                int requestItemCount = 0;
                boolean isEmpty = true;
                int index = 0;
                for (WriteRequest writeRequest : writeRequests) {
                    if (writeRequest == null) {
                        ++index;
                        continue;
                    }
                    isEmpty = false;
                    if (writeRequest.putRequest() != null) {
                        PutRequest putRequest = writeRequest.putRequest();
                        Map attributes = putRequest.item();
                        AttributeValueEncoder.encodeKey(this.segmentPool, keyHead, attributes, tableKeys);
                        int offset = AttributeValueEncoder.encodeAttributes((Map<String, AttributeValue>)attributes, tableKeys, attributeListIdMap.get(tableName)[index], this.segmentPool, valueHead);
                        byte[] key = this.segmentPool.chainCopyAndTrim(keyHead, 0);
                        if (!keySet.add(key)) {
                            throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                        }
                        requestTail = this.segmentPool.chainAppendCborBytes(requestTail, key);
                        requestTail = this.segmentPool.chainAppendCborBytes(requestTail, this.segmentPool.chainCopyAndTrim(valueHead, offset));
                        ++requestItemCount;
                    } else if (writeRequest.deleteRequest() != null) {
                        DeleteRequest deleteRequest = writeRequest.deleteRequest();
                        Map keys = deleteRequest.key();
                        AttributeValueEncoder.encodeKey(this.segmentPool, keyHead, keys, tableKeys);
                        byte[] key = this.segmentPool.chainCopyAndTrim(keyHead, 0);
                        if (!keySet.add(key)) {
                            throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                        }
                        requestTail = this.segmentPool.chainAppendCborBytes(requestTail, key);
                        requestTail = this.segmentPool.chainAppend(requestTail, (byte)-10);
                        ++requestItemCount;
                    }
                    ++index;
                }
                if (isEmpty) {
                    throw ExceptionTranslator.createValidationException("1 validation error detected: Value '{" + tableName + "=" + writeRequests + "}' at 'requestItems' failed to satisfy constraint: Map value must satisfy constraint: [Member must have length less than or equal to 25, Member must have length greater than or equal to 1");
                }
                Encoder.prependCborTypePrefix(itemArrayStartSegment.mBytes, itemArrayStartOffset, 128, requestItemCount * 2);
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.returnItemCollectionMetricsAsString());
            byte[] optional = DaxRequestEncoder.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, null, null, null, this.segmentPool);
            out.writeInt(1);
            out.writeInt(116217951);
            out.write(this.segmentPool.chainCopyAndTrim(requestHead, 0));
            if (optional == null) {
                out.writeNull();
            } else {
                out.write(optional);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
        finally {
            this.segmentPool.recycle(keyHead);
            this.segmentPool.recycle(valueHead);
            this.segmentPool.recycle(requestHead);
            out.close();
        }
    }
}

