/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.SimpleCache;

public class DeleteItemResponseHandler
extends ResponseHandler<DeleteItemResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final RefreshingCache<String, List<AttributeDefinition>> keyCache;
    private final DeleteItemRequest request;

    public DeleteItemResponseHandler(CompletableFuture<DeleteItemResponse> completableFuture, RefreshingCache<String, List<AttributeDefinition>> keyCache, SimpleCache<Long, List<String>> attrListCache, DeleteItemRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.keyCache = keyCache;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<DeleteItemResponse> completableFuture) throws Exception {
        this.keyCache.get(this.request.tableName()).whenComplete((keys, ex) -> {
            if (ex != null) {
                completableFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    ConcurrentHashMap<Constants.DaxResponseParam, Object> response = new ConcurrentHashMap<Constants.DaxResponseParam, Object>();
                    DaxResponseDecoder.decodeResponse(in, keys, this.attrListCache, response).whenComplete((res, e) -> {
                        if (e != null) {
                            completableFuture.completeExceptionally((Throwable)e);
                        } else {
                            completableFuture.complete(this.buildResponse((Map<Constants.DaxResponseParam, Object>)res, (List<AttributeDefinition>)keys));
                        }
                    });
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
    }

    private DeleteItemResponse buildResponse(Map<Constants.DaxResponseParam, Object> response, List<AttributeDefinition> keys) {
        ItemCollectionMetrics itemCollectionMetrics;
        ReturnItemCollectionMetrics returnItemCollectionMetrics;
        ReturnConsumedCapacity returnConsumedCapacity;
        DeleteItemResponse.Builder result = DeleteItemResponse.builder();
        Map item = (Map)response.get((Object)Constants.DaxResponseParam.Attributes);
        ConsumedCapacity consumedCapacity = (ConsumedCapacity)response.get((Object)Constants.DaxResponseParam.ConsumedCapacity);
        ReturnConsumedCapacity returnConsumedCapacity2 = returnConsumedCapacity = this.request.returnConsumedCapacity() == null ? ReturnConsumedCapacity.NONE : this.request.returnConsumedCapacity();
        if (!returnConsumedCapacity.equals((Object)ReturnConsumedCapacity.NONE)) {
            if (null == consumedCapacity) {
                consumedCapacity = DaxResponseDecoder.newZeroConsumedCapacity(this.request.tableName());
            }
            result.consumedCapacity(consumedCapacity);
        }
        ReturnItemCollectionMetrics returnItemCollectionMetrics2 = returnItemCollectionMetrics = this.request.returnItemCollectionMetrics() == null ? ReturnItemCollectionMetrics.NONE : this.request.returnItemCollectionMetrics();
        if (!returnItemCollectionMetrics.equals((Object)ReturnItemCollectionMetrics.NONE) && (itemCollectionMetrics = (ItemCollectionMetrics)response.get((Object)Constants.DaxResponseParam.ItemCollectionMetrics)) != null) {
            result.itemCollectionMetrics(itemCollectionMetrics);
        }
        if (item != null) {
            if (keys.size() == this.request.key().size()) {
                item.putAll(this.request.key());
            } else {
                for (AttributeDefinition key : keys) {
                    String keyName = key.attributeName();
                    item.put(keyName, (AttributeValue)this.request.key().get(keyName));
                }
            }
            result.attributes(item);
        }
        return (DeleteItemResponse)result.build();
    }
}

