/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.exceptions;

import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.exceptions.DaxServiceException;

public final class ExceptionTranslator {
    public static final String NOT_IMPLEMENTED = "NotImplementedException";

    private ExceptionTranslator() {
    }

    public static AwsServiceException translateException(DaxServiceException e) {
        int[] codes = e.getCodeSeq();
        if (codes.length < 2) {
            return e;
        }
        switch (codes[1]) {
            case 23: {
                if (codes.length <= 2) break;
                switch (codes[2]) {
                    case 24: {
                        return (AwsServiceException)ResourceNotFoundException.builder().awsErrorDetails(e.awsErrorDetails()).build();
                    }
                    case 35: {
                        return (AwsServiceException)ResourceInUseException.builder().awsErrorDetails(e.awsErrorDetails()).build();
                    }
                }
                break;
            }
            case 37: {
                if (codes.length <= 3) break;
                switch (codes[3]) {
                    case 39: {
                        DynamoDbException.Builder builder = null;
                        if (codes.length > 4) {
                            switch (codes[4]) {
                                case 40: {
                                    builder = ProvisionedThroughputExceededException.builder();
                                    break;
                                }
                                case 41: {
                                    builder = ResourceNotFoundException.builder();
                                    break;
                                }
                                case 43: {
                                    builder = ConditionalCheckFailedException.builder();
                                    break;
                                }
                                case 45: {
                                    builder = ResourceInUseException.builder();
                                    break;
                                }
                                case 47: {
                                    builder = InternalServerErrorException.builder();
                                    break;
                                }
                                case 48: {
                                    builder = ItemCollectionSizeLimitExceededException.builder();
                                    break;
                                }
                                case 49: {
                                    builder = LimitExceededException.builder();
                                    break;
                                }
                                case 46: 
                                case 50: {
                                    builder = DynamoDbException.builder();
                                    break;
                                }
                                case 57: {
                                    builder = TransactionConflictException.builder();
                                    break;
                                }
                                case 58: {
                                    builder = TransactionCanceledException.builder();
                                    break;
                                }
                                case 59: {
                                    builder = TransactionInProgressException.builder();
                                    break;
                                }
                                case 60: {
                                    builder = IdempotentParameterMismatchException.builder();
                                    break;
                                }
                            }
                        }
                        if (builder == null) {
                            builder = DynamoDbException.builder();
                        }
                        builder.requestId(e.requestId());
                        builder.statusCode(e.statusCode());
                        builder.awsErrorDetails(e.awsErrorDetails());
                        return builder.build();
                    }
                    case 44: {
                        return ExceptionTranslator.createValidationException(NOT_IMPLEMENTED);
                    }
                }
                break;
            }
        }
        return e;
    }

    public static AwsServiceException createValidationException(String errorMessage) {
        return new DaxServiceException(errorMessage, DynamoNumerals.ErrorCodes.VALIDATION_ERROR.mErrorCode);
    }
}

