/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.SimpleCache;

public class GetItemResponseHandler
extends ResponseHandler<GetItemResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final GetItemRequest request;
    private final AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals;

    public GetItemResponseHandler(CompletableFuture<GetItemResponse> completableFuture, SimpleCache<Long, List<String>> attrListCache, AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals, GetItemRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.request = request;
        this.projectionOrdinals = projectionOrdinals;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<GetItemResponse> completableFuture) throws Exception {
        if (in.tryReadNull()) {
            GetItemResponse.Builder getItemResponseBuilder = GetItemResponse.builder();
            if (this.request.returnConsumedCapacity() != null && !this.request.returnConsumedCapacity().equals((Object)ReturnConsumedCapacity.NONE)) {
                getItemResponseBuilder.consumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(this.request.tableName()));
            }
            completableFuture.complete((GetItemResponse)getItemResponseBuilder.build());
            return;
        }
        GetItemResponse.Builder responseBuilder = GetItemResponse.builder();
        CompletableFuture<Map<String, AttributeValue>> itemFuture = null;
        int i = in.streamMapLength();
        while (in.itemsRemaining(i)) {
            int paramId = in.readInt();
            Constants.DaxResponseParam param = Constants.DaxResponseParam.values()[paramId];
            switch (param) {
                case Item: {
                    itemFuture = AttributeValueDecoder.decodeValue(in, this.projectionOrdinals.get(), this.attrListCache);
                    break;
                }
                case ConsumedCapacity: {
                    responseBuilder.consumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(in));
                    break;
                }
                default: {
                    completableFuture.completeExceptionally(new UnsupportedEncodingException("Unknown value type: " + param.name()));
                }
            }
            --i;
        }
        if (itemFuture == null) {
            completableFuture.complete((GetItemResponse)responseBuilder.build());
        } else {
            itemFuture.whenComplete((item, e) -> {
                if (e != null) {
                    completableFuture.completeExceptionally((Throwable)e);
                } else {
                    if (item != null) {
                        if (this.projectionOrdinals.get() == null) {
                            item.putAll(this.request.key());
                        }
                        responseBuilder.item(item);
                    }
                    completableFuture.complete((GetItemResponse)responseBuilder.build());
                }
            });
        }
    }
}

