/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.staledns;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsHelper;
import software.amazon.jdbc.util.SubscribedMethodHelper;

public class AuroraStaleDnsPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(AuroraStaleDnsPlugin.class.getName());
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(SubscribedMethodHelper.NETWORK_BOUND_METHODS);
            this.add("initHostProvider");
            this.add("connect");
            this.add("notifyNodeListChanged");
        }
    });
    private final PluginService pluginService;
    private final AuroraStaleDnsHelper helper;
    private HostListProviderService hostListProviderService;

    public AuroraStaleDnsPlugin(PluginService pluginService, Properties properties) {
        this.pluginService = pluginService;
        this.helper = new AuroraStaleDnsHelper(this.pluginService);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.helper.getVerifiedConnection(isInitialConnection, this.hostListProviderService, driverProtocol, hostSpec, props, connectFunc);
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.hostListProviderService = hostListProviderService;
        initHostProviderFunc.call();
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        try {
            this.pluginService.refreshHostList();
        }
        catch (SQLException ex) {
            if (exceptionClass.isAssignableFrom(ex.getClass())) {
                throw (Exception)exceptionClass.cast(ex);
            }
            throw new RuntimeException(ex);
        }
        return jdbcMethodFunc.call();
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        this.helper.notifyNodeListChanged(changes);
    }
}

