/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.common.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;

public final class ClassPreLoader {
    public static final String CLASSES_FILE = "classesloaded.txt";

    private ClassPreLoader() {
    }

    public static void preloadClasses() {
        try {
            Enumeration<URL> files = ClassPreLoader.class.getClassLoader().getResources(CLASSES_FILE);
            while (files.hasMoreElements()) {
                URL url = files.nextElement();
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                InputStream is = conn.getInputStream();
                ClassPreLoader.preloadClassesFromStream(is);
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void preloadClassesFromStream(InputStream is) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                try {
                    block22: {
                        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                        try {
                            try (BufferedReader reader = new BufferedReader(isr);){
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    String className;
                                    int idx = line.indexOf(35);
                                    if (idx != -1) {
                                        line = line.substring(0, idx);
                                    }
                                    if ((className = line.stripTrailing()).isBlank()) continue;
                                    ClassPreLoader.loadClassIfFound(className);
                                }
                            }
                            if (isr == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (isr == null) throw throwable;
                            isr.close();
                            throw throwable;
                        }
                        isr.close();
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private static void loadClassIfFound(String className) {
        try {
            Class.forName(className, true, ClassPreLoader.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

