/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;

final class JsonUtils {
    private JsonUtils() {
    }

    static void serializeTimestamp(JsonSerializer generator, long timestamp, String timestampFormat, String timestampFormatTimezoneId, String timestampAttributeName) {
        String formattedTimestamp;
        if (timestampFormat == null || timestamp < 0L) {
            formattedTimestamp = String.valueOf(timestamp);
        } else {
            Date date = new Date(timestamp);
            SimpleDateFormat format = new SimpleDateFormat(timestampFormat);
            if (timestampFormatTimezoneId != null) {
                TimeZone tz = TimeZone.getTimeZone(timestampFormatTimezoneId);
                format.setTimeZone(tz);
            }
            formattedTimestamp = format.format(date);
        }
        generator.writeStringField(timestampAttributeName, formattedTimestamp);
    }

    static void serializeMDCEntries(Map<String, String> mdcPropertyMap, JsonSerializer serializer) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(mdcPropertyMap);
        for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
            if (PowertoolsLoggedFields.stringValues().contains(entry.getKey())) continue;
            JsonUtils.serializeMDCEntry(entry, serializer);
        }
    }

    static void serializeMDCEntry(Map.Entry<String, String> entry, JsonSerializer serializer) {
        serializer.writeRaw(',');
        serializer.writeFieldName(entry.getKey());
        if (JsonUtils.isString(entry.getValue())) {
            serializer.writeString(entry.getValue());
        } else {
            serializer.writeRaw(entry.getValue());
        }
    }

    static void serializeArguments(ILoggingEvent event, JsonSerializer serializer) throws IOException {
        Object[] arguments = event.getArgumentArray();
        if (arguments != null) {
            Object[] objectArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object argument = objectArray[n2];
                if (argument instanceof StructuredArgument) {
                    serializer.writeRaw(',');
                    ((StructuredArgument)argument).writeTo(serializer);
                }
                ++n2;
            }
        }
    }

    private static boolean isString(String str) {
        if (str == null) {
            return true;
        }
        if ("true".equals(str) || "false".equals(str)) {
            return false;
        }
        return !JsonUtils.isNumeric(str);
    }

    private static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return JsonUtils.withDecimalsParsing(str, 1);
        }
        return JsonUtils.withDecimalsParsing(str, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        int i = beginIdx;
        while (i < str.length()) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (!isDecimalPoint && !Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

