/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import software.xdev.mockserver.client.ClientException;
import software.xdev.mockserver.client.MockServerClient;
import software.xdev.mockserver.client.MockServerClientEventBus;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketClient;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketException;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.configuration.ClientConfiguration;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.mock.action.ExpectationCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardCallback;
import software.xdev.mockserver.mock.action.ExpectationResponseCallback;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.model.HttpMessage;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpOverrideForwardedRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.scheduler.SchedulerThreadFactory;
import software.xdev.mockserver.uuid.UUIDService;

public class ForwardChainExpectation {
    private final ClientConfiguration configuration;
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private final MockServerClientEventBus mockServerEventBus;

    ForwardChainExpectation(ClientConfiguration configuration, MockServerClientEventBus mockServerEventBus, MockServerClient mockServerClient, Expectation expectation) {
        this.configuration = configuration;
        this.mockServerEventBus = mockServerEventBus;
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public ForwardChainExpectation withId(String id) {
        this.expectation.withId(id);
        return this;
    }

    public ForwardChainExpectation withPriority(int priority) {
        this.expectation.withPriority(priority);
        return this;
    }

    public Expectation[] respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(HttpClassCallback httpClassCallback) {
        this.expectation.thenRespond(httpClassCallback);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(ExpectationResponseCallback expectationResponseCallback) {
        this.expectation.thenRespond(new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationResponseCallback, null)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(ExpectationResponseCallback expectationResponseCallback, Delay delay) {
        this.expectation.thenRespond((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationResponseCallback, null)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpClassCallback httpClassCallback) {
        this.expectation.thenForward(httpClassCallback);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback, null)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withResponseCallback(Boolean.valueOf(true)).withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback, expectationForwardResponseCallback)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback, null)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withResponseCallback(Boolean.valueOf(true)).withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback, expectationForwardResponseCallback)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        this.expectation.thenForward(httpOverrideForwardedRequest);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] error(HttpError httpError) {
        this.expectation.thenError(httpError);
        return this.mockServerClient.upsert(this.expectation);
    }

    private <T extends HttpMessage> String registerWebSocketClient(ExpectationCallback<T> expectationCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        try {
            String clientId = UUIDService.getUUID();
            LocalCallbackRegistry.registerCallback((String)clientId, expectationCallback);
            LocalCallbackRegistry.registerCallback((String)clientId, (ExpectationCallback)expectationForwardResponseCallback);
            WebSocketClient webSocketClient = new WebSocketClient((EventLoopGroup)new MultiThreadIoEventLoopGroup(this.configuration.webSocketClientEventLoopThreadCount().intValue(), (ThreadFactory)new SchedulerThreadFactory(WebSocketClient.class.getSimpleName() + "-eventLoop"), NioIoHandler.newFactory()), clientId);
            Future register = webSocketClient.registerExpectationCallback(expectationCallback, expectationForwardResponseCallback, this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath());
            this.mockServerEventBus.subscribe(() -> ((WebSocketClient)webSocketClient).stopClient(), MockServerClientEventBus.EventType.STOP, MockServerClientEventBus.EventType.RESET);
            return (String)register.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException) {
                throw new ClientException(e.getCause().getMessage(), e);
            }
            throw new ClientException("Unable to retrieve client registration id", e);
        }
    }

    Expectation getExpectation() {
        return this.expectation;
    }
}

