/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import tools.jackson.databind.util.ClassUtil;

public class DefaultTypeResolverBuilder
extends StdTypeResolverBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final PolymorphicTypeValidator _subtypeValidator;
    protected final DefaultTyping _appliesFor;

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = JsonTypeInfo.Id.CLASS;
        this._includeAs = includeAs;
        this._typeProperty = this._idType.getDefaultPropertyName();
    }

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, String propertyName) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = JsonTypeInfo.Id.CLASS;
        this._includeAs = JsonTypeInfo.As.PROPERTY;
        this._typeProperty = propertyName;
    }

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs, JsonTypeInfo.Id idType, String propertyName) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = idType;
        this._includeAs = includeAs;
        if (propertyName == null) {
            propertyName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = propertyName;
    }

    protected DefaultTypeResolverBuilder(DefaultTypeResolverBuilder base, Class<?> defaultImpl) {
        super(base, defaultImpl);
        this._subtypeValidator = base._subtypeValidator;
        this._appliesFor = base._appliesFor;
    }

    @Override
    public DefaultTypeResolverBuilder withDefaultImpl(Class<?> defaultImpl) {
        if (this._defaultImpl == defaultImpl) {
            return this;
        }
        ClassUtil.verifyMustOverride(DefaultTypeResolverBuilder.class, this, "withDefaultImpl");
        return new DefaultTypeResolverBuilder(this, defaultImpl);
    }

    @Override
    public PolymorphicTypeValidator subTypeValidator(DatabindContext ctxt) {
        return this._subtypeValidator;
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        return this.useForType(baseType) ? super.buildTypeDeserializer(ctxt, baseType, subtypes) : null;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        return this.useForType(baseType) ? super.buildTypeSerializer(ctxt, baseType, subtypes) : null;
    }

    public DefaultTypeResolverBuilder typeIdVisibility(boolean isVisible) {
        this._typeIdVisible = isVisible;
        return this;
    }

    public boolean useForType(JavaType t) {
        if (t.isPrimitive()) {
            return false;
        }
        switch (this._appliesFor) {
            case NON_CONCRETE_AND_ARRAYS: {
                t = this._unwrapArrayType(t);
            }
            case OBJECT_AND_NON_CONCRETE: {
                t = this._unwrapReferenceType(t);
                return t.isJavaLangObject() || !t.isConcrete() && !TreeNode.class.isAssignableFrom(t.getRawClass());
            }
            case NON_FINAL: {
                t = this._unwrapArrayType(t);
                t = this._unwrapReferenceType(t);
                return !t.isFinal() && !TreeNode.class.isAssignableFrom(t.getRawClass());
            }
            case NON_FINAL_AND_ENUMS: {
                t = this._unwrapArrayType(t);
                t = this._unwrapReferenceType(t);
                return !t.isFinal() && !TreeNode.class.isAssignableFrom(t.getRawClass()) || t.isEnumType();
            }
        }
        return t.isJavaLangObject();
    }

    protected JavaType _unwrapArrayType(JavaType t) {
        while (t.isArrayType()) {
            t = t.getContentType();
        }
        return t;
    }

    protected JavaType _unwrapReferenceType(JavaType t) {
        while (t.isReferenceType()) {
            t = t.getReferencedType();
        }
        return t;
    }
}

