/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.ser;

import java.util.function.ToIntFunction;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;

final class IntPropertyWriter
extends OptimizedBeanPropertyWriter<IntPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;
    private final ToIntFunction<Object> _acc;

    public IntPropertyWriter(BeanPropertyWriter src, ToIntFunction<Object> acc, ValueSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    protected IntPropertyWriter(IntPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableInt = base._suppressableInt;
        this._suppressableIntSet = base._suppressableIntSet;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new IntPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new IntPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            g.writeName(this._fastName);
            g.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            g.writeNumber(value);
        } else {
            this.serializeAsOmittedElement(bean, g, ctxt);
        }
    }
}

