/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.encode;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ws.schild.jave.encode.ArgType;
import ws.schild.jave.encode.EncodingArgument;
import ws.schild.jave.encode.EncodingAttributes;

public class VideoFilterArgument
implements EncodingArgument {
    private final ArgType argumentType;
    private final Function<EncodingAttributes, Stream<String>> getArguments;

    public VideoFilterArgument(ArgType argumentType, Function<EncodingAttributes, Stream<String>> getArguments) {
        this.argumentType = argumentType;
        this.getArguments = getArguments;
    }

    @Override
    public Stream<String> getArguments(EncodingAttributes context) {
        if (this.getArguments.apply(context).collect(Collectors.joining(", ")).isEmpty()) {
            return Stream.of(new String[0]);
        }
        return Stream.concat(Stream.of("-vf"), Stream.of(this.getArguments.apply(context).collect(Collectors.joining(", "))));
    }

    @Override
    public ArgType getArgType() {
        return this.argumentType;
    }
}

