/*
 * Decompiled with CFR 0.152.
 */
package xyz.urbanmatrix.mavlink.generator.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import xyz.urbanmatrix.mavlink.generator.DialectGenKt;
import xyz.urbanmatrix.mavlink.generator.EnumGenKt;
import xyz.urbanmatrix.mavlink.generator.EnumResolver;
import xyz.urbanmatrix.mavlink.generator.MessageGenKt;
import xyz.urbanmatrix.mavlink.generator.models.EnumModel;
import xyz.urbanmatrix.mavlink.generator.models.MavlinkModel;
import xyz.urbanmatrix.mavlink.generator.models.MessageModel;
import xyz.urbanmatrix.mavlink.generator.plugin.MavlinkDefinitionParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lxyz/urbanmatrix/mavlink/generator/plugin/MavlinkGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "definitions", "", "Ljava/io/File;", "generatedSourcesDir", "getGeneratedSourcesDir", "()Ljava/io/File;", "setGeneratedSourcesDir", "(Ljava/io/File;)V", "generate", "", "include", "file", "includeDir", "dir", "Companion", "generator"})
public abstract class MavlinkGeneratorTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @OutputDirectory
    public File generatedSourcesDir;
    @NotNull
    private final Set<File> definitions = new LinkedHashSet();
    @NotNull
    private static final String BASE_PACKAGE = "xyz.urbanmatrix.mavlink.definitions";

    @NotNull
    public final File getGeneratedSourcesDir() {
        File file = this.generatedSourcesDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"generatedSourcesDir");
        return null;
    }

    public final void setGeneratedSourcesDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.generatedSourcesDir = file;
    }

    public final void include(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ((Collection)this.definitions).add(file);
    }

    public final void includeDir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Collection collection = this.definitions;
        Object[] objectArray = dir.listFiles();
        Intrinsics.checkNotNull((Object)objectArray);
        CollectionsKt.addAll((Collection)collection, (Iterable)ArraysKt.toSet((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generate() {
        void $this$mapTo$iv$iv;
        if (this.definitions.isEmpty()) {
            throw new IllegalArgumentException("No XML definition provided.");
        }
        for (File def : this.definitions) {
            if (def.isFile()) continue;
            throw new IllegalArgumentException("Not a file: " + def);
        }
        for (File def : this.definitions) {
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)def), (Object)"xml")) continue;
            throw new IllegalArgumentException("Not a mavlink definition file: " + def);
        }
        if (this.generatedSourcesDir == null) {
            throw new IllegalArgumentException("No generated source directory provided.");
        }
        if (!this.getGeneratedSourcesDir().isDirectory()) {
            throw new IllegalArgumentException("Generated sources directory should be a directory.");
        }
        if (this.getGeneratedSourcesDir().exists() && !FilesKt.deleteRecursively((File)this.getGeneratedSourcesDir())) {
            throw new IllegalArgumentException("Cannot delete generated sources directory.");
        }
        if (!this.getGeneratedSourcesDir().mkdirs()) {
            throw new IllegalArgumentException("Cannot create generated sources directory.");
        }
        Iterable $this$map$iv = this.definitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MavlinkModel mavlinkModel;
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                mavlinkModel = MavlinkDefinitionParser.INSTANCE.parse((File)it);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid mavlink schema: " + it);
            }
            collection.add(mavlinkModel);
        }
        List mavlinkModels = (List)destination$iv$iv;
        EnumResolver enumResolver = new EnumResolver(BASE_PACKAGE, mavlinkModels);
        for (MavlinkModel model : mavlinkModels) {
            DialectGenKt.generateDialectFile(model, BASE_PACKAGE).writeTo(this.getGeneratedSourcesDir());
            String packageName = "xyz.urbanmatrix.mavlink.definitions." + model.getSubPackageName();
            for (EnumModel enumModel : model.getEnums()) {
                EnumGenKt.generateEnumFile(enumModel, packageName).writeTo(this.getGeneratedSourcesDir());
            }
            for (MessageModel message : model.getMessages()) {
                MessageGenKt.generateMessageFile(message, packageName, enumResolver).writeTo(this.getGeneratedSourcesDir());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lxyz/urbanmatrix/mavlink/generator/plugin/MavlinkGeneratorTask$Companion;", "", "()V", "BASE_PACKAGE", "", "generator"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

