/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PublishConfiguration;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.provider.maven.PactBaseMojo;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lau/com/dius/pact/provider/maven/PactBaseMojo;", "()V", "branchName", "", "getBranchName", "()Ljava/lang/String;", "setBranchName", "(Ljava/lang/String;)V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "buildUrl", "getBuildUrl", "setBuildUrl", "excludes", "", "pactDirectory", "projectVersion", "skipPactPublish", "", "tags", "trimSnapshot", "calculateTags", "", "execute", "", "pactFileIsExcluded", "exclusions", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "maven"})
@Mojo(name="publish")
@SourceDebugExtension(value={"SMAP\nPactPublishMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PactPublishMojo.kt\nau/com/dius/pact/provider/maven/PactPublishMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,114:1\n1549#2:115\n1620#2,3:116\n1549#2:121\n1620#2,3:122\n1747#2,3:125\n1295#3,2:119\n*S KotlinDebug\n*F\n+ 1 PactPublishMojo.kt\nau/com/dius/pact/provider/maven/PactPublishMojo\n*L\n71#1:115\n71#1:116,3\n105#1:121\n105#1:122,3\n112#1:125,3\n73#1:119,2\n*E\n"})
public class PactPublishMojo
extends PactBaseMojo {
    @Parameter(property="skipPactPublish", defaultValue="false")
    private boolean skipPactPublish;
    @Parameter(property="pact.projectVersion", defaultValue="${project.version}", required=true)
    private String projectVersion;
    @Parameter(property="pact.trimSnapshot", defaultValue="false")
    private boolean trimSnapshot;
    @Parameter(property="pact.pactDirectory", defaultValue="${project.build.directory}/pacts")
    private String pactDirectory;
    @Nullable
    private PactBrokerClient brokerClient;
    @Parameter
    @NotNull
    private List<String> tags = new ArrayList();
    @Parameter
    @NotNull
    private List<String> excludes = new ArrayList();
    @Parameter
    @Nullable
    private String branchName;
    @Parameter
    @Nullable
    private String buildUrl;

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    public final void setBranchName(@Nullable String string) {
        this.branchName = string;
    }

    @Nullable
    public final String getBuildUrl() {
        return this.buildUrl;
    }

    public final void setBuildUrl(@Nullable String string) {
        this.buildUrl = string;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        String string;
        if (this.skipPactPublish) {
            System.out.println((Object)"'skipPactPublish' is set to true, skipping uploading of pacts");
            return;
        }
        CharSequence charSequence = this.getPactBrokerUrl();
        if ((charSequence == null || charSequence.length() == 0) && this.brokerClient == null) {
            throw new MojoExecutionException("pactBrokerUrl is required");
        }
        String snapShotDefinitionString = "-SNAPSHOT";
        if (this.trimSnapshot) {
            String string2 = this.projectVersion;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                string2 = null;
            }
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                String string3;
                String string4;
                Regex snapshotRegex = new Regex(".*(" + snapShotDefinitionString + ")");
                String string5 = this.projectVersion;
                if (string5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    string5 = string4 = null;
                }
                if ((string3 = this.projectVersion) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    string3 = null;
                }
                MatchResult matchResult = Regex.find$default((Regex)snapshotRegex, (CharSequence)string3, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                IntRange intRange = matchGroup.getRange();
                this.projectVersion = ((Object)StringsKt.removeRange((CharSequence)string4, (IntRange)intRange)).toString();
            }
        }
        if (this.brokerClient == null) {
            String string6 = this.getPactBrokerUrl();
            Intrinsics.checkNotNull((Object)string6);
            this.brokerClient = new PactBrokerClient(string6, this.brokerClientOptions(), this.brokerClientConfig());
        }
        if ((string = this.pactDirectory) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
            string = null;
        }
        File pactDirectory = new File(string);
        List<String> tagsToPublish = this.calculateTags();
        String string7 = this.projectVersion;
        if (string7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            string7 = null;
        }
        PublishConfiguration publishConfiguration = new PublishConfiguration(string7, tagsToPublish, this.branchName, this.buildUrl);
        if (!pactDirectory.exists()) {
            System.out.println((Object)("Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts"));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string8 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Regex((String)it));
            }
            List excludedList = (List)destination$iv$iv;
            boolean anyFailed = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File pactFile = (File)element$iv;
                boolean bl = false;
                if (this.pactFileIsExcluded(excludedList, pactFile)) {
                    System.out.println((Object)("Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list"));
                    continue;
                }
                if (KotlinLanguageSupportKt.isNotEmpty(tagsToPublish)) {
                    System.out.println((Object)("Publishing '" + pactFile.getName() + "' with tags '" + CollectionsKt.joinToString$default((Iterable)tagsToPublish, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "' ... "));
                } else {
                    System.out.println((Object)("Publishing '" + pactFile.getName() + "' ... "));
                }
                PactBrokerClient pactBrokerClient = this.brokerClient;
                Intrinsics.checkNotNull((Object)pactBrokerClient);
                Result result = pactBrokerClient.uploadPactFile(pactFile, publishConfiguration);
                if (result instanceof Result.Ok) {
                    System.out.println((Object)"OK");
                    continue;
                }
                if (!(result instanceof Result.Err)) continue;
                Exception error = (Exception)((Result.Err)result).getError();
                System.out.println((Object)("Failed - " + ((Exception)((Result.Err)result).getError()).getMessage()));
                if (error instanceof RequestFailedException && KotlinLanguageSupportKt.isNotEmpty((String)((RequestFailedException)error).getBody())) {
                    System.out.println((Object)((RequestFailedException)error).getBody());
                }
                anyFailed = true;
            }
            if (anyFailed) {
                throw new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> calculateTags() {
        List list;
        String property = System.getProperty("pact.consumer.tags");
        if (KotlinLanguageSupportKt.isNotEmpty((String)property)) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)property, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tags;
        }
        return list;
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

