/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EVN
extends AbstractSegment {
    public EVN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(3)}, "EVENT TYPE CODE");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "DATE/TIME OF EVENT");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DATE/TIME PLANNED EVENT");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(62)}, "EVENT REASON CODE");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EVN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getEVENTTYPECODE() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getEvn1_EVENTTYPECODE() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDATETIMEOFEVENT() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getEvn2_DATETIMEOFEVENT() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDATETIMEPLANNEDEVENT() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEvn3_DATETIMEPLANNEDEVENT() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getEVENTREASONCODE() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getEvn4_EVENTREASONCODE() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(3));
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(62));
            }
        }
        return null;
    }
}

