/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv1.lambda;

import cloud.localstack.LambdaExecutor;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.s3.event.S3EventNotification;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class S3EventParser {
    public static S3Event parse(List<Map<String, Object>> records) {
        Map<String, Object> record = records.get(0);
        Map rp = (Map)LambdaExecutor.get(record, "requestParameters");
        String sip = (String)LambdaExecutor.get(rp, "sourceIPAddress");
        Map re = (Map)LambdaExecutor.get(record, "responseElements");
        String xAmzld2 = (String)LambdaExecutor.get(re, "x-amz-id-2");
        String xAmzRequestId = (String)LambdaExecutor.get(re, "x-amz-request-id");
        Map s3 = (Map)LambdaExecutor.get(record, "s3");
        Map bk = (Map)LambdaExecutor.get(s3, "bucket");
        Map oi = (Map)LambdaExecutor.get(bk, "ownerIdentity");
        String bucketPrincipalId = (String)LambdaExecutor.get(oi, "principalId");
        String bucketName = (String)LambdaExecutor.get(bk, "name");
        String arn = (String)LambdaExecutor.get(bk, "arn");
        String s3SchemaVersion = (String)LambdaExecutor.get(s3, "s3SchemaVersion");
        Map obj = (Map)LambdaExecutor.get(s3, "object");
        String key = (String)LambdaExecutor.get(obj, "key");
        Long size = ((Number)LambdaExecutor.get(obj, "size")).longValue();
        String eTag = (String)LambdaExecutor.get(obj, "eTag");
        String versionId = (String)LambdaExecutor.get(obj, "versionId");
        String sequencer = (String)LambdaExecutor.get(obj, "sequencer");
        String configurationId = (String)LambdaExecutor.get(s3, "configurationId");
        String awsRegion = (String)LambdaExecutor.get(record, "awsRegion");
        String eventName = (String)LambdaExecutor.get(record, "eventName");
        String eventSource = (String)LambdaExecutor.get(record, "eventSource");
        String eventTime = (String)LambdaExecutor.get(record, "eventTime");
        String eventVersion = (String)LambdaExecutor.get(record, "eventVersion");
        Map ui = (Map)LambdaExecutor.get(record, "userIdentity");
        String principalId = (String)LambdaExecutor.get(ui, "principalId");
        LinkedList<S3EventNotification.S3EventNotificationRecord> s3Records = new LinkedList<S3EventNotification.S3EventNotificationRecord>();
        S3EventNotification.UserIdentityEntity bucketUserIdentityEntity = new S3EventNotification.UserIdentityEntity(bucketPrincipalId);
        S3EventNotification.S3BucketEntity bucket = new S3EventNotification.S3BucketEntity(bucketName, bucketUserIdentityEntity, arn);
        S3EventNotification.S3ObjectEntity s3ObjectEntity = new S3EventNotification.S3ObjectEntity(key, size, eTag, versionId, sequencer);
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(configurationId, bucket, s3ObjectEntity, s3SchemaVersion);
        S3EventNotification.RequestParametersEntity requestParameters = new S3EventNotification.RequestParametersEntity(sip);
        S3EventNotification.ResponseElementsEntity responseEntity = new S3EventNotification.ResponseElementsEntity(xAmzld2, xAmzRequestId);
        S3EventNotification.UserIdentityEntity eventNotifyUserIdentityEntity = new S3EventNotification.UserIdentityEntity(principalId);
        S3EventNotification.S3EventNotificationRecord s3record = new S3EventNotification.S3EventNotificationRecord(awsRegion, eventName, eventSource, eventTime, eventVersion, requestParameters, responseEntity, s3Entity, eventNotifyUserIdentityEntity);
        s3Records.add(0, s3record);
        return new S3Event(s3Records);
    }
}

