/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.swing.clipboard;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.swing.clipboard.ClipboardListener;
import cn.hutool.core.swing.clipboard.ClipboardMonitor;
import cn.hutool.core.swing.clipboard.ImageSelection;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardUtil {
    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        ClipboardUtil.set(contents, null);
    }

    public static void set(Transferable contents, ClipboardOwner owner) {
        ClipboardUtil.getClipboard().setContents(contents, owner);
    }

    public static Object get(DataFlavor flavor) {
        return ClipboardUtil.get(ClipboardUtil.getClipboard().getContents(null), flavor);
    }

    public static Object get(Transferable content, DataFlavor flavor) {
        if (null != content && content.isDataFlavorSupported(flavor)) {
            try {
                return content.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new UtilException(e);
            }
        }
        return null;
    }

    public static void setStr(String text) {
        ClipboardUtil.set(new StringSelection(text));
    }

    public static String getStr() {
        return (String)ClipboardUtil.get(DataFlavor.stringFlavor);
    }

    public static String getStr(Transferable content) {
        return (String)ClipboardUtil.get(content, DataFlavor.stringFlavor);
    }

    public static void setImage(Image image) {
        ClipboardUtil.set(new ImageSelection(image), null);
    }

    public static Image getImage() {
        return (Image)ClipboardUtil.get(DataFlavor.imageFlavor);
    }

    public static Image getImage(Transferable content) {
        return (Image)ClipboardUtil.get(content, DataFlavor.imageFlavor);
    }

    public static void listen(ClipboardListener listener) {
        ClipboardUtil.listen(listener, true);
    }

    public static void listen(ClipboardListener listener, boolean sync) {
        ClipboardUtil.listen(10, 100L, listener, sync);
    }

    public static void listen(int tryCount, long delay, ClipboardListener listener, boolean sync) {
        ClipboardMonitor.INSTANCE.setTryCount(tryCount).setDelay(delay).addListener(listener).listen(sync);
    }
}

