/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.AlibabaCloudServiceSettings;
import co.elastic.clients.elasticsearch.inference.AlibabaCloudServiceType;
import co.elastic.clients.elasticsearch.inference.AlibabaCloudTaskSettings;
import co.elastic.clients.elasticsearch.inference.AlibabaCloudTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAlibabacloudResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAlibabacloudRequest
extends RequestBase
implements JsonpSerializable {
    private final String alibabacloudInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AlibabaCloudServiceType service;
    private final AlibabaCloudServiceSettings serviceSettings;
    @Nullable
    private final AlibabaCloudTaskSettings taskSettings;
    private final AlibabaCloudTaskType taskType;
    public static final JsonpDeserializer<PutAlibabacloudRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAlibabacloudRequest::setupPutAlibabacloudRequestDeserializer);
    public static final Endpoint<PutAlibabacloudRequest, PutAlibabacloudResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAlibabacloudRequest, PutAlibabacloudResponse>("es/inference.put_alibabacloud", request -> "PUT", request -> {
        boolean _taskType = true;
        int _alibabacloudInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.alibabacloudInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _alibabacloudInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("alibabacloudInferenceId", request.alibabacloudInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutAlibabacloudResponse._DESERIALIZER);

    private PutAlibabacloudRequest(Builder builder) {
        this.alibabacloudInferenceId = ApiTypeHelper.requireNonNull(builder.alibabacloudInferenceId, this, "alibabacloudInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutAlibabacloudRequest of(Function<Builder, ObjectBuilder<PutAlibabacloudRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String alibabacloudInferenceId() {
        return this.alibabacloudInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AlibabaCloudServiceType service() {
        return this.service;
    }

    public final AlibabaCloudServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AlibabaCloudTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final AlibabaCloudTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutAlibabacloudRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AlibabaCloudServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AlibabaCloudServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AlibabaCloudTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAlibabacloudRequest> {
        private String alibabacloudInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AlibabaCloudServiceType service;
        private AlibabaCloudServiceSettings serviceSettings;
        @Nullable
        private AlibabaCloudTaskSettings taskSettings;
        private AlibabaCloudTaskType taskType;

        public final Builder alibabacloudInferenceId(String value) {
            this.alibabacloudInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AlibabaCloudServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AlibabaCloudServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AlibabaCloudServiceSettings.Builder, ObjectBuilder<AlibabaCloudServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AlibabaCloudServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AlibabaCloudTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AlibabaCloudTaskSettings.Builder, ObjectBuilder<AlibabaCloudTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AlibabaCloudTaskSettings.Builder()).build());
        }

        public final Builder taskType(AlibabaCloudTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAlibabacloudRequest build() {
            this._checkSingleUse();
            return new PutAlibabacloudRequest(this);
        }
    }
}

