/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.NumberPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IntegerNumberProperty
extends NumberPropertyBase
implements PropertyVariant {
    @Nullable
    private final Integer nullValue;
    public static final JsonpDeserializer<IntegerNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntegerNumberProperty::setupIntegerNumberPropertyDeserializer);

    private IntegerNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static IntegerNumberProperty of(Function<Builder, ObjectBuilder<IntegerNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Integer;
    }

    @Nullable
    public final Integer nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "integer");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.intValue());
        }
    }

    protected static void setupIntegerNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        NumberPropertyBase.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.integerDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IntegerNumberProperty> {
        @Nullable
        private Integer nullValue;

        public final Builder nullValue(@Nullable Integer value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IntegerNumberProperty build() {
            this._checkSingleUse();
            return new IntegerNumberProperty(this);
        }
    }
}

