/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_data_stream_options.DataStreamWithOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetDataStreamOptionsResponse
implements JsonpSerializable {
    private final List<DataStreamWithOptions> dataStreams;
    public static final JsonpDeserializer<GetDataStreamOptionsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataStreamOptionsResponse::setupGetDataStreamOptionsResponseDeserializer);

    private GetDataStreamOptionsResponse(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
    }

    public static GetDataStreamOptionsResponse of(Function<Builder, ObjectBuilder<GetDataStreamOptionsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataStreamWithOptions> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (DataStreamWithOptions item0 : this.dataStreams) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetDataStreamOptionsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamWithOptions._DESERIALIZER), "data_streams");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetDataStreamOptionsResponse> {
        private List<DataStreamWithOptions> dataStreams;

        public final Builder dataStreams(List<DataStreamWithOptions> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(DataStreamWithOptions value, DataStreamWithOptions ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<DataStreamWithOptions.Builder, ObjectBuilder<DataStreamWithOptions>> fn) {
            return this.dataStreams(fn.apply(new DataStreamWithOptions.Builder()).build(), new DataStreamWithOptions[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataStreamOptionsResponse build() {
            this._checkSingleUse();
            return new GetDataStreamOptionsResponse(this);
        }
    }
}

