/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.BufferingJsonParser;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.LookAheadJsonParser;
import co.elastic.clients.json.UnexpectedJsonEventException;
import co.elastic.clients.json.jackson.Jackson3JsonBuffer;
import co.elastic.clients.json.jackson.Jackson3JsonValueParser;
import co.elastic.clients.json.jackson.Jackson3JsonpLocation;
import co.elastic.clients.json.jackson.Jackson3JsonpMapper;
import co.elastic.clients.json.jackson.Jackson3Utils;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.util.JsonParserSequence;
import tools.jackson.databind.util.TokenBuffer;

public class Jackson3JsonpParser
implements LookAheadJsonParser,
BufferingJsonParser {
    private final tools.jackson.core.JsonParser parser;
    private final Jackson3JsonpMapper mapper;
    private boolean hasNextWasCalled = false;
    private static final EnumMap<JsonToken, JsonParser.Event> tokenToEvent = new EnumMap(JsonToken.class);
    private Jackson3JsonValueParser valueParser;

    public Jackson3JsonpParser(tools.jackson.core.JsonParser parser, Jackson3JsonpMapper mapper) {
        this.parser = parser;
        this.mapper = mapper;
    }

    public tools.jackson.core.JsonParser jacksonParser() {
        return this.parser;
    }

    private JsonParsingException convertException(StreamReadException ex) {
        return new JsonParsingException("Jackson exception: " + ex.getMessage(), (Throwable)ex, this.getLocation());
    }

    private JsonToken fetchNextToken() {
        try {
            return this.parser.nextToken();
        }
        catch (StreamReadException e) {
            throw this.convertException(e);
        }
    }

    private void ensureTokenIsCurrent() {
        if (this.hasNextWasCalled) {
            throw new IllegalStateException("Cannot get event data as parser as already been moved to the next event");
        }
    }

    public boolean hasNext() {
        if (this.hasNextWasCalled) {
            return this.parser.currentToken() != null;
        }
        this.hasNextWasCalled = true;
        return this.fetchNextToken() != null;
    }

    public JsonParser.Event next() {
        JsonToken token;
        if (this.hasNextWasCalled) {
            token = this.parser.currentToken();
            this.hasNextWasCalled = false;
        } else {
            token = this.fetchNextToken();
        }
        if (token == null) {
            throw new NoSuchElementException();
        }
        JsonParser.Event result = tokenToEvent.get(token);
        if (result == null) {
            throw new JsonParsingException("Unsupported Jackson event type '" + String.valueOf(token) + "'", this.getLocation());
        }
        return result;
    }

    public String getString() {
        this.ensureTokenIsCurrent();
        return this.parser.getValueAsString();
    }

    public boolean isIntegralNumber() {
        this.ensureTokenIsCurrent();
        return this.parser.isExpectedNumberIntToken();
    }

    public int getInt() {
        this.ensureTokenIsCurrent();
        return this.parser.getIntValue();
    }

    public long getLong() {
        this.ensureTokenIsCurrent();
        return this.parser.getLongValue();
    }

    public BigDecimal getBigDecimal() {
        this.ensureTokenIsCurrent();
        return this.parser.getDecimalValue();
    }

    public JsonLocation getLocation() {
        return new Jackson3JsonpLocation(this.parser.currentLocation());
    }

    public void close() {
        this.parser.close();
    }

    public JsonObject getObject() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Unexpected event '" + String.valueOf(this.parser.currentToken()) + "' at " + String.valueOf(this.parser.currentTokenLocation()));
        }
        if (this.valueParser == null) {
            this.valueParser = new Jackson3JsonValueParser();
        }
        return this.valueParser.parseObject(this.parser);
    }

    public JsonArray getArray() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new Jackson3JsonValueParser();
        }
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Unexpected event '" + String.valueOf(this.parser.currentToken()) + "' at " + String.valueOf(this.parser.currentTokenLocation()));
        }
        return this.valueParser.parseArray(this.parser);
    }

    public JsonValue getValue() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new Jackson3JsonValueParser();
        }
        return this.valueParser.parseValue(this.parser);
    }

    public void skipObject() {
        JsonToken token;
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            return;
        }
        int depth = 1;
        do {
            token = this.parser.nextToken();
            switch (token) {
                case START_OBJECT: {
                    ++depth;
                    break;
                }
                case END_OBJECT: {
                    --depth;
                }
            }
        } while (token != JsonToken.END_OBJECT || depth != 0);
    }

    public void skipArray() {
        JsonToken token;
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            return;
        }
        int depth = 1;
        do {
            token = this.parser.nextToken();
            switch (token) {
                case START_ARRAY: {
                    ++depth;
                    break;
                }
                case END_ARRAY: {
                    --depth;
                }
            }
        } while (token != JsonToken.END_ARRAY || depth != 0);
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    public Stream<JsonValue> getArrayStream() {
        return this.getArray().stream();
    }

    public Stream<JsonValue> getValueStream() {
        return LookAheadJsonParser.super.getValueStream();
    }

    @Override
    public Map.Entry<String, JsonParser> lookAheadFieldValue(String name, String defaultValue) {
        TokenBuffer tb = TokenBuffer.forBuffering((tools.jackson.core.JsonParser)this.parser, (ObjectReadContext)this.parser.objectReadContext());
        try {
            tb.copyCurrentEvent(this.parser);
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                this.expectEvent(JsonToken.PROPERTY_NAME);
                String fieldName = this.parser.currentName();
                if (fieldName.equals(name)) {
                    tb.copyCurrentEvent(this.parser);
                    String result = null;
                    switch (this.parser.nextToken()) {
                        case VALUE_STRING: {
                            result = this.parser.getText();
                            break;
                        }
                        case VALUE_TRUE: {
                            result = "true";
                            break;
                        }
                        case VALUE_FALSE: {
                            result = "false";
                            break;
                        }
                        default: {
                            this.expectEvent(JsonToken.VALUE_STRING);
                        }
                    }
                    tb.copyCurrentEvent(this.parser);
                    return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(result, new Jackson3JsonpParser((tools.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (tools.jackson.core.JsonParser)tb.asParser(), (tools.jackson.core.JsonParser)this.parser), this.mapper));
                }
                tb.copyCurrentStructure(this.parser);
            }
            tb.copyCurrentEvent(this.parser);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(defaultValue, new Jackson3JsonpParser((tools.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (tools.jackson.core.JsonParser)tb.asParser(), (tools.jackson.core.JsonParser)this.parser), this.mapper));
    }

    @Override
    public <Variant> Map.Entry<Variant, JsonParser> findVariant(Map<String, Variant> variants) {
        TokenBuffer tb = TokenBuffer.forBuffering((tools.jackson.core.JsonParser)this.parser, (ObjectReadContext)this.parser.objectReadContext());
        try {
            if (this.parser.currentToken() != JsonToken.START_OBJECT) {
                tb.copyCurrentStructure(this.parser);
            } else {
                tb.copyCurrentEvent(this.parser);
                while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                    this.expectEvent(JsonToken.PROPERTY_NAME);
                    String fieldName = this.parser.currentName();
                    Variant variant = variants.get(fieldName);
                    if (variant != null) {
                        tb.copyCurrentEvent(this.parser);
                        return new AbstractMap.SimpleImmutableEntry<Variant, Jackson3JsonpParser>(variant, new Jackson3JsonpParser((tools.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (tools.jackson.core.JsonParser)tb.asParser(), (tools.jackson.core.JsonParser)this.parser), this.mapper));
                    }
                    tb.copyCurrentStructure(this.parser);
                }
                tb.copyCurrentEvent(this.parser);
            }
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Jackson3JsonpParser>(null, new Jackson3JsonpParser((tools.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (tools.jackson.core.JsonParser)tb.asParser(), (tools.jackson.core.JsonParser)this.parser), this.mapper));
    }

    private void expectNextEvent(JsonToken expected) throws IOException {
        JsonToken event = this.parser.nextToken();
        if (event != expected) {
            throw new UnexpectedJsonEventException((JsonParser)this, tokenToEvent.get(event), tokenToEvent.get(expected));
        }
    }

    private void expectEvent(JsonToken expected) {
        JsonToken event = this.parser.currentToken();
        if (event != expected) {
            throw new UnexpectedJsonEventException((JsonParser)this, tokenToEvent.get(event), tokenToEvent.get(expected));
        }
    }

    @Override
    public JsonData getJsonData() {
        try {
            TokenBuffer buffer = TokenBuffer.forBuffering((tools.jackson.core.JsonParser)this.parser, (ObjectReadContext)this.parser.objectReadContext());
            buffer.copyCurrentStructure(this.parser);
            return new Jackson3JsonBuffer(buffer, this.mapper);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
    }

    static {
        tokenToEvent.put(JsonToken.END_ARRAY, JsonParser.Event.END_ARRAY);
        tokenToEvent.put(JsonToken.END_OBJECT, JsonParser.Event.END_OBJECT);
        tokenToEvent.put(JsonToken.PROPERTY_NAME, JsonParser.Event.KEY_NAME);
        tokenToEvent.put(JsonToken.START_ARRAY, JsonParser.Event.START_ARRAY);
        tokenToEvent.put(JsonToken.START_OBJECT, JsonParser.Event.START_OBJECT);
        tokenToEvent.put(JsonToken.VALUE_FALSE, JsonParser.Event.VALUE_FALSE);
        tokenToEvent.put(JsonToken.VALUE_NULL, JsonParser.Event.VALUE_NULL);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_FLOAT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_INT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_STRING, JsonParser.Event.VALUE_STRING);
        tokenToEvent.put(JsonToken.VALUE_TRUE, JsonParser.Event.VALUE_TRUE);
    }
}

