/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.transport.http.TransportHttpClient;
import java.io.IOException;
import javax.annotation.Nullable;

public class TransportException
extends IOException {
    private final String endpointId;
    private final TransportHttpClient.Response response;

    public TransportException(TransportHttpClient.Response response, String message, String endpointId) {
        this(response, message, endpointId, null);
    }

    public TransportException(TransportHttpClient.Response response, String message, String endpointId, Throwable cause) {
        super("node: " + String.valueOf(response.node()) + ", status: " + response.statusCode() + ", " + (String)(endpointId == null ? message : "[" + endpointId + "] " + message), cause);
        this.response = response;
        this.endpointId = endpointId;
        try {
            response.close();
        }
        catch (Exception e) {
            this.addSuppressed(e);
        }
    }

    public int statusCode() {
        return this.response.statusCode();
    }

    @Nullable
    public String endpointId() {
        return this.endpointId;
    }

    public TransportHttpClient.Response response() {
        return this.response;
    }
}

