/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Counter
implements JsonpSerializable {
    private final long active;
    private final long total;
    public static final JsonpDeserializer<Counter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Counter::setupCounterDeserializer);

    protected Counter(AbstractBuilder<?> builder) {
        this.active = ApiTypeHelper.requireNonNull(builder.active, (Object)this, "active", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
    }

    public static Counter counterOf(Function<Builder, ObjectBuilder<Counter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long active() {
        return this.active;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("total");
        generator.write(this.total);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCounterDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::active, JsonpDeserializer.longDeserializer(), "active");
        op.add(AbstractBuilder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Long active;
        private Long total;

        public final BuilderT active(long value) {
            this.active = value;
            return (BuilderT)this.self();
        }

        public final BuilderT total(long value) {
            this.total = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Counter> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Counter build() {
            this._checkSingleUse();
            return new Counter(this);
        }
    }
}

