/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.ClientRequest;
import com.adobe.aem.dermis.model.ExecutionContext;

public class RequestExecutionContext
extends ExecutionContext {
    private ClientRequest clientRequest;

    protected RequestExecutionContext(ExecutionContext environment, ClientRequest request) throws DermisException {
        super(environment.getQuery(), environment.getAuthDetails(), environment.getConfiguration());
        this.clientRequest = request;
    }

    public static RequestExecutionContext of(ExecutionContext environment, ClientRequest request) throws DermisException {
        if (environment == null) {
            throw new DermisException("Missing environment details");
        }
        if (environment.getConfiguration() == null) {
            throw new DermisException("Missing configuration details");
        }
        if (request == null) {
            throw new DermisException("Missing client request details");
        }
        return new RequestExecutionContext(environment, request);
    }

    public ClientRequest getDermisClientRequest() {
        return this.clientRequest;
    }

    public void setDermisClientRequest(ClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }
}

