/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.model.SignerResource;
import com.adobe.aemds.guide.transformer.api.ResourcePropertyTransformer;
import com.day.cq.i18n.I18n;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONCreationOptions {
    private Logger logger = LoggerFactory.getLogger(JSONCreationOptions.class);
    private boolean includeJcrPath;
    private I18n i18n;
    private boolean includeFragmentJson;
    private SlingHttpServletRequest request;
    private String dataRef;
    private String pagePath;
    private String formContainerPath;
    private boolean contextNeeded;
    private Resource formResource;
    private SignerResource signerResource;
    private Map prefillServiceParams;
    private Map<String, String> webVariableAssignments;
    private ResourcePropertyTransformer transformer;
    private String data;
    private Locale locale;
    public Map<String, Integer> adobeSignNameIndexMap;
    public Map<String, Integer> somMap;
    private Map<String, String> treeJsonMap = new HashMap<String, String>();
    private Scriptable rulesScriptsScope;
    private Map bindRefToAFNameMap;
    private boolean isV2Form;

    public boolean isV2Form() {
        return this.isV2Form;
    }

    public void setV2Form(boolean isV2Form) {
        this.isV2Form = isV2Form;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getContextNeeded() {
        return this.contextNeeded;
    }

    private void setSignerResource() {
        if (this.formResource != null) {
            Resource signerInfoResource;
            Boolean isAdobeSignEnabled;
            Resource guideContainerResource = this.formResource;
            if ("cq:Page".equals(this.formResource.getResourceType()) || "cq:Page".equals(this.formResource.getResourceSuperType())) {
                guideContainerResource = this.formResource.getChild("jcr:content/guideContainer");
            }
            if ((isAdobeSignEnabled = Boolean.valueOf((String)guideContainerResource.getValueMap().get("_useSignedPdf", (Object)""))).booleanValue() && (signerInfoResource = guideContainerResource.getChild("signerInfo")) != null) {
                this.signerResource = (SignerResource)signerInfoResource.adaptTo(SignerResource.class);
            }
        }
    }

    public JSONCreationOptions() {
        this.contextNeeded = false;
    }

    public JSONCreationOptions(I18n i18n, boolean includeJcrPath, boolean includeFragmentJson, Locale locale, Resource formResource) {
        this.includeJcrPath = includeJcrPath;
        this.i18n = i18n;
        this.includeFragmentJson = includeFragmentJson;
        this.locale = locale;
        this.formResource = formResource;
        this.contextNeeded = true;
        this.setSignerResource();
    }

    public void setTransformer(ResourcePropertyTransformer transformer) {
        this.transformer = transformer;
    }

    public JSONCreationOptions setI18n(I18n i18n) {
        this.i18n = i18n;
        return this;
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public boolean isIncludeJcrPath() {
        return this.includeJcrPath;
    }

    public boolean isIncludeFragmentJson() {
        return this.includeFragmentJson;
    }

    public void setIncludeFragmentJson(boolean includeFragmentJson) {
        this.includeFragmentJson = includeFragmentJson;
    }

    public Resource getFormResource() {
        return this.formResource;
    }

    public void setFormResource(Resource formResource) {
        this.formResource = formResource;
        this.setSignerResource();
    }

    public String getFormResourceProperty(String propertyName) {
        String propertyValue = "";
        if (this.formResource != null) {
            ValueMap resourceProps = ResourceUtil.getValueMap((Resource)this.formResource);
            propertyValue = (String)resourceProps.get(propertyName, (Object)"");
        }
        return propertyValue;
    }

    public ResourcePropertyTransformer getTransformer() {
        return this.transformer;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public JSONCreationOptions setDataRef(String dataRef) {
        this.dataRef = dataRef;
        return this;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public JSONCreationOptions setPagePath(String pagePath) {
        this.pagePath = pagePath;
        return this;
    }

    public Map getBindRefToAFNameMap() {
        return this.bindRefToAFNameMap;
    }

    public void setBindRefToAFNameMap(Map bindRefToAFNameMap) {
        this.bindRefToAFNameMap = bindRefToAFNameMap;
    }

    public String getFormContainerPath() {
        return this.formContainerPath;
    }

    public JSONCreationOptions setFormContainerPath(String formContainerPath) {
        this.formContainerPath = formContainerPath;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public JSONCreationOptions setData(String data) {
        this.data = data;
        return this;
    }

    public Scriptable getRulesScriptsScope() {
        return this.rulesScriptsScope;
    }

    public JSONCreationOptions setRulesScriptsScope(Scriptable rulesScriptsScope) {
        this.rulesScriptsScope = rulesScriptsScope;
        return this;
    }

    public Map<String, String> getExpTreeJsonMap() {
        return this.treeJsonMap != null ? this.treeJsonMap : new HashMap<String, String>();
    }

    public JSONCreationOptions setExpTreeJsonMap(Map<String, String> treeJsonMap) {
        this.treeJsonMap = treeJsonMap;
        return this;
    }

    public SignerResource getSignerResource() {
        return this.signerResource;
    }

    public Integer getAdobeSignFieldNameIndex(String name) {
        Integer index = null;
        if (this.adobeSignNameIndexMap == null) {
            this.adobeSignNameIndexMap = new HashMap<String, Integer>();
        }
        if (this.adobeSignNameIndexMap.containsKey(name)) {
            index = this.adobeSignNameIndexMap.get(name) + 1;
            this.adobeSignNameIndexMap.put(name, index);
            this.adobeSignNameIndexMap.put(name + index, 0);
        } else {
            this.adobeSignNameIndexMap.put(name, 0);
        }
        return index;
    }

    public Integer getSOMIndex(String som) {
        Integer index = 0;
        if (this.somMap == null) {
            this.somMap = new HashMap<String, Integer>();
        }
        if (this.somMap.containsKey(som)) {
            index = this.somMap.get(som) + 1;
        }
        this.somMap.put(som, index);
        return index;
    }

    public Map getPrefillServiceParams() {
        return this.prefillServiceParams;
    }

    public void setPrefillServiceParams(Map prefillServiceParams) {
        this.prefillServiceParams = prefillServiceParams;
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(SlingHttpServletRequest request) {
        this.request = request;
    }

    public Map<String, String> getWebVariableAssignments() {
        return this.webVariableAssignments;
    }

    public void setWebVariableAssignments(Map<String, String> webVariableAssignments) {
        this.webVariableAssignments = webVariableAssignments;
    }
}

