/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.readerextensions.client;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REXMsgSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(REXMsgSet.class);
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(REXMsgSet.class.getName());
    public static final String RES_001_002_MISSING_CREDENTIAL = "AEM-REX-001-002";
    public static final String RES_001_004_UNSUPPORTED_CREDENTIAL_FORMAT = "AEM-REX-001-004";
    public static final String RES_001_005_CREATE_DSC_FAILED = "AEM-REX-001-005";
    public static final String RES_001_006_CREDENTIAL_SERVICE_FAILED = "AEM-REX-001-006";
    public static final String RES_001_007_CREDENTIAL_MISSING = "AEM-REX-001-007";
    public static final String RES_001_008_APPLY_RIGHTS_FAILED = "AEM-REX-001-008";
    public static final String RES_001_009_GET_RIGHTS_FAILED = "AEM-REX-001-009";
    public static final String RES_001_010_REMOVE_RIGHTS_FAILED = "AEM-REX-001-010";
    public static final String RES_001_011_SHARED_PDF_FAILED = "AEM-REX-001-011";
    public static final String RES_001_014_GET_RIGHTS_FAILED = "AEM-REX-001-014";
    public static final String RES_001_015_RIGHT_NOT_ALLOWED = "AEM-REX-001-015";
    public static final String RES_001_017_PERMISSION_CONFLICT = "AEM-REX-001-017";
    public static final String RES_001_018_ACCESS_PERMISSIONS_FAILED = "AEM-REX-001-018";
    public static final String RES_001_019_INVALID_DOCUMENT = "AEM-REX-001-019";
    public static final String RES_001_020_INVALID_OPTIONS = "AEM-REX-001-020";
    public static final String RES_001_021_MISSING_USAGE_RIGHTS = "AEM-REX-001-021";
    public static final String RES_001_022_ENCRYPTED_PDF = "AEM-REX-001-022";
    public static final String RES_001_023_MISSING_ALIAS = "AEM-REX-001-023";
    public static final String RES_001_024_MISSING_PDF = "AEM-REX-001-024";
    public static final String RES_001_025_NOT_RE_CREDENTIAL = "AEM-REX-001-025";
    public static final String RES_001_026_CREDENTIAL_ERROR = "AEM-REX-001-026";
    public static final String RES_001_027_EXPIRED_CREDENTIAL = "AEM-REX-001-027";
    public static final String RES_001_028_USAGE_COUNT_ERROR = "AEM-REX-001-028";
    public static final String RES_001_029_INCREMENTAL_COUNT_FAILED = "AEM-REX-001-029";
    public static final String RES_001_030_CREDENTIAL_USAGE_RIGHTS_ERROR = "AEM-REX-001-030";
    public static final String RES_001_031_MISSING_RESOURCE_RESOLVER = "AEM-REX-001-031";
    public static final String RES_001_032_MISSING_BYTE_WRITER = "AEM-REX-001-032";

    public static String getMessage(String code, Object[] args) {
        String message = null;
        try {
            if (code == null) {
                return null;
            }
            String messageString = RESOURCES.getString(code);
            message = args != null ? REXMsgSet.fastFormat(messageString, args) : messageString;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught in fetching error message ", (Throwable)e);
        }
        return code + ": " + message;
    }

    protected static String fastFormat(String msg, Object[] args) {
        try {
            if (args == null || args.length == 0) {
                return msg;
            }
            StringBuffer res = new StringBuffer();
            int pos = 0;
            int cursor = 0;
            int len = msg.length();
            while (cursor < len) {
                char c;
                if ((c = msg.charAt(cursor++)) == '{') {
                    String numStr;
                    int paramNum;
                    int loc = cursor;
                    while (cursor < len && msg.charAt(cursor) != '}') {
                        ++cursor;
                    }
                    if (cursor >= len) break;
                    if ((paramNum = Integer.parseInt(numStr = msg.substring(loc, cursor++))) >= args.length) continue;
                    res.append(msg.substring(pos, loc - 1));
                    if (args[paramNum] == null) {
                        res.append("null");
                    } else {
                        res.append(args[paramNum].toString());
                    }
                    pos = cursor;
                    continue;
                }
                if (c != '\'' || cursor >= len) continue;
                res.append(msg.substring(pos, cursor - 1));
                pos = cursor;
                c = msg.charAt(cursor++);
                if (c == '\'') {
                    res.append(c);
                } else {
                    while (cursor < len) {
                        if (msg.charAt(cursor++) != '\'') continue;
                        if (cursor >= len || msg.charAt(cursor) != '\'') break;
                        res.append(msg.substring(pos, cursor++));
                        pos = cursor;
                    }
                    int n = --cursor;
                    ++cursor;
                    res.append(msg.substring(pos, n));
                }
                pos = cursor;
            }
            if (pos < len) {
                res.append(msg.substring(pos, len));
            }
            return res.toString();
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Error in fast message formatting using Java Message formatter", (Throwable)e);
            return MessageFormat.format(msg, args);
        }
    }
}

