/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.AuthenticatedResourceLocator;
import com.adobe.forms.foundation.wsdl.CustomWSDLLocator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CustomEntityResolver
implements EntityResolver {
    private static Logger logger = LoggerFactory.getLogger(CustomWSDLLocator.class);
    private AuthenticatedResourceLocator resourceLocator;

    CustomEntityResolver(AuthenticatedResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URL url = new URL(systemId);
        InputSource is = null;
        try {
            is = this.resourceLocator.getResource(url);
        }
        catch (URISyntaxException e) {
            logger.error("Failed to get resource - " + systemId + " : " + e.getMessage());
        }
        if (is != null) {
            is.setSystemId(systemId);
            is.setPublicId(publicId);
        }
        return is;
    }
}

