/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementType;
import com.adobe.dct.util.Validations;
import com.adobe.fd.content.fdinternal.util.ContentAssetUtil;
import com.adobe.fd.df.fdinternal.util.DFUtil;
import com.adobe.fd.df.fdinternal.util.XMLHelperUtil;
import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.LocalizationResourceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public final class DBUtils {
    public static String NVL(String string) {
        return ContentAssetUtil.NVL((String)string);
    }

    public static String stringDefault(String string, String sDefaultString) {
        return DBUtils.NVL(string).equals("") ? sDefaultString : string;
    }

    public static String getParameter(String sParameterName, HttpServletRequest request, String sDefaultValue) {
        String[] stringArray;
        String result = null;
        Map params = request.getParameterMap();
        Object parameterObject = params.get(sParameterName);
        if (parameterObject == null) {
            result = sDefaultValue;
        } else if (parameterObject instanceof String) {
            result = (String)parameterObject;
        } else if (parameterObject instanceof String[] && (stringArray = (String[])parameterObject).length > 0) {
            result = stringArray[0];
        }
        return DBUtils.stringDefault(result, sDefaultValue);
    }

    public static String getDisplayName(int state) {
        switch (state) {
            case 5: {
                return "Published";
            }
            case 3: {
                return "Modified";
            }
            case 4: {
                return "ReadyToPublish";
            }
        }
        return "";
    }

    public static String createCanonicalPath(String ddePath, DataDictionary dataDictionary) throws DCTException {
        if (dataDictionary == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-001");
            throw new DCTException("ALC-DCT-002-001");
        }
        if (ddePath == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-043", new String[]{"ddePath"});
            throw new DCTException("ALC-DCT-002-043", new String[]{"ddePath"});
        }
        String[] elementNames = ddePath.split("\\.");
        StringBuilder canocialPathSoFar = new StringBuilder();
        DataDictionaryElement selectedDDE = dataDictionary.getDDElements().get(0);
        if (!elementNames[0].equals(selectedDDE.getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
            throw new DCTException("ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
        }
        canocialPathSoFar.append(selectedDDE.getName());
        for (int index = 1; index < elementNames.length; ++index) {
            if (selectedDDE.getElementType().equals(DataDictionaryElementType.COMPOSITE)) {
                for (DataDictionaryElement childElement : selectedDDE.getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    selectedDDE = childElement;
                }
            } else if (selectedDDE.getElementType().equals(DataDictionaryElementType.COLLECTION) && selectedDDE.getCollectionElement().getElementType() == DataDictionaryElementType.COMPOSITE) {
                for (DataDictionaryElement childElement : selectedDDE.getCollectionElement().getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    selectedDDE = childElement;
                }
            }
            if (selectedDDE.getElementType().equals(DataDictionaryElementType.COLLECTION) && selectedDDE.getName().equals(elementNames[index])) {
                canocialPathSoFar.append(".").append(elementNames[index]).append("[]");
                continue;
            }
            canocialPathSoFar.append(".").append(elementNames[index]);
        }
        return canocialPathSoFar.toString();
    }

    public static LocalizationResourceInfo getLocalizationResourceInfo(List<LocalizationResourceInfo> infoList, String locale) {
        if (infoList == null || locale == null) {
            return null;
        }
        for (LocalizationResourceInfo resourceInfo : infoList) {
            if (!locale.equals(resourceInfo.getLocale())) continue;
            return resourceInfo;
        }
        return null;
    }

    public static Element getControlDataRoot(XMLHelperUtil data) {
        return DFUtil.getControlDataRoot((XMLHelperUtil)data);
    }

    public static Element getChildNode(Element parent, String nodeName) {
        return DFUtil.getChildNode((Element)parent, (String)nodeName);
    }

    public static Element getLetterNode(XMLHelperUtil data) throws Exception {
        if (data == null) {
            throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
        }
        Element iccLetterNode = null;
        Element iccRoot = DBUtils.getControlDataRoot(data);
        if (iccRoot != null) {
            iccLetterNode = DBUtils.getChildNode(iccRoot, "icc:letter");
        }
        return iccLetterNode;
    }

    public static String getLetterDefFromDataXML(XMLHelperUtil data) throws Exception {
        if (data == null) {
            throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
        }
        Element iccLetterNode = DBUtils.getLetterNode(data);
        String letterDef = null;
        if (iccLetterNode != null) {
            Element letterDefinitionNode = DBUtils.getChildNode(iccLetterNode, "icc:def");
            letterDef = letterDefinitionNode.getTextTrim();
        }
        return letterDef;
    }

    public static byte[] loadFileContent(String filePath) {
        FileInputStream fis = null;
        try {
            File file = new File(filePath);
            fis = new FileInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)fis);
            return byArray;
        }
        catch (Exception e) {
            throw new ICCException("Exception while reading from " + filePath, e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                throw new ICCException("Error in closing file stream.", e);
            }
        }
    }

    public static XMLHelperUtil getXMLHelperUtil(String initialXML) {
        try {
            if (StringUtils.isEmpty((String)initialXML)) {
                throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
            }
            XMLHelperUtil data = new XMLHelperUtil();
            boolean valid = data.loadXML(initialXML.getBytes("UTF-8"));
            if (!valid) {
                throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
            }
            return data;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }
}

