/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.Type2UnhintedRedirector;
import java.util.ArrayList;
import java.util.ListIterator;

final class Type2HintedRedirector
extends Type2UnhintedRedirector {
    private ArrayList a = new ArrayList();
    private int lastHintRedirected = -1;
    private int seacHintBase = 0;
    private boolean hintmaskSeen = false;
    private boolean newHints = false;

    Type2HintedRedirector() {
    }

    void reset(OutlineConsumer outlineConsumer) {
        super.reset(outlineConsumer);
        this.a.clear();
        this.hintmaskSeen = false;
        this.newHints = false;
        this.lastHintRedirected = -1;
    }

    public void cntrmask(double[] dArray, int n, CFFByteArray cFFByteArray, int n2, int n3) throws InvalidFontException {
        this.processMask(cFFByteArray, n2, n3, true);
    }

    public void endchar(double[] dArray, int n) {
        this.outlineConsumer.endchar();
    }

    private void addMask() {
        if (!this.hintmaskSeen || this.newHints) {
            boolean bl = this.hintmaskSeen;
            int n = this.lastHintRedirected + 1;
            ListIterator listIterator = this.a.listIterator(n);
            while (listIterator.hasNext()) {
                Stem stem = (Stem)listIterator.next();
                ((HintedOutlineConsumer)this.outlineConsumer).stem(stem.e1, stem.e2, bl, stem.isVertical, false);
                ++this.lastHintRedirected;
                bl = false;
            }
            this.hintmaskSeen = true;
            this.newHints = false;
        }
    }

    public void rmoveto(double[] dArray, int n) {
        this.addMask();
        super.rmoveto(dArray, n);
    }

    public void hmoveto(double[] dArray, int n) {
        this.addMask();
        super.hmoveto(dArray, n);
    }

    public void vmoveto(double[] dArray, int n) {
        this.addMask();
        super.vmoveto(dArray, n);
    }

    public void moveto(double[] dArray, int n) {
        this.addMask();
        super.moveto(dArray, n);
    }

    public void flex(double[] dArray, int n) {
        int n2 = 0;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d = this.x;
        double d2 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d3 = this.x;
        double d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d5 = this.x;
        double d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d7 = this.x;
        double d8 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d9 = this.x;
        double d10 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        ((HintedOutlineConsumer)this.outlineConsumer).flex(dArray[n2], d, d2, d3, d4, d5, d6, d7, d8, d9, d10, this.x, this.y);
    }

    public void flex1(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d3 = this.x;
        double d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d5 = this.x;
        double d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d7 = this.x;
        double d8 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d9 = this.x;
        double d10 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d11 = this.x;
        double d12 = this.y;
        if (Math.abs(this.x - d) > Math.abs(this.y - d2)) {
            this.x += dArray[n2++];
            this.y = d2;
        } else {
            this.y += dArray[n2++];
            this.x = d;
        }
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, this.x, this.y);
    }

    public void hflex(double[] dArray, int n) {
        int n2 = 0;
        double d = this.y;
        this.x += dArray[n2++];
        double d2 = this.x;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d3 = this.x;
        this.x += dArray[n2++];
        double d4 = this.x;
        this.x += dArray[n2++];
        double d5 = this.x;
        this.x += dArray[n2++];
        double d6 = this.x;
        this.x += dArray[n2++];
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, d2, d, d3, this.y, d4, this.y, d5, this.y, d6, d, this.x, d);
        this.y = d;
    }

    public void hflex1(double[] dArray, int n) {
        int n2 = 0;
        double d = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d2 = this.x;
        double d3 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d4 = this.x;
        double d5 = this.y;
        this.x += dArray[n2++];
        double d6 = this.x;
        this.x += dArray[n2++];
        double d7 = this.x;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d8 = this.x;
        double d9 = this.y;
        this.x += dArray[n2++];
        this.y = d;
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, d2, d3, d4, d5, d6, d5, d7, d5, d8, d9, this.x, this.y);
    }

    private void processMask(CFFByteArray cFFByteArray, int n, int n2, boolean bl) throws InvalidFontException {
        int n3;
        boolean bl2 = false;
        boolean bl3 = bl || this.hintmaskSeen;
        for (n3 = 0; n3 < n2; ++n3) {
            if (cFFByteArray.getcard8(n + n3) == 0) continue;
            bl2 = true;
        }
        if (bl2) {
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = cFFByteArray.getcard8(n + n3);
                if (n4 == 0) continue;
                for (int i = 7; i >= 0; --i) {
                    if ((n4 & 1 << i) == 0) continue;
                    int n5 = n3 * 8 + (7 - i) + this.seacHintBase;
                    if (n5 >= this.a.size()) {
                        throw new InvalidGlyphException("Invalid hint mask");
                    }
                    Stem stem = (Stem)this.a.get(n5);
                    ((HintedOutlineConsumer)this.outlineConsumer).stem(stem.e1, stem.e2, bl3, stem.isVertical, bl);
                    bl3 = false;
                }
            }
        } else if (bl) {
            ((HintedOutlineConsumer)this.outlineConsumer).noCounters();
        } else {
            ((HintedOutlineConsumer)this.outlineConsumer).noHints();
        }
    }

    public void hintmask(double[] dArray, int n, CFFByteArray cFFByteArray, int n2, int n3) throws InvalidFontException {
        this.processMask(cFFByteArray, n2, n3, false);
        this.hintmaskSeen = true;
        this.newHints = false;
    }

    private void addStem(double[] dArray, int n, boolean bl) {
        int n2;
        double d = 0.0;
        if (!this.newHints) {
            this.seacHintBase = this.a.size();
            this.lastHintRedirected = this.seacHintBase - 1;
            this.newHints = true;
        }
        int n3 = n2 = n % 2 != 0 ? 1 : 0;
        while (n2 < n) {
            double d2 = (d += dArray[n2++]) + dArray[n2++];
            this.a.add(new Stem(d, d2, bl));
            d = d2;
        }
    }

    public void hstem(double[] dArray, int n) {
        this.addStem(dArray, n, false);
    }

    public void hstemhm(double[] dArray, int n) {
        this.hstem(dArray, n);
    }

    public void implicit_vstemhm(double[] dArray, int n) {
        this.vstem(dArray, n);
    }

    public void vstem(double[] dArray, int n) {
        this.addStem(dArray, n, true);
    }

    public void vstemhm(double[] dArray, int n) {
        this.vstem(dArray, n);
    }

    public boolean width(double d) {
        return ((HintedOutlineConsumer)this.outlineConsumer).width(d);
    }

    public void globalColorMe(double[] dArray, int n) {
        ((HintedOutlineConsumer)this.outlineConsumer).globalColorOn();
    }

    private static class Stem {
        final double e1;
        final double e2;
        final boolean isVertical;

        Stem(double d, double d2, boolean bl) {
            this.e1 = d;
            this.e2 = d2;
            this.isVertical = bl;
        }
    }
}

