/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingFormat1Harvester;
import com.adobe.fontengine.font.opentype.ChainingFormat2Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat1Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat2Harvester;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GsubHarvester
extends LookupTableHarvester {
    private AltSubstHarvester altSubstHarvester = new AltSubstHarvester();
    private LigaSubstHarvester ligaSubstHarvester = new LigaSubstHarvester();
    private MultSubstHarvester multSubstHarvester = new MultSubstHarvester();
    private SingleSubstFormat1Harvester singleSubstFormat1Harvester = new SingleSubstFormat1Harvester();
    private SingleSubstFormat2Harvester singleSubstFormat2Harvester = new SingleSubstFormat2Harvester();

    GsubHarvester(Gsub gsub, int n) {
        super(gsub, n);
    }

    TreeMap<Integer, List> gatherPossibleLookups(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n;
        TreeMap<Integer, List> treeMap = new TreeMap<Integer, List>();
        IntGrowableArray intGrowableArray = this.getAllFeatureListFeatures();
        do {
            n = subset.getNumGlyphs();
            this.harvestAllFeatures(intGrowableArray, treeMap, subset);
        } while (subset.getNumGlyphs() != n);
        return treeMap;
    }

    private List gatherContextualGlyphs(int n, Subset subset, Map map, List list, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.lookupTable.data.getuint16(n);
        switch (n3) {
            case 1: {
                list = this.gatherLookupsForCoverage(n, 2, subset, list, new ContextFormat1Harvester(this, map, true), n2);
                break;
            }
            case 2: {
                list = this.gatherLookupsForCoverage(n, 2, subset, list, new ContextFormat2Harvester(this, map), n2);
                break;
            }
            case 3: {
                int n4 = this.lookupTable.data.getuint16(n + 2);
                if (n4 <= 0) break;
                list = this.gatherLookupsForCoverage(n, 6, subset, list, new ContextFormat3SubstHarvester(map), n2);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual lookup format (" + n3 + ")");
            }
        }
        return list;
    }

    private List gatherContextualGlyphsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherContextualGlyphs(n3, subset, map, list, i);
        }
        return list;
    }

    private List gatherSingleSubstGlyphsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        block4: for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            int n4 = this.lookupTable.data.getuint16(n3);
            switch (n4) {
                case 1: {
                    list = this.gatherLookupsForCoverage(n3, 2, subset, list, this.singleSubstFormat1Harvester, i);
                    continue block4;
                }
                case 2: {
                    list = this.gatherLookupsForCoverage(n3, 2, subset, list, this.singleSubstFormat2Harvester, i);
                }
            }
        }
        return list;
    }

    private List gatherChainingGlyphs(int n, Subset subset, Map map, List list, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.lookupTable.data.getuint16(n);
        switch (n3) {
            case 1: {
                list = this.gatherLookupsForCoverage(n, 2, subset, list, new ChainingFormat1Harvester(this, map, true), n2);
                break;
            }
            case 2: {
                list = this.gatherLookupsForCoverage(n, 2, subset, list, new ChainingFormat2Harvester(this, map), n2);
                break;
            }
            case 3: {
                int n4 = this.lookupTable.data.getuint16(n + 2);
                int n5 = this.lookupTable.data.getuint16(n + 4 + 2 * n4);
                if (n5 <= 0) break;
                list = this.gatherLookupsForCoverage(n, 4 + 2 * n4 + 2, subset, list, new ChainingFormat3SubstHarvester(map), n2);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual lookup format (" + n3 + ")");
            }
        }
        return list;
    }

    private List gatherChainingGlyphsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherChainingGlyphs(n3, subset, map, list, i);
        }
        return list;
    }

    private List gatherExtensionGlyphsForAllSubtables(Subset subset, int n, Map map, int n2) throws InvalidFontException, UnsupportedFontException {
        ArrayList<Integer> arrayList = null;
        List list = null;
        int n3 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n3; ++i) {
            Integer n4;
            int n5 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            int n6 = this.lookupTable.data.getuint16(n5);
            if (n6 != 1) {
                throw new InvalidFontException("Invalid extension format (" + n6 + ")");
            }
            int n7 = this.lookupTable.data.getuint16(n5 + 2);
            int n8 = this.lookupTable.data.getuint32asint(n5 + 4, "Only signed extension values supported");
            switch (n7) {
                case 1: {
                    int n9 = this.lookupTable.data.getuint16(n5 + n8);
                    if (n9 == 1) {
                        list = this.gatherLookupsForCoverage(n5 + n8, 2, subset, list, this.singleSubstFormat1Harvester, 0);
                        break;
                    }
                    list = this.gatherLookupsForCoverage(n5 + n8, 2, subset, list, this.singleSubstFormat2Harvester, 0);
                    break;
                }
                case 2: {
                    list = this.gatherLookupsForCoverage(n5 + n8, 2, subset, list, this.multSubstHarvester, 0);
                    break;
                }
                case 3: {
                    list = this.gatherLookupsForCoverage(n5 + n8, 2, subset, list, this.altSubstHarvester, 0);
                    break;
                }
                case 4: {
                    list = this.gatherLookupsForCoverage(n5 + n8, 2, subset, list, this.ligaSubstHarvester, 0);
                    break;
                }
                case 5: {
                    list = this.gatherContextualGlyphs(n5 + n8, subset, map, list, 0);
                    break;
                }
                case 6: {
                    list = this.gatherChainingGlyphs(n5 + n8, subset, map, list, 0);
                    break;
                }
                default: {
                    throw new InvalidFontException("Invalid GSUB lookup type (" + n7 + ")");
                }
            }
            if (list == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            if (arrayList.contains(n4 = new Integer(i))) continue;
            arrayList.add(n4);
        }
        return arrayList;
    }

    @Override
    protected List harvestSubtables(Subset subset, int n, int n2, int n3, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        switch (n2) {
            case 1: {
                list = this.gatherSingleSubstGlyphsForAllSubtables(subset, n, map);
                break;
            }
            case 2: {
                list = this.gatherLookupsForCoverageAllSubtables(subset, n, this.multSubstHarvester);
                break;
            }
            case 3: {
                list = this.gatherLookupsForCoverageAllSubtables(subset, n, this.altSubstHarvester);
                break;
            }
            case 4: {
                list = this.gatherLookupsForCoverageAllSubtables(subset, n, this.ligaSubstHarvester);
                break;
            }
            case 5: {
                list = this.gatherContextualGlyphsForAllSubtables(subset, n, map);
                break;
            }
            case 6: {
                list = this.gatherChainingGlyphsForAllSubtables(subset, n, map);
                break;
            }
            case 7: {
                list = this.gatherExtensionGlyphsForAllSubtables(subset, n, map, n3);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + n2 + ")");
            }
        }
        return list;
    }

    private class ContextFormat3SubstHarvester
    extends GSubLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private Map lookups;
        private boolean coverageContainsGid;

        ContextFormat3SubstHarvester(Map map) {
            this.lookups = map;
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4;
            int n5 = GsubHarvester.this.lookupTable.data.getuint16(n2 + 2);
            if (n5 == 1) {
                this.coverageContainsGid = true;
            }
            for (n4 = 1; n4 < n5; ++n4) {
                this.coverageContainsGid = false;
                GsubHarvester.this.lookupTable.iterateCoverage(GsubHarvester.this.lookupTable.data.getOffset(n2, 6 + n4 * 2), subset, this);
                if (!this.coverageContainsGid) break;
            }
            if (n4 == n5) {
                int n6 = GsubHarvester.this.lookupTable.data.getuint16(n2 + 4);
                for (int i = 0; i < n6; ++i) {
                    int n7 = GsubHarvester.this.lookupTable.data.getuint16(n2 + 6 + 2 * n5 + 4 * i + 2);
                    GsubHarvester.this.harvest(subset, n7, this.lookups);
                }
            }
            return this.coverageContainsGid;
        }

        public boolean glyphInfo(int n, int n2) {
            this.coverageContainsGid = true;
            return false;
        }
    }

    private class ChainingFormat3SubstHarvester
    extends GSubLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private Map lookups;
        private boolean coverageContainsGid;

        ChainingFormat3SubstHarvester(Map map) {
            this.lookups = map;
        }

        private boolean checkCoverages(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            for (int i = 0; i < n3; ++i) {
                this.coverageContainsGid = false;
                GsubHarvester.this.lookupTable.iterateCoverage(GsubHarvester.this.lookupTable.data.getOffset(n, n2 + 2 * i), subset, this);
                if (this.coverageContainsGid) continue;
                return false;
            }
            return true;
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4;
            int n5;
            int n6 = 4;
            int n7 = GsubHarvester.this.lookupTable.data.getuint16(n2 + 2);
            boolean bl = this.checkCoverages(n2, n6, n7, subset);
            if (!bl) {
                return false;
            }
            n6 += 2 * n7;
            if (!(bl = this.checkCoverages(n2, (n6 += 2) + 2, (n5 = GsubHarvester.this.lookupTable.data.getuint16(n2 + n6)) - 1, subset))) {
                return false;
            }
            n6 += 2 * n5;
            if (!(bl = this.checkCoverages(n2, n6 += 2, n4 = GsubHarvester.this.lookupTable.data.getuint16(n2 + n6), subset))) {
                return false;
            }
            int n8 = GsubHarvester.this.lookupTable.data.getuint16(n2 + (n6 += 2 * n4));
            n6 += 2;
            for (int i = 0; i < n8; ++i) {
                int n9 = GsubHarvester.this.lookupTable.data.getuint16(n2 + n6 + 4 * i + 2);
                GsubHarvester.this.harvest(subset, n9, this.lookups);
            }
            return true;
        }

        public boolean glyphInfo(int n, int n2) {
            this.coverageContainsGid = true;
            return false;
        }
    }

    private class LigaSubstHarvester
    extends GSubLookupHarvester {
        private LigaSubstHarvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GsubHarvester.this.lookupTable.data.getOffset(n2, 6 + n3 * 2);
            int n5 = GsubHarvester.this.lookupTable.data.getuint16(n4);
            boolean bl = false;
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7;
                int n8 = GsubHarvester.this.lookupTable.data.getOffset(n4, 2 + i * 2);
                int n9 = GsubHarvester.this.lookupTable.data.getuint16(n8 + 2);
                for (n7 = 0; n7 < n9 - 1 && subset.getExistingSubsetGid(n6 = GsubHarvester.this.lookupTable.data.getuint16(n8 + 4 + 2 * n7)) != -1; ++n7) {
                }
                if (n7 != n9 - 1) continue;
                bl = true;
                n6 = GsubHarvester.this.lookupTable.data.getuint16(n8);
                try {
                    subset.getSubsetGid(n6);
                    continue;
                }
                catch (InvalidFontException invalidFontException) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    private class AltSubstHarvester
    extends GSubLookupHarvester {
        private AltSubstHarvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GsubHarvester.this.lookupTable.data.getOffset(n2, 6 + n3 * 2);
            int n5 = GsubHarvester.this.lookupTable.data.getuint16(n4);
            for (int i = 0; i < n5; ++i) {
                int n6 = GsubHarvester.this.lookupTable.data.getuint16(n4 + 2 + 2 * i);
                try {
                    subset.getSubsetGid(n6);
                    continue;
                }
                catch (InvalidFontException invalidFontException) {
                    return false;
                }
            }
            return true;
        }
    }

    private class MultSubstHarvester
    extends GSubLookupHarvester {
        MultSubstHarvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GsubHarvester.this.lookupTable.data.getOffset(n2, 6 + 2 * n3);
            int n5 = GsubHarvester.this.lookupTable.data.getuint16(n4);
            for (int i = 0; i < n5; ++i) {
                try {
                    subset.getSubsetGid(GsubHarvester.this.lookupTable.data.getuint16(n4 + 2 + 2 * i));
                    continue;
                }
                catch (InvalidFontException invalidFontException) {
                    return false;
                }
            }
            return true;
        }
    }

    private class SingleSubstFormat2Harvester
    extends GSubLookupHarvester {
        SingleSubstFormat2Harvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GsubHarvester.this.lookupTable.data.getuint16(n2 + 6 + 2 * n3);
            try {
                subset.getSubsetGid(n4);
            }
            catch (InvalidFontException invalidFontException) {
                return false;
            }
            return true;
        }
    }

    private class SingleSubstFormat1Harvester
    extends GSubLookupHarvester {
        SingleSubstFormat1Harvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GsubHarvester.this.lookupTable.data.getint16(n2 + 4);
            try {
                subset.getSubsetGid(n + n4);
            }
            catch (InvalidFontException invalidFontException) {
                return false;
            }
            return true;
        }
    }

    private abstract class GSubLookupHarvester
    implements LookupTableHarvester.CoverageLookupHarvester {
        private GSubLookupHarvester() {
        }

        public boolean keepGoing() {
            return true;
        }
    }
}

