/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.PlainReader;
import com.adobe.fontengine.font.postscript.Reader;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import java.io.IOException;

public final class Tokenizer {
    private FontInputStream fontInputStream;
    private Token token = new Token();
    private Reader reader;
    private static final int N = 1;
    private static final int W = 2;
    private static final int S = 4;
    private static final int D = 8;
    private static final int P = 16;
    private static final int G = 32;
    private static final int E = 64;
    private static final int[] lexicalClass = new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0, 4, 4, 0, 32, 0, 32, 16, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] digit = new byte[]{99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 99, 99, 99, 99, 99, 99, 99, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 99, 99, 99, 99, 99, 99, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};

    public static final boolean isWhite(int n) {
        return (lexicalClass[n] & 2) != 0;
    }

    public static final boolean isNewLine(int n) {
        return (lexicalClass[n] & 1) != 0;
    }

    public static final boolean isDelimiter(int n) {
        return (lexicalClass[n] & 6) != 0;
    }

    public static final boolean isSign(int n) {
        return (lexicalClass[n] & 0x20) != 0;
    }

    public static final boolean isExponent(int n) {
        return (lexicalClass[n] & 0x40) != 0;
    }

    public static final boolean isDigit(int n) {
        return digit[n] < 10;
    }

    public static final boolean isHex(int n) {
        return digit[n] < 16;
    }

    public static final boolean isRadix(int n, int n2) {
        return digit[n] < n2;
    }

    public static final byte digitValue(byte by) {
        return digit[by];
    }

    public Tokenizer(FontInputStream fontInputStream) {
        this.fontInputStream = fontInputStream;
        this.reader = new PlainReader();
    }

    private void addByte(byte by) {
        if (this.token.tokenLength < this.token.buff.length) {
            this.token.buff[this.token.tokenLength++] = by;
            return;
        }
        byte[] byArray = new byte[this.token.tokenLength + 256];
        System.arraycopy(this.token.buff, 0, byArray, 0, this.token.tokenLength);
        byArray[this.token.tokenLength++] = by;
        this.token.buff = byArray;
    }

    private void skipComment() throws IOException, InvalidFontException {
        int n;
        while (!Tokenizer.isNewLine(n = this.reader.read(this.fontInputStream))) {
        }
        this.reader.unreadLast(this.fontInputStream);
    }

    private void skipString() throws IOException, InvalidFontException {
        int n = 1;
        do {
            int n2 = this.reader.read(this.fontInputStream);
            switch (n2) {
                case 92: {
                    this.addByte((byte)n2);
                    n2 = this.reader.read(this.fontInputStream);
                    this.addByte((byte)n2);
                    break;
                }
                case 40: {
                    this.addByte((byte)n2);
                    ++n;
                    break;
                }
                case 41: {
                    --n;
                    this.addByte((byte)n2);
                    break;
                }
                default: {
                    this.addByte((byte)n2);
                }
            }
        } while (n > 0);
    }

    private void skipArray() throws IOException, InvalidFontException {
        int n = 1;
        do {
            int n2 = this.reader.read(this.fontInputStream);
            switch (n2) {
                case 37: {
                    this.skipComment();
                    break;
                }
                case 40: {
                    this.addByte((byte)n2);
                    this.skipString();
                    break;
                }
                case 91: {
                    this.addByte((byte)n2);
                    ++n;
                    break;
                }
                case 93: {
                    this.addByte((byte)n2);
                    --n;
                    break;
                }
                default: {
                    this.addByte((byte)n2);
                }
            }
        } while (n > 0);
    }

    private void skipProcedure() throws IOException, InvalidFontException {
        int n = 1;
        do {
            int n2 = this.reader.read(this.fontInputStream);
            switch (n2) {
                case 37: {
                    this.skipComment();
                    break;
                }
                case 40: {
                    this.addByte((byte)n2);
                    this.skipString();
                    break;
                }
                case 123: {
                    this.addByte((byte)n2);
                    ++n;
                    break;
                }
                case 125: {
                    this.addByte((byte)n2);
                    --n;
                    break;
                }
                default: {
                    this.addByte((byte)n2);
                }
            }
        } while (n > 0);
    }

    private void skipDictionary() throws IOException, InvalidFontException {
        block9: while (true) {
            int n = this.reader.read(this.fontInputStream);
            switch (n) {
                case 62: {
                    this.addByte((byte)n);
                    n = this.reader.read(this.fontInputStream);
                    switch (n) {
                        case 62: {
                            this.addByte((byte)n);
                            return;
                        }
                    }
                    this.reader.unreadLast(this.fontInputStream);
                    continue block9;
                }
                case 37: {
                    this.skipComment();
                    continue block9;
                }
                case 40: {
                    this.addByte((byte)n);
                    this.skipString();
                    continue block9;
                }
                case 60: {
                    this.addByte((byte)n);
                    this.skipAngle();
                    continue block9;
                }
            }
            this.addByte((byte)n);
        }
    }

    private TokenType skipAngle() throws IOException, InvalidFontException {
        int n = this.reader.read(this.fontInputStream);
        switch (n) {
            case 60: {
                this.addByte((byte)n);
                this.skipDictionary();
                return TokenType.kDICTIONARY;
            }
            case 126: {
                this.addByte((byte)n);
                while (true) {
                    n = this.reader.read(this.fontInputStream);
                    this.addByte((byte)n);
                    if (n == 126) {
                        n = this.reader.read(this.fontInputStream);
                        this.addByte((byte)n);
                        switch (n) {
                            case 62: {
                                return TokenType.kASCII85;
                            }
                        }
                        continue;
                    }
                    if (!(n >= 33 && n <= 117 || Tokenizer.isWhite(n) || n == 122)) break;
                }
                throw new InvalidFontException("invalid ascii85 string");
            }
        }
        this.addByte((byte)n);
        do {
            if (!Tokenizer.isHex(n) && !Tokenizer.isWhite(n)) {
                throw new InvalidFontException("invalid hex string");
            }
            n = this.reader.read(this.fontInputStream);
            this.addByte((byte)n);
        } while (n != 62);
        return TokenType.kHEXSTRING;
    }

    private TokenType skipNumber(int n) throws IOException, InvalidFontException {
        int n2;
        boolean bl = false;
        if (Tokenizer.isDigit(n)) {
            n2 = 1;
        } else if (Tokenizer.isSign(n)) {
            n2 = 2;
        } else if (n == 46) {
            n2 = 3;
        } else {
            n2 = 0;
            bl = true;
        }
        while (!bl) {
            n = this.reader.read(this.fontInputStream);
            if (Tokenizer.isDelimiter(n)) {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 11: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kOPERATOR;
                    }
                    case 1: 
                    case 6: 
                    case 9: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kINTEGER;
                    }
                    case 4: 
                    case 7: 
                    case 10: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kREAL;
                    }
                }
            }
            this.addByte((byte)n);
            switch (n2) {
                case 1: {
                    if (n == 46) {
                        n2 = 4;
                        break;
                    }
                    if (n == 35) {
                        n2 = 5;
                        break;
                    }
                    if (Tokenizer.isDigit(n)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (Tokenizer.isDigit(n)) {
                        n2 = 6;
                        break;
                    }
                    if (n == 46) {
                        n2 = 3;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    if (Tokenizer.isDigit(n)) {
                        n2 = 7;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: {
                    if (Tokenizer.isDigit(n)) {
                        n2 = 7;
                        break;
                    }
                    if (Tokenizer.isExponent(n)) {
                        n2 = 8;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 5: {
                    if (Tokenizer.isRadix(n, 36)) {
                        n2 = 9;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 6: {
                    if (n == 46) {
                        n2 = 7;
                        break;
                    }
                    if (Tokenizer.isDigit(n)) break;
                    bl = true;
                    break;
                }
                case 7: {
                    if (Tokenizer.isExponent(n)) {
                        n2 = 8;
                        break;
                    }
                    if (Tokenizer.isDigit(n)) break;
                    bl = true;
                    break;
                }
                case 8: {
                    if (Tokenizer.isDigit(n)) {
                        n2 = 10;
                        break;
                    }
                    if (Tokenizer.isSign(n)) {
                        n2 = 11;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 9: {
                    if (Tokenizer.isRadix(n, 36)) break;
                    bl = true;
                    break;
                }
                case 10: {
                    if (Tokenizer.isDigit(n)) break;
                    bl = true;
                    break;
                }
                case 11: {
                    if (Tokenizer.isDigit(n)) {
                        n2 = 10;
                        break;
                    }
                    bl = true;
                }
            }
        }
        this.skipToDelimiter();
        return TokenType.kOPERATOR;
    }

    private void skipToDelimiter() throws IOException, InvalidFontException {
        int n = this.reader.read(this.fontInputStream);
        while (n != -1 && !Tokenizer.isDelimiter(n)) {
            this.addByte((byte)n);
            n = this.reader.read(this.fontInputStream);
        }
        if (n != -1) {
            this.reader.unreadLast(this.fontInputStream);
        }
    }

    private void gotoNextLine() throws InvalidFontException, IOException, IndexOutOfBoundsException {
        int n = this.reader.read(this.fontInputStream);
        while (n != -1) {
            if (Tokenizer.isNewLine(n)) {
                return;
            }
            n = this.reader.read(this.fontInputStream);
        }
    }

    public Token getNextPSToken() throws InvalidFontException, IOException, IndexOutOfBoundsException {
        this.token.tokenLength = 0;
        int n = this.reader.read(this.fontInputStream);
        while (true) {
            if (!Tokenizer.isWhite(n)) {
                if (n != 37) break;
                this.skipComment();
            }
            n = this.reader.read(this.fontInputStream);
        }
        this.addByte((byte)n);
        switch (n) {
            case 47: {
                n = this.reader.read(this.fontInputStream);
                switch (n) {
                    case -1: {
                        throw new InvalidFontException("unexpected end of token");
                    }
                    case 47: {
                        this.addByte((byte)n);
                        this.token.tokenType = TokenType.kIMMEDIATE;
                        break;
                    }
                    default: {
                        this.token.tokenType = TokenType.kLITERAL;
                        this.reader.unreadLast(this.fontInputStream);
                    }
                }
                this.skipToDelimiter();
                break;
            }
            case 123: {
                this.skipProcedure();
                this.token.tokenType = TokenType.kPROCEDURE;
                break;
            }
            case 40: {
                this.skipString();
                this.token.tokenType = TokenType.kSTRING;
                break;
            }
            case 91: {
                this.skipArray();
                this.token.tokenType = TokenType.kARRAY;
                break;
            }
            case 60: {
                this.token.tokenType = this.skipAngle();
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.token.tokenType = this.skipNumber(n);
                break;
            }
            default: {
                this.skipToDelimiter();
                this.token.tokenType = TokenType.kOPERATOR;
            }
        }
        return this.token;
    }

    public void findToken(byte[] byArray) throws IOException, InvalidFontException {
        Token token;
        while (!(token = this.getNextPSToken()).matches(byArray)) {
        }
    }

    public byte[] findOptionalTokensAtStartOfLine(byte[][] byArray) throws IOException, InvalidFontException {
        block2: while (true) {
            Token token;
            this.gotoNextLine();
            try {
                token = this.getNextPSToken();
            }
            catch (InvalidFontException invalidFontException) {
                return null;
            }
            if (token.isEOL()) {
                return null;
            }
            int n = 0;
            while (true) {
                if (n >= byArray.length) continue block2;
                if (token.matches(byArray[n])) {
                    return byArray[n];
                }
                ++n;
            }
            break;
        }
    }

    public int read() throws IOException, InvalidFontException {
        return this.reader.read(this.fontInputStream);
    }

    public void setReader(Reader reader) throws InvalidFontException {
        if (this.reader.getClass() == reader.getClass()) {
            throw new InvalidFontException("eexec done twice?");
        }
        this.reader = reader;
    }
}

