/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;

public final class CSS20FontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final String familyName;
    private final CSS20Attribute.CSSStyleValue style;
    private final CSS20Attribute.CSSVariantValue variant;
    private final CSS20Attribute.CSSStretchValue stretch;
    private final int weight;
    private final double lowPointSize;
    private final double highPointSize;

    public CSS20FontDescription(String string, CSS20Attribute.CSSStyleValue cSSStyleValue, CSS20Attribute.CSSVariantValue cSSVariantValue, CSS20Attribute.CSSStretchValue cSSStretchValue, int n, double d, double d2) {
        this.familyName = string;
        this.style = cSSStyleValue;
        this.variant = cSSVariantValue;
        this.stretch = cSSStretchValue;
        this.weight = n;
        this.lowPointSize = d;
        this.highPointSize = d2;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public CSS20Attribute.CSSStyleValue getStyle() {
        return this.style;
    }

    public CSS20Attribute.CSSVariantValue getVariant() {
        return this.variant;
    }

    public int getWeight() {
        return this.weight;
    }

    public CSS20Attribute.CSSStretchValue getStretch() {
        return this.stretch;
    }

    public double getLowPointSize() {
        return this.lowPointSize;
    }

    public double getHighPointSize() {
        return this.highPointSize;
    }

    public int hashCode() {
        int n = this.familyName.hashCode() ^ this.style.hashCode() ^ this.variant.hashCode() ^ this.stretch.hashCode() ^ this.weight ^ (int)(this.lowPointSize * 100.0) ^ (int)(this.highPointSize * 100.0);
        return n;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (this == object) {
                return true;
            }
            if (object instanceof CSS20FontDescription && this.familyName.equals(((CSS20FontDescription)object).familyName) && this.style.equals(((CSS20FontDescription)object).style) && this.variant.equals(((CSS20FontDescription)object).variant) && this.stretch.equals(((CSS20FontDescription)object).stretch) && this.weight == ((CSS20FontDescription)object).weight && this.lowPointSize == ((CSS20FontDescription)object).lowPointSize && this.highPointSize == ((CSS20FontDescription)object).highPointSize) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{familyName = " + this.familyName + ", ");
        if (this.style == CSS20Attribute.CSSStyleValue.NORMAL) {
            stringBuffer.append("stl = NORMAL, ");
        } else if (this.style == CSS20Attribute.CSSStyleValue.ITALIC) {
            stringBuffer.append("stl = ITALIC, ");
        } else if (this.style == CSS20Attribute.CSSStyleValue.OBLIQUE) {
            stringBuffer.append("stl = OBLIQUE, ");
        }
        if (this.variant == CSS20Attribute.CSSVariantValue.NORMAL) {
            stringBuffer.append("var = NORMAL, ");
        } else if (this.variant == CSS20Attribute.CSSVariantValue.SMALL_CAPS) {
            stringBuffer.append("var = SMALL-CAPS, ");
        }
        stringBuffer.append("wt = " + this.weight + ", ");
        stringBuffer.append("str = " + this.stretch.toString() + ", ");
        stringBuffer.append("lowPt = " + this.lowPointSize + ", ");
        stringBuffer.append("highPt = " + this.highPointSize + "}");
        return stringBuffer.toString();
    }
}

