/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BlockNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.CommentNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UseNumericNode;
import macromedia.asc.parser.UsePragmaNode;
import macromedia.asc.parser.UsePrecisionNode;
import macromedia.asc.parser.UseRoundingNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeFactory
implements ErrorConstants {
    private Context cx;
    public Set<String> compound_names;
    public boolean has_arguments;
    public boolean has_rest;
    public boolean has_unnamed_package;
    public boolean has_dxns;
    public PackageDefinitionNode current_package;
    public StatementListNode use_stmts;
    public DefaultXMLNamespaceNode dxns;
    private boolean create_default_doc_comments;
    private ObjectList<ObjectList<ClassDefinitionNode>> clsdefs_sets = new ObjectList();
    private boolean needs_prototype_ns;
    private Map<String, Integer> fun_names = new TreeMap<String, Integer>();
    public Map<String, PackageDefinitionNode> pkg_names = new TreeMap<String, PackageDefinitionNode>();
    public ObjectList<PackageDefinitionNode> pkg_defs = new ObjectList();
    private static final String ARGUMENTS;
    Map<String, Integer> namespace_names = new TreeMap<String, Integer>();
    static final /* synthetic */ boolean $assertionsDisabled;

    public NodeFactory(Context cx) {
        this.cx = cx;
        this.compound_names = new HashSet<String>();
        this.has_arguments = false;
        this.has_rest = false;
        this.has_unnamed_package = false;
        this.has_dxns = false;
        this.create_default_doc_comments = false;
        this.current_package = null;
        this.use_stmts = null;
        this.dxns = null;
    }

    public void init(ObjectList<String> names) {
        this.compound_names.addAll(names);
    }

    public void createDefaultDocComments(boolean val) {
        this.create_default_doc_comments = val;
    }

    public ArgumentListNode argumentList(ArgumentListNode list, Node item) {
        return this.argumentList(list, item, -1);
    }

    public ArgumentListNode argumentList(ArgumentListNode list, Node item, int pos) {
        ArgumentListNode node;
        if (item != null && item.isIdentifier()) {
            item = this.memberExpression(null, this.getExpression((IdentifierNode)item), pos);
        }
        if (list != null) {
            list.items.add(item);
            node = list;
        } else {
            node = new ArgumentListNode(item, 0);
            node.setPositionNonterminal(list != null ? list : item, pos);
        }
        return node;
    }

    public Node assignmentExpression(Node lhs, int op, Node rhs) {
        return this.assignmentExpression(lhs, op, rhs, -1);
    }

    public Node assignmentExpression(Node lhs, int op, Node rhs, int pos) {
        MemberExpressionNode exprNode;
        Node node;
        boolean is_constinit = false;
        if (op == -65) {
            op = -49;
            is_constinit = true;
        }
        int prevOp = op;
        if (op != -49) {
            op = op == -16 ? (op = -15) : (op == -23 ? (op = -22) : (op == -8 ? (op = -7) : (op == -44 ? (op = -42) : (op == -50 ? (op = -2) : (op == -47 ? (op = -46) : (op == -56 ? (op = -55) : (op == -58 ? (op = -57) : (op == -12 ? (op = -9) : (op == -34 ? (op = -31) : (op == -39 ? (op = -36) : (op == -11 ? (op = -10) : (op == -33 ? (op = -32) : (op == -38 ? (op = -37) : -134)))))))))))));
            rhs = this.binaryExpression(op, lhs, rhs);
        }
        if (lhs.isMemberExpression()) {
            MemberExpressionNode member = (MemberExpressionNode)lhs;
            if (member.selector.isGetExpression()) {
                GetExpressionNode get = (GetExpressionNode)member.selector;
                node = member.isIndexedMemberExpression() ? this.indexedMemberExpression(member.base, this.setExpression(get, this.argumentList(null, rhs), is_constinit)) : this.memberExpression(member.base, this.setExpression(get, this.argumentList(null, rhs), is_constinit, rhs.pos()));
            } else {
                node = this.error(pos, 1105);
            }
        } else {
            node = this.memberExpression(null, this.setExpression(lhs, this.argumentList(null, rhs), is_constinit));
        }
        if (this.cx.scriptAssistParsing && (exprNode = (MemberExpressionNode)node) != null && prevOp != op) {
            exprNode.setOrigToken(prevOp);
        }
        node.setPositionNonterminal(lhs, pos);
        return node;
    }

    public AttributeListNode attributeList(Node item, AttributeListNode list) {
        return this.attributeList(item, list, -1);
    }

    public AttributeListNode attributeList(Node item, AttributeListNode list, int pos) {
        AttributeListNode node;
        if (list != null) {
            list.items.add(item);
            node = list;
        } else {
            node = new AttributeListNode(item, item.pos());
            node.setPositionNonterminal(item, pos);
        }
        return node;
    }

    public BinaryExpressionNode binaryExpression(int op, Node lhs, Node rhs) {
        return this.binaryExpression(op, lhs, rhs, -1);
    }

    public BinaryExpressionNode binaryExpression(int op, Node lhs, Node rhs, int pos) {
        BinaryExpressionNode node = new BinaryExpressionNode(op, lhs, rhs);
        node.setPositionNonterminal(lhs, pos);
        return node;
    }

    public BlockNode block(AttributeListNode attributes, StatementListNode statements) {
        return this.block(attributes, statements, -1);
    }

    public BlockNode block(AttributeListNode attributes, StatementListNode statements, int pos) {
        BlockNode node = new BlockNode(attributes, statements);
        node.setPositionNonterminal(attributes, pos);
        return node;
    }

    public BreakStatementNode breakStatement(IdentifierNode id) {
        return this.breakStatement(id, -1);
    }

    public BreakStatementNode breakStatement(IdentifierNode id, int pos) {
        BreakStatementNode node = new BreakStatementNode(id);
        node.setPositionTerminal(pos);
        return node;
    }

    public Node callExpression(Node expr, ArgumentListNode args) {
        return this.callExpression(expr, args, -1);
    }

    public Node callExpression(Node expr, ArgumentListNode args, int pos) {
        Node node;
        CallExpressionNode call;
        if (ContextStatics.omitTrace && expr != null && expr instanceof MemberExpressionNode) {
            MemberExpressionNode men = (MemberExpressionNode)expr;
            if (men.base == null && men.selector != null && men.selector instanceof GetExpressionNode) {
                GetExpressionNode gen = (GetExpressionNode)men.selector;
                if (gen.expr != null && gen.expr instanceof IdentifierNode) {
                    IdentifierNode iden = (IdentifierNode)gen.expr;
                    if (iden.name != null && iden.name == "trace") {
                        return this.emptyStatement();
                    }
                }
            }
        }
        if (expr != null && expr.isMemberExpression()) {
            GetExpressionNode get;
            MemberExpressionNode memb = (MemberExpressionNode)expr;
            GetExpressionNode getExpressionNode = get = memb.selector instanceof GetExpressionNode ? (GetExpressionNode)memb.selector : null;
            if (get != null) {
                call = new CallExpressionNode(get.expr, args);
                call.setMode(get.getMode());
                call.is_package = get.is_package;
                call.setPositionNonterminal(expr, pos);
                memb.selector = call;
                node = memb;
            } else {
                call = new CallExpressionNode(expr, args);
                call.setRValue(true);
                call.setPositionNonterminal(expr, pos);
                node = call;
            }
        } else {
            call = new CallExpressionNode(expr, args);
            call.setRValue(true);
            call.setPositionNonterminal(expr, pos);
            node = call;
        }
        if (Features.SPECIAL_FUNCTION_SYNTAX) {
            // empty if block
        }
        return node;
    }

    public CaseLabelNode caseLabel(Node label) {
        return this.caseLabel(label, -1);
    }

    public CaseLabelNode caseLabel(Node label, int pos) {
        CaseLabelNode node = new CaseLabelNode(label);
        node.setPositionTerminal(pos);
        return node;
    }

    public CatchClauseNode catchClause(Node parameter, StatementListNode block) {
        return this.catchClause(parameter, block, -1);
    }

    public CatchClauseNode catchClause(Node parameter, StatementListNode block, int pos) {
        CatchClauseNode node = new CatchClauseNode(parameter, block);
        node.setPositionNonterminal(parameter, pos);
        return node;
    }

    public void StartClassDefs() {
        this.clsdefs_sets.add(new ObjectList());
        this.needs_prototype_ns = true;
    }

    public void FinishClassDefs() {
        this.clsdefs_sets.removeLast();
    }

    public boolean classNeedsPrototypeNamespace() {
        boolean temp = this.needs_prototype_ns;
        this.needs_prototype_ns = false;
        return temp;
    }

    public ClassDefinitionNode classDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, InheritanceNode inheritance, StatementListNode block) {
        return this.classDefinition(cx, attrs, name, inheritance, block, false);
    }

    public ClassDefinitionNode classDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, InheritanceNode inheritance, StatementListNode block, boolean non_nullable) {
        return this.classDefinition(cx, attrs, name, inheritance, block, non_nullable, -1);
    }

    public ClassDefinitionNode classDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, InheritanceNode inheritance, StatementListNode block, boolean non_nullable, int pos) {
        name = this.qualifiedIdentifier(attrs, name);
        Node baseclass = inheritance != null ? inheritance.baseclass : null;
        ListNode interfaces = inheritance != null ? inheritance.interfaces : null;
        ClassDefinitionNode node = new ClassDefinitionNode(cx, this.current_package, attrs, name, baseclass, interfaces, block);
        node.is_default_nullable = !non_nullable;
        node.setPositionNonterminal(name, pos);
        node.clsdefs = this.clsdefs_sets.last();
        this.clsdefs_sets.removeLast();
        if (this.clsdefs_sets.size() > 0) {
            this.clsdefs_sets.last().add(node);
        }
        return node;
    }

    public BinaryClassDefNode binaryClassDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, InheritanceNode inheritance, StatementListNode block) {
        return this.binaryClassDefinition(cx, attrs, name, inheritance, block, -1);
    }

    public BinaryClassDefNode binaryClassDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, InheritanceNode inheritance, StatementListNode block, int pos) {
        name = this.qualifiedIdentifier(attrs, name);
        Node baseclass = inheritance != null ? inheritance.baseclass : null;
        ListNode interfaces = inheritance != null ? inheritance.interfaces : null;
        BinaryClassDefNode node = new BinaryClassDefNode(cx, this.current_package, attrs, name, baseclass, interfaces, block);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public InterfaceDefinitionNode interfaceDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, ListNode interfaces, StatementListNode block) {
        return this.interfaceDefinition(cx, attrs, name, interfaces, block, -1);
    }

    public InterfaceDefinitionNode interfaceDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, ListNode interfaces, StatementListNode block, int pos) {
        name = this.qualifiedIdentifier(attrs, name);
        InterfaceDefinitionNode node = new InterfaceDefinitionNode(cx, this.current_package, attrs, name, interfaces, block);
        node.setPositionNonterminal(name, pos);
        node.clsdefs = new ObjectList();
        if (this.clsdefs_sets.size() > 0) {
            this.clsdefs_sets.last().add(node);
        }
        return node;
    }

    public BinaryInterfaceDefinitionNode binaryInterfaceDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, ListNode interfaces, StatementListNode block) {
        return this.binaryInterfaceDefinition(cx, attrs, name, interfaces, block, -1);
    }

    public BinaryInterfaceDefinitionNode binaryInterfaceDefinition(Context cx, AttributeListNode attrs, IdentifierNode name, ListNode interfaces, StatementListNode block, int pos) {
        name = this.qualifiedIdentifier(attrs, name);
        BinaryInterfaceDefinitionNode node = new BinaryInterfaceDefinitionNode(cx, this.current_package, attrs, name, interfaces, block);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public ClassNameNode className(PackageNameNode pkgname, IdentifierNode ident) {
        return this.className(pkgname, ident, -1);
    }

    public ClassNameNode className(PackageNameNode pkgname, IdentifierNode ident, int pos) {
        ClassNameNode node = new ClassNameNode(pkgname, ident, ident.pos());
        node.setPositionNonterminal(ident, pos);
        return node;
    }

    public ConditionalExpressionNode conditionalExpression(Node cond, Node thenexpr, Node elseexpr) {
        return this.conditionalExpression(cond, thenexpr, elseexpr, -1);
    }

    public ConditionalExpressionNode conditionalExpression(Node cond, Node thenexpr, Node elseexpr, int pos) {
        ConditionalExpressionNode node = new ConditionalExpressionNode(cond, thenexpr, elseexpr);
        node.setPositionNonterminal(cond, pos);
        return node;
    }

    public ContinueStatementNode continueStatement(IdentifierNode id) {
        return this.continueStatement(id, -1);
    }

    public ContinueStatementNode continueStatement(IdentifierNode id, int pos) {
        ContinueStatementNode node = new ContinueStatementNode(id);
        node.setPositionTerminal(pos);
        return node;
    }

    public DoStatementNode doStatement(Node stmt, Node expr) {
        return this.doStatement(stmt, expr, -1);
    }

    public DoStatementNode doStatement(Node stmt, Node expr, int pos) {
        if (stmt != null) {
            StatementListNode stmtlist;
            StatementListNode statementListNode = stmtlist = stmt instanceof StatementListNode ? (StatementListNode)stmt : null;
            if (stmtlist == null) {
                stmtlist = this.statementList(null, stmt);
                stmt = stmtlist;
            }
        }
        DoStatementNode node = new DoStatementNode(stmt, expr);
        node.setPositionNonterminal(stmt, pos);
        return node;
    }

    public EmptyElementNode emptyElement() {
        return this.emptyElement(-1);
    }

    public EmptyElementNode emptyElement(int pos) {
        EmptyElementNode node = new EmptyElementNode();
        node.setPositionTerminal(pos);
        return node;
    }

    public EmptyStatementNode emptyStatement() {
        return EmptyStatementNode.getInstance();
    }

    public ExpressionStatementNode expressionStatement(Node expr) {
        return this.expressionStatement(expr, -1);
    }

    public ExpressionStatementNode expressionStatement(Node expr, int pos) {
        ExpressionStatementNode node = new ExpressionStatementNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public Node forInStatement(boolean is_each, Node expr1, Node expr2, Node stmt) {
        return this.forInStatement(is_each, expr1, expr2, stmt, -1);
    }

    public Node forInStatement(boolean is_each, Node expr1, Node expr2, Node stmt, int pos) {
        if (!this.cx.scriptAssistParsing) {
            if (stmt != null && !stmt.isStatementList()) {
                stmt = this.statementList(null, stmt);
            }
            VariableDefinitionNode vard = null;
            if (expr1.isDefinition()) {
                vard = (VariableDefinitionNode)expr1;
                VariableBindingNode varb = (VariableBindingNode)vard.list.items.back();
                TypedIdentifierNode var = varb.variable;
                expr1 = var.identifier;
            } else {
                ListNode list = (ListNode)expr1;
                expr1 = list.items.back();
            }
            RegisterNode ndx_reg = this.register(pos);
            RegisterNode obj_reg = this.register(pos);
            Node untypedExpr = this.coerce(expr2, null, this.cx.noType().getDefaultTypeInfo(), true, pos);
            ListNode init = this.list(this.list(null, this.storeRegister(ndx_reg, this.literalNumber("0", pos), this.cx.intType(), pos)), this.storeRegister(obj_reg, untypedExpr, this.cx.noType(), pos));
            HasNextNode test = this.hasNext(obj_reg, ndx_reg, pos);
            ExpressionStatementNode incr = is_each ? this.expressionStatement(this.assignmentExpression(expr1, -49, this.memberExpression(this.loadRegister(obj_reg, this.cx.noType(), pos), this.invoke("[[NextValue]]", this.argumentList(null, this.loadRegister(ndx_reg, this.cx.intType(), pos)), pos)))) : this.expressionStatement(this.assignmentExpression(expr1, -49, this.memberExpression(this.loadRegister(obj_reg, this.cx.noType(), pos), this.invoke("[[NextName]]", this.argumentList(null, this.loadRegister(ndx_reg, this.cx.intType(), pos)), expr1.pos()))));
            stmt = this.statementList(this.statementList(null, incr), stmt);
            Node node = this.forStatement(init, test, null, stmt, true, pos == -1 ? expr1.pos() : pos);
            if (vard != null) {
                StatementListNode stmtlist = this.statementList(this.statementList(null, vard), node);
                node = stmtlist;
            }
            return node;
        }
        if (stmt != null && !stmt.isStatementList()) {
            stmt = this.statementList(null, stmt);
        }
        VariableDefinitionNode vard = null;
        if (expr1 != null && expr1.isDefinition()) {
            vard = (VariableDefinitionNode)expr1;
            expr1 = null;
        }
        if (expr1 != null) {
            pos = expr1.pos();
        } else if (expr2 != null) {
            pos = expr2.pos();
        }
        Node node = new ForStatementNode(expr1, expr2, null, stmt, true);
        node.setPositionNonterminal(expr1, pos);
        if (vard != null) {
            StatementListNode stmtlist = this.statementList(this.statementList(null, vard), node);
            node = stmtlist;
            stmtlist.is_loop = true;
        } else {
            StatementListNode stmtlist;
            StatementListNode statementListNode = stmtlist = stmt instanceof StatementListNode ? (StatementListNode)stmt : null;
            if (stmtlist != null) {
                stmtlist.is_loop = true;
            }
        }
        return node;
    }

    public Node forStatement(Node expr1, Node expr2, Node expr3, Node stmt) {
        return this.forStatement(expr1, expr2, expr3, stmt, false, -1);
    }

    public Node forStatement(Node expr1, Node expr2, Node expr3, Node stmt, boolean is_forin, int pos) {
        if (stmt != null && !stmt.isStatementList()) {
            stmt = this.statementList(null, stmt);
        }
        VariableDefinitionNode vard = null;
        if (expr1 != null && expr1.isDefinition()) {
            vard = (VariableDefinitionNode)expr1;
            expr1 = null;
        }
        Node node = new ForStatementNode(expr1, expr2, expr3, stmt, is_forin);
        node.setPositionNonterminal(expr1, pos);
        if (vard != null) {
            StatementListNode stmtlist = this.statementList(this.statementList(null, vard), node);
            node = stmtlist;
            stmtlist.is_loop = true;
        } else {
            StatementListNode stmtlist;
            StatementListNode statementListNode = stmtlist = stmt instanceof StatementListNode ? (StatementListNode)stmt : null;
            if (stmtlist != null) {
                stmtlist.is_loop = true;
            }
        }
        return node;
    }

    public FunctionDefinitionNode functionDefinition(Context cx, AttributeListNode attrs, FunctionNameNode name, FunctionCommonNode fexpr) {
        return this.functionDefinition(cx, attrs, name, fexpr, -1);
    }

    public FunctionDefinitionNode functionDefinition(Context cx, AttributeListNode attrs, FunctionNameNode name, FunctionCommonNode fexpr, int pos) {
        fexpr.identifier = name.identifier = this.qualifiedIdentifier(attrs, name.identifier);
        fexpr.setFunctionDefinition(true);
        FunctionDefinitionNode node = new FunctionDefinitionNode(cx, this.current_package, attrs, name, fexpr);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public BinaryFunctionDefinitionNode binaryFunctionDefinition(Context cx, AttributeListNode attrs, FunctionNameNode name, FunctionCommonNode fexpr, int pos) {
        fexpr.identifier = name.identifier = this.qualifiedIdentifier(attrs, name.identifier);
        fexpr.setFunctionDefinition(true);
        BinaryFunctionDefinitionNode node = new BinaryFunctionDefinitionNode(cx, this.current_package, attrs, name, fexpr);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public FunctionCommonNode functionCommon(Context cx, IdentifierNode identifier, FunctionSignatureNode signature, StatementListNode body) {
        return this.functionCommon(cx, identifier, signature, body, -1);
    }

    public FunctionCommonNode functionCommon(Context cx, IdentifierNode identifier, FunctionSignatureNode signature, StatementListNode body, int pos) {
        if (identifier == null) {
            identifier = cx.scriptAssistParsing ? this.identifier("", pos) : this.identifier("anonymous", pos);
        }
        StringBuffer internal_name = new StringBuffer(identifier.name.length() + 6);
        if (!this.fun_names.containsKey(identifier.name)) {
            this.fun_names.put(identifier.name, Boxing.valueOf(0));
        }
        int num = this.fun_names.get(identifier.name);
        if (Features.USE_DEFINED_NAME_AS_INTERNAL_NAME) {
            if (num == 0) {
                internal_name.append(identifier.name);
                this.fun_names.put(identifier.name, Boxing.valueOf(++num));
            } else {
                internal_name.append(identifier.name);
                internal_name.append('$').append(num);
                this.fun_names.put(identifier.name, Boxing.valueOf(++num));
            }
        } else {
            internal_name.append(identifier.name);
            internal_name.append('$').append(num);
            this.fun_names.put(identifier.name, Boxing.valueOf(++num));
        }
        boolean userBody = false;
        if (cx.input != null) {
            ReturnStatementNode rtn;
            if (cx.scriptAssistParsing) {
                rtn = this.returnStatement(this.unaryExpression(-113, this.literalNumber("0", 0), 0), 0);
                rtn.setIsSynthetic();
            } else {
                rtn = this.returnStatement(null, 0);
                rtn.setIsSynthetic();
                rtn.setPositionTerminal(cx.input.positionOfMark());
            }
            if (body == null) {
                body = this.statementList(null, rtn);
                userBody = false;
            } else {
                body.items.push_back(rtn);
                userBody = true;
            }
        }
        FunctionCommonNode fexpr = new FunctionCommonNode(cx, null, internal_name.toString(), identifier, signature, body, userBody);
        fexpr.needsArguments = this.has_rest ? 4 : (this.has_arguments ? 1 : 0);
        fexpr.setPositionNonterminal(signature, pos);
        FunctionCommonNode node = fexpr;
        return node;
    }

    public FunctionNameNode functionName(int kind, IdentifierNode name) {
        return this.functionName(kind, name, -1);
    }

    public FunctionNameNode functionName(int kind, IdentifierNode name, int pos) {
        FunctionNameNode node = new FunctionNameNode(kind, name);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public FunctionSignatureNode functionSignature(ParameterListNode parameter, Node result) {
        return this.functionSignature(parameter, result, -1);
    }

    public FunctionSignatureNode functionSignature(ParameterListNode parameter, Node result, int pos) {
        FunctionSignatureNode node = new FunctionSignatureNode(parameter, result);
        node.setPositionTerminal(pos);
        return node;
    }

    public FunctionSignatureNode constructorSignature(ParameterListNode parameter, ListNode initializers, int pos) {
        FunctionSignatureNode node = new FunctionSignatureNode(parameter, initializers);
        node.setPositionTerminal(pos);
        return node;
    }

    public GetExpressionNode getExpression(Node expr) {
        return this.getExpression(expr, -1);
    }

    public GetExpressionNode getExpression(Node expr, int pos) {
        GetExpressionNode node = new GetExpressionNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public GetExpressionNode getExpression(IdentifierNode ident) {
        return this.getExpression(ident, -1);
    }

    public GetExpressionNode getExpression(IdentifierNode ident, int pos) {
        GetExpressionNode node = new GetExpressionNode(ident);
        node.setPositionNonterminal(ident, pos);
        return node;
    }

    public IdentifierNode identifier(String name) {
        return this.identifier(name, -1);
    }

    public IdentifierNode identifier(String name, boolean intern) {
        IdentifierNode node = new IdentifierNode(name, intern, -1);
        return node;
    }

    public IdentifierNode identifier(String name, boolean intern, int pos) {
        IdentifierNode node = new IdentifierNode(name, intern, pos);
        return node;
    }

    public IdentifierNode identifier(String name, int pos) {
        IdentifierNode node = new IdentifierNode(name, pos);
        node.setPositionTerminal(pos);
        if (ARGUMENTS == node.name) {
            this.has_arguments = true;
        }
        return node;
    }

    public IdentifierNode identifier(IdentifierNode ident, int pos) {
        QualifiedIdentifierNode qualid = ident instanceof QualifiedIdentifierNode ? (QualifiedIdentifierNode)ident : null;
        IdentifierNode node = qualid != null ? this.qualifiedIdentifier(qualid.qualifier, this.identifier(qualid.name, pos), pos) : this.identifier(ident.name, pos);
        node.setAttr(ident.isAttr());
        return node;
    }

    public Node applyTypeExpr(Node expr, ListNode typeArgs, int pos) {
        Node node;
        if (expr != null && expr.isMemberExpression()) {
            GetExpressionNode get;
            MemberExpressionNode memb = (MemberExpressionNode)expr;
            GetExpressionNode getExpressionNode = get = memb.selector instanceof GetExpressionNode ? (GetExpressionNode)memb.selector : null;
            if (get != null) {
                ApplyTypeExprNode apply = new ApplyTypeExprNode(get.expr, typeArgs);
                apply.setMode(get.getMode());
                apply.is_package = get.is_package;
                apply.setPositionNonterminal(expr, pos);
                memb.selector = apply;
                node = memb;
            } else {
                ApplyTypeExprNode apply = new ApplyTypeExprNode(expr, typeArgs);
                apply.setRValue(true);
                apply.setPositionNonterminal(expr, pos);
                node = apply;
            }
        } else {
            ApplyTypeExprNode apply = new ApplyTypeExprNode(expr, typeArgs);
            apply.setRValue(true);
            apply.setPositionNonterminal(expr, pos);
            node = apply;
        }
        return node;
    }

    public Node ifStatement(ListNode test, Node tblock, Node eblock) {
        return this.ifStatement(test, tblock, eblock, -1);
    }

    public Node ifStatement(ListNode test, Node tblock, Node eblock, int pos) {
        StatementListNode stmtlist;
        IfStatementNode node = null;
        if (Features.COMPILE_TIME_IF) {
            // empty if block
        }
        if (tblock != null) {
            StatementListNode statementListNode = stmtlist = tblock instanceof StatementListNode ? (StatementListNode)tblock : null;
            if (stmtlist == null) {
                stmtlist = this.statementList(null, tblock);
                tblock = stmtlist;
            }
        }
        if (eblock != null) {
            StatementListNode statementListNode = stmtlist = eblock instanceof StatementListNode ? (StatementListNode)eblock : null;
            if (stmtlist == null) {
                stmtlist = this.statementList(null, eblock);
                eblock = stmtlist;
            }
        }
        if (node == null) {
            node = new IfStatementNode(test, tblock, eblock);
            node.setPositionNonterminal(test, pos);
        }
        return node;
    }

    public ImportDirectiveNode importDirective(AttributeListNode attrs, PackageNameNode name, PackageNameNode init, Context cx) {
        return this.importDirective(attrs, name, init, -1, cx);
    }

    public ImportDirectiveNode importDirective(AttributeListNode attrs, PackageNameNode name, PackageNameNode init, int pos, Context cx) {
        PackageDefinitionNode pkg_node = null;
        String id = name.id.toIdentifierString();
        if (this.pkg_names.containsKey(id)) {
            pkg_node = this.pkg_names.get(id);
        }
        ImportDirectiveNode node = new ImportDirectiveNode(this.current_package, attrs, name, pkg_node, cx);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public IncludeDirectiveNode includeDirective(Context cx, LiteralStringNode filespec, ProgramNode program) {
        return this.includeDirective(cx, filespec, program, -1);
    }

    public IncludeDirectiveNode includeDirective(Context cx, LiteralStringNode filespec, ProgramNode program, int pos) {
        IncludeDirectiveNode node = new IncludeDirectiveNode(cx, filespec, program);
        node.setPositionNonterminal(filespec, pos);
        return node;
    }

    public ImportNode Import(Context cx, LiteralStringNode filespec, ProgramNode program) {
        return this.Import(cx, filespec, program, -1);
    }

    public ImportNode Import(Context cx, LiteralStringNode filespec, ProgramNode program, int pos) {
        ImportNode node = new ImportNode(filespec, program);
        node.setPositionNonterminal(filespec, pos);
        return node;
    }

    public IncrementNode increment(int op, Node expr, boolean isPostfix) {
        return this.increment(op, expr, isPostfix, -1);
    }

    public IncrementNode increment(int op, Node expr, boolean isPostfix, int pos) {
        IncrementNode node = new IncrementNode(op, expr, isPostfix);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public InheritanceNode inheritance(Node baseclass, ListNode interfaces) {
        return this.inheritance(baseclass, interfaces, -1);
    }

    public InheritanceNode inheritance(Node baseclass, ListNode interfaces, int pos) {
        InheritanceNode node = new InheritanceNode(baseclass, interfaces);
        node.setPositionNonterminal(baseclass, pos);
        return node;
    }

    public LabeledStatementNode labeledStatement(Node label, Node statement) {
        return this.labeledStatement(label, statement, -1);
    }

    public LabeledStatementNode labeledStatement(Node label, Node statement, int pos) {
        boolean stmt_is_loop = statement instanceof ForStatementNode || statement instanceof WhileStatementNode || statement instanceof DoStatementNode || statement instanceof StatementListNode && ((StatementListNode)statement).is_loop;
        LabeledStatementNode node = !this.cx.scriptAssistParsing && statement instanceof StatementListNode ? new LabeledStatementNode(label, stmt_is_loop, this.ifStatement(this.list(null, this.literalBoolean(true)), statement, null)) : new LabeledStatementNode(label, stmt_is_loop, statement);
        node.setPositionNonterminal(label, pos);
        return node;
    }

    public ListNode list(ListNode list, Node item) {
        return this.list(list, item, -1);
    }

    public ListNode list(ListNode list, Node item, int pos) {
        ListNode node;
        if (item != null && item.isIdentifier()) {
            item = this.memberExpression(null, this.getExpression((IdentifierNode)item));
        }
        if (list != null) {
            list.items.add(item);
            node = list;
        } else {
            node = new ListNode(null, item, 0);
            node.setPositionNonterminal(list != null ? list : item, pos);
        }
        return node;
    }

    public LiteralArrayNode literalArray(ArgumentListNode elementlist) {
        return this.literalArray(elementlist, -1);
    }

    public LiteralArrayNode literalArray(ArgumentListNode elementlist, int pos) {
        LiteralArrayNode node = new LiteralArrayNode(elementlist);
        node.setPositionNonterminal(elementlist, pos);
        return node;
    }

    public LiteralBooleanNode literalBoolean(boolean value) {
        return this.literalBoolean(value, -1);
    }

    public LiteralBooleanNode literalBoolean(boolean value, int pos) {
        LiteralBooleanNode node = new LiteralBooleanNode(value);
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralFieldNode literalField(Node name, Node value) {
        return this.literalField(name, value, -1);
    }

    public LiteralFieldNode literalField(Node name, Node value, int pos) {
        LiteralFieldNode node = new LiteralFieldNode(name, value);
        node.setPositionNonterminal(name, pos);
        return node;
    }

    public LiteralNumberNode literalNumber(int i) {
        return this.literalNumber(i, -1);
    }

    public LiteralNumberNode literalNumber(int i, int pos) {
        return this.literalNumber(new StringBuffer().append("").append(i).toString(), pos);
    }

    public LiteralNullNode literalNull() {
        return this.literalNull(-1);
    }

    public LiteralNullNode literalNull(int pos) {
        LiteralNullNode node = new LiteralNullNode();
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralNumberNode literalNumber(String value) {
        return this.literalNumber(value, -1);
    }

    public LiteralNumberNode literalNumber(String value, int pos) {
        LiteralNumberNode node = new LiteralNumberNode(value);
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralObjectNode literalObject(ArgumentListNode fieldlist) {
        return this.literalObject(fieldlist, -1);
    }

    public LiteralObjectNode literalObject(ArgumentListNode fieldlist, int pos) {
        LiteralObjectNode node = new LiteralObjectNode(fieldlist);
        node.setPositionNonterminal(fieldlist, pos);
        return node;
    }

    public LiteralRegExpNode literalRegExp(String value, int pos) {
        LiteralRegExpNode node = new LiteralRegExpNode(value);
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralXMLNode literalXML(ListNode list, boolean is_xmllist, int pos) {
        LiteralXMLNode node = new LiteralXMLNode(list, is_xmllist);
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralStringNode literalString(String value) {
        return this.literalString(value, 0);
    }

    public LiteralStringNode literalString(String value, boolean intern) {
        LiteralStringNode node = new LiteralStringNode(value, false, intern);
        return node;
    }

    public LiteralStringNode literalString(String value, int pos) {
        LiteralStringNode node = new LiteralStringNode(value);
        node.setPositionTerminal(pos);
        return node;
    }

    public LiteralStringNode literalString(String value, int pos, boolean is_single_quoted) {
        LiteralStringNode node = new LiteralStringNode(value, is_single_quoted);
        node.setPositionTerminal(pos);
        return node;
    }

    public MemberExpressionNode indexedMemberExpression(Node base, SelectorNode selector) {
        return this.indexedMemberExpression(base, selector, -1);
    }

    public MemberExpressionNode indexedMemberExpression(Node base, SelectorNode selector, int pos) {
        MemberExpressionNode node = this.memberExpression(base, selector, pos);
        node.selector.setMode(-29);
        return node;
    }

    public TypeExpressionNode typeExpression(Node expr, boolean nullable, boolean explicit, int pos) {
        TypeExpressionNode typeexpr = new TypeExpressionNode(expr, nullable, explicit);
        typeexpr.setPositionNonterminal(expr, pos);
        return typeexpr;
    }

    public MemberExpressionNode memberExpression(Node base, SelectorNode selector) {
        return this.memberExpression(base, selector, -1);
    }

    public MemberExpressionNode memberExpression(Node base, SelectorNode selector, int pos) {
        if (Features.TRANSLATE_COMPOUND_NAMES && base != null && base.isMemberExpression()) {
            MemberExpressionNode memb = (MemberExpressionNode)base;
            if (memb.selector.isGetExpression()) {
                GetExpressionNode getx = (GetExpressionNode)memb.selector;
                if (selector.isGetExpression()) {
                    IdentifierNode pname = ((GetExpressionNode)selector).getIdentifier();
                    IdentifierNode bname = null;
                    String base_name = null;
                    while (getx != null) {
                        bname = getx.getIdentifier();
                        if (bname != null) {
                            base_name = base_name == null ? bname.name : new StringBuffer().append(bname.name).append(".").append(base_name).toString();
                            if (bname instanceof QualifiedIdentifierNode && ((QualifiedIdentifierNode)bname).qualifier instanceof LiteralStringNode) {
                                base_name = new StringBuffer().append(((LiteralStringNode)((QualifiedIdentifierNode)bname).qualifier).value).append(".").append(base_name).toString();
                            }
                        }
                        if (memb.base != null && memb.base instanceof MemberExpressionNode) {
                            memb = (MemberExpressionNode)memb.base;
                            getx = memb.selector.isGetExpression() ? (GetExpressionNode)memb.selector : null;
                            continue;
                        }
                        getx = null;
                    }
                    if (base_name != null && pname != null) {
                        String compound_name = new StringBuffer(base_name.length() + pname.name.length() + 1).append(base_name).append(".").append(pname.name).toString();
                        if (this.compound_names.contains(compound_name)) {
                            selector = this.getExpression(this.identifier(compound_name, selector.pos()));
                            base = memb.base;
                        } else if (this.compound_names.contains(base_name)) {
                            LiteralStringNode nsn = this.literalString(bname.name, memb.pos() - 1);
                            selector = this.getExpression(this.qualifiedIdentifier(nsn, pname, selector.pos()));
                            base = memb.base;
                        }
                    }
                }
            }
        }
        if (base != null && base.isIdentifier()) {
            base = this.memberExpression(null, this.getExpression((IdentifierNode)base));
        }
        if (base == null) {
            IdentifierNode ident;
            selector.setMode(-133);
            IdentifierNode identifierNode = ident = selector.expr instanceof IdentifierNode ? (IdentifierNode)selector.expr : null;
            if (ident != null && this.compound_names.contains(ident.name)) {
                selector.is_package = true;
            }
        }
        MemberExpressionNode node = new MemberExpressionNode(base, selector, 0);
        node.setPositionNonterminal(selector, pos);
        return node;
    }

    public NamespaceDefinitionNode namespaceDefinition(AttributeListNode attributes, IdentifierNode identifier, Node value) {
        return this.namespaceDefinition(attributes, identifier, value, -1);
    }

    public NamespaceDefinitionNode namespaceDefinition(AttributeListNode attributes, IdentifierNode identifier, Node value, int pos) {
        if (!this.namespace_names.containsKey(identifier.name)) {
            this.namespace_names.put(identifier.name, IntegerPool.getNumber(0));
        }
        NamespaceDefinitionNode node = new NamespaceDefinitionNode(this.current_package, attributes, identifier, value);
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public NamespaceDefinitionNode configNamespaceDefinition(AttributeListNode attributes, IdentifierNode identifier, int pos) {
        ConfigNamespaceDefinitionNode node = new ConfigNamespaceDefinitionNode(this.current_package, attributes, identifier);
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public Node newExpression(Node expr) {
        return this.newExpression(expr, -1);
    }

    public Node newExpression(Node expr, int pos) {
        Node node;
        if (expr.isMemberExpression()) {
            MemberExpressionNode memb = (MemberExpressionNode)expr;
            if (memb.selector.isCallExpression()) {
                CallExpressionNode call = (CallExpressionNode)memb.selector;
                call.is_new = true;
                node = memb;
            } else {
                GetExpressionNode get;
                if (!$assertionsDisabled) {
                    throw new Error();
                }
                GetExpressionNode getExpressionNode = get = memb.selector instanceof GetExpressionNode ? (GetExpressionNode)memb.selector : null;
                if (get == null && !$assertionsDisabled) {
                    throw new Error();
                }
                CallExpressionNode call = new CallExpressionNode(get.expr, null);
                call.setMode(get.getMode());
                call.setPositionNonterminal(expr, pos);
                memb.selector = call;
                node = memb;
            }
        } else if (expr.isCallExpression()) {
            CallExpressionNode call = (CallExpressionNode)expr;
            call.is_new = true;
            node = call;
        } else {
            if (!$assertionsDisabled) {
                throw new Error();
            }
            CallExpressionNode call = new CallExpressionNode(expr, null);
            call.is_new = true;
            call.setMode(-133);
            call.setPositionNonterminal(expr, pos);
            node = call;
        }
        return node;
    }

    public PackageDefinitionNode startPackage(Context cx, AttributeListNode attrs, PackageNameNode name) {
        if (cx.scriptAssistParsing) {
            return this.startPackage(cx, attrs, name, cx.input.pos);
        }
        return this.startPackage(cx, attrs, name, -1);
    }

    public PackageDefinitionNode startPackage(Context cx, AttributeListNode attrs, PackageNameNode name, int pos) {
        if (name == null) {
            name = this.packageName(this.packageIdentifiers(null, this.identifier("", 0), false));
        }
        String id = name.id.toIdentifierString();
        PackageDefinitionNode node = new PackageDefinitionNode(cx, attrs, name, null);
        node.setPositionNonterminal(name, pos);
        this.pkg_names.put(id, node);
        this.pkg_defs.add(node);
        if (this.current_package != null) {
            cx.parser.error(1037);
        }
        this.current_package = node;
        return node;
    }

    public PackageDefinitionNode finishPackage(Context cx, StatementListNode block) {
        return this.finishPackage(cx, block, -1);
    }

    public PackageDefinitionNode finishPackage(Context cx, StatementListNode statements, int pos) {
        if (this.current_package == null) {
            return null;
        }
        PackageDefinitionNode node = this.current_package;
        this.current_package = null;
        if (statements == null) {
            statements = this.statementList((StatementListNode)null, (StatementListNode)null);
        }
        statements.items.add(0, node);
        statements.items.add(node);
        node.statements = statements;
        this.use_stmts = null;
        return node;
    }

    public PackageNameNode packageName(LiteralStringNode url) {
        return this.packageName(url, -1);
    }

    public PackageNameNode packageName(LiteralStringNode url, int pos) {
        PackageNameNode node = new PackageNameNode(url, url.pos());
        node.setPositionNonterminal(url, pos);
        return node;
    }

    public PackageNameNode packageName(PackageIdentifiersNode id) {
        return this.packageName(id, -1);
    }

    public PackageNameNode packageName(PackageIdentifiersNode id, int pos) {
        id.clearIdentifierString();
        String compound_name = id.toIdentifierString();
        this.compound_names.add(compound_name);
        PackageNameNode node = new PackageNameNode(id, id.pos());
        node.setPositionNonterminal(id, pos);
        return node;
    }

    public PackageIdentifiersNode packageIdentifiers(PackageIdentifiersNode node, IdentifierNode item, boolean isDefinition) {
        return this.packageIdentifiers(node, item, isDefinition, -1);
    }

    public PackageIdentifiersNode packageIdentifiers(PackageIdentifiersNode node, IdentifierNode item, boolean isDefinition, int pos) {
        if (node != null) {
            node.list.add(item);
            node.clearIdentifierString();
            String compound_name = node.toIdentifierString();
        } else {
            node = new PackageIdentifiersNode(item, 0, isDefinition);
            node.setPositionNonterminal(node, pos);
        }
        return node;
    }

    public ParameterNode parameter(int kind, IdentifierNode identifier, Node type) {
        return this.parameter(kind, identifier, type, -1);
    }

    public ParameterNode parameter(int kind, IdentifierNode identifier, Node type, int pos) {
        return this.parameter(kind, identifier, type, null, pos);
    }

    public ParameterNode parameter(int kind, IdentifierNode identifier, Node type, Node init) {
        return this.parameter(kind, identifier, type, init, -1);
    }

    public ParameterNode parameter(int kind, IdentifierNode identifier, Node type, Node init, int pos) {
        ParameterNode node = new ParameterNode(kind, identifier, type, init);
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public ParameterListNode parameterList(ParameterListNode list, ParameterNode item) {
        return this.parameterList(list, item, -1);
    }

    public ParameterListNode parameterList(ParameterListNode list, ParameterNode item, int pos) {
        ParameterListNode node;
        if (list != null) {
            list.items.push_back(item);
            node = list;
        } else {
            node = new ParameterListNode(null, item, 0);
            node.setPositionNonterminal(list != null ? list : item, pos);
        }
        return node;
    }

    public ParenExpressionNode parenExpression(Node expr) {
        return this.parenExpression(expr, -1);
    }

    public ParenExpressionNode parenExpression(Node expr, int pos) {
        ParenExpressionNode node = new ParenExpressionNode(expr, 0);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public ParenListExpressionNode parenListExpression(Node expr) {
        return this.parenListExpression(expr, -1);
    }

    public ParenListExpressionNode parenListExpression(Node expr, int pos) {
        ParenListExpressionNode node = new ParenListExpressionNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public Node postfixExpression(int op, Node expr, int pos) {
        Node node;
        MemberExpressionNode member = null;
        if (expr.isList()) {
            ListNode list = (ListNode)expr;
            if (list.items.last().isMemberExpression()) {
                member = (MemberExpressionNode)list.items.last();
            }
        } else if (expr.isMemberExpression()) {
            member = (MemberExpressionNode)expr;
        }
        if (member != null && member.selector.isGetExpression()) {
            GetExpressionNode get = (GetExpressionNode)member.selector;
            member.selector = new IncrementNode(op, get.expr, true);
            member.selector.setMode(get.getMode());
            member.selector.setPositionTerminal(pos);
            node = member.isIndexedMemberExpression() ? this.indexedMemberExpression(member.base, member.selector) : this.memberExpression(member.base, member.selector);
        } else {
            node = this.error(expr.getPosition(), 1106);
            node.setPosition(node.getPosition() - 1);
        }
        return node;
    }

    public PragmaExpressionNode pragmaExpression(IdentifierNode identifier, Node arg, int pos) {
        PragmaExpressionNode node = new PragmaExpressionNode(identifier, arg);
        node.setPositionTerminal(pos);
        return node;
    }

    public PragmaNode pragma(ListNode list, int pos) {
        PragmaNode node = new PragmaNode(list);
        node.setPositionTerminal(pos);
        return node;
    }

    public ProgramNode program(Context cx, StatementListNode statements) {
        return this.program(cx, statements, -1);
    }

    public ProgramNode program(Context cx, StatementListNode statements, int pos) {
        if (statements == null) {
            statements = this.statementList(null, null);
            statements.was_empty = true;
        }
        ProgramNode node = new ProgramNode(cx, statements);
        node.setPositionNonterminal(statements, pos);
        node.pkgdefs.addAll(this.pkg_defs);
        node.has_unnamed_package = this.has_unnamed_package;
        this.use_stmts = null;
        return node;
    }

    public BinaryProgramNode binaryProgram(Context cx, StatementListNode statements) {
        return this.binaryProgram(cx, statements, -1);
    }

    public BinaryProgramNode binaryProgram(Context cx, StatementListNode statements, int pos) {
        if (statements == null) {
            statements = this.statementList(null, null);
            statements.was_empty = true;
        }
        BinaryProgramNode node = new BinaryProgramNode(cx, statements);
        node.setPositionNonterminal(statements, pos);
        node.pkgdefs.addAll(this.pkg_defs);
        node.has_unnamed_package = this.has_unnamed_package;
        return node;
    }

    public QualifiedIdentifierNode qualifiedIdentifier(Node qualifier, IdentifierNode identifier) {
        return this.qualifiedIdentifier(qualifier, identifier, -1);
    }

    public QualifiedIdentifierNode qualifiedIdentifier(Node qualifier, IdentifierNode identifier, int pos) {
        pos = identifier != null ? identifier.pos() : pos;
        QualifiedIdentifierNode node = new QualifiedIdentifierNode(qualifier, identifier, pos);
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public QualifiedExpressionNode qualifiedExpression(Node qualifier, Node expr, int pos) {
        QualifiedExpressionNode node = new QualifiedExpressionNode(qualifier, expr, expr.pos());
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public RestParameterNode restParameter(ParameterNode expr) {
        return this.restParameter(expr, -1);
    }

    public RestParameterNode restParameter(ParameterNode expr, int pos) {
        this.has_rest = true;
        RestParameterNode node = null;
        if (expr == null) {
            this.cx.error(pos - 1, 1030);
        } else {
            node = new RestParameterNode(expr);
            node.setPositionNonterminal(expr, pos);
        }
        return node;
    }

    public RestExpressionNode restExpression(Node expr) {
        return this.restExpression(expr, -1);
    }

    public RestExpressionNode restExpression(Node expr, int pos) {
        RestExpressionNode node = new RestExpressionNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public ReturnStatementNode returnStatement(Node expr) {
        return this.returnStatement(expr, -1);
    }

    public ReturnStatementNode returnStatement(Node expr, int pos) {
        ReturnStatementNode node = new ReturnStatementNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public SetExpressionNode setExpression(Node expr, ArgumentListNode args, boolean is_constinit) {
        return this.setExpression(expr, args, is_constinit, -1);
    }

    public SetExpressionNode setExpression(Node expr, ArgumentListNode args, boolean is_constinit, int pos) {
        SetExpressionNode node = new SetExpressionNode(expr, args);
        node.setPositionNonterminal(expr, pos);
        node.is_constinit = is_constinit;
        return node;
    }

    public SetExpressionNode setExpression(GetExpressionNode get, ArgumentListNode args, boolean is_constinit) {
        return this.setExpression(get, args, is_constinit, -1);
    }

    public SetExpressionNode setExpression(GetExpressionNode get, ArgumentListNode args, boolean is_constinit, int pos) {
        SetExpressionNode node;
        if (get.getIdentifier() != null) {
            node = this.setExpression(get.expr, args, is_constinit, pos);
        } else if (get.expr.hasSideEffect()) {
            RegisterNode reg = this.register(-1);
            ListNode expr = this.list(this.list(null, this.storeRegister(reg, get.expr, this.cx.noType(), -1)), this.loadRegister(reg, this.cx.noType(), -1));
            get.expr = this.loadRegister(reg, this.cx.noType(), -1);
            node = this.setExpression(expr, args, is_constinit, pos);
        } else {
            node = this.setExpression(get.expr, args, is_constinit, pos);
        }
        return node;
    }

    public StatementListNode statementList(StatementListNode list, Node item) {
        return this.statementList(list, item, -1);
    }

    public StatementListNode statementList(StatementListNode list, Node item, int pos) {
        StatementListNode node;
        if (list != null) {
            Node n;
            int i;
            if (item instanceof MetaDataNode && !(item instanceof DocCommentNode)) {
                MetaDataNode meta = (MetaDataNode)item;
                for (i = list.items.size() - 1; i >= 0; --i) {
                    n = (Node)list.items.get(i);
                    if (n instanceof DocCommentNode) {
                        DocCommentNode doc = (DocCommentNode)n;
                        if (doc.metaData != null) break;
                        doc.metaData = meta;
                        break;
                    }
                    if (n instanceof MetaDataNode || n instanceof DefinitionNode) break;
                }
            }
            boolean has_doc = false;
            if (item instanceof DefinitionNode && !(item instanceof IncludeDirectiveNode)) {
                for (i = list.items.size() - 1; i >= 0; --i) {
                    n = (Node)list.items.get(i);
                    if (n instanceof MetaDataNode) {
                        MetaDataNode meta = (MetaDataNode)n;
                        if (meta.def != null) continue;
                        meta.def = (DefinitionNode)item;
                        meta.def.addMetaDataNode(meta);
                        if (!(n instanceof DocCommentNode) || ((DocCommentNode)n).metaData != null) continue;
                        has_doc = true;
                        continue;
                    }
                    if (!(n instanceof IncludeDirectiveNode)) break;
                }
                if (!has_doc && this.create_default_doc_comments) {
                    DefinitionNode def;
                    DocCommentNode dcn = this.docComment(this.literalArray(null), pos);
                    dcn.def = def = (DefinitionNode)item;
                    if (def.metaData == null) {
                        def.addMetaDataNode(dcn);
                    } else {
                        def.metaData.items.add(0, dcn);
                    }
                    list.items.add(dcn);
                }
            }
            if (!this.cx.scriptAssistParsing && item instanceof IncludeDirectiveNode) {
                IncludeDirectiveNode idn = (IncludeDirectiveNode)item;
                list.items.add(idn);
                list.items.addAll(idn.program.statements.items.subList(0, idn.program.statements.items.size()));
                list.items.add(idn);
            } else {
                list.items.add(item);
            }
            node = list;
        } else {
            if (item instanceof DefinitionNode && this.create_default_doc_comments) {
                DefinitionNode def;
                DocCommentNode dcn = this.docComment(this.literalArray(null), pos);
                dcn.def = def = (DefinitionNode)item;
                def.addMetaDataNode(dcn);
                node = new StatementListNode(dcn);
                node.setPositionNonterminal(list != null ? list : item, item != null ? item.pos() : -1);
                node.items.add(item);
            } else {
                node = new StatementListNode(item);
                node.setPositionNonterminal(list != null ? list : item, item != null ? item.pos() : -1);
            }
            if (!this.cx.scriptAssistParsing && item instanceof IncludeDirectiveNode) {
                IncludeDirectiveNode idn = (IncludeDirectiveNode)item;
                node.items.addAll(idn.program.statements.items);
                node.items.add(idn);
            }
        }
        return node;
    }

    public StatementListNode statementList(StatementListNode first, StatementListNode second) {
        if (first == null) {
            first = new StatementListNode(null);
            first.setPositionNonterminal(second, second != null ? second.pos() : -1);
        }
        if (second != null) {
            first.items.addAll(second.items);
        }
        return first;
    }

    public SuperExpressionNode superExpression(Node expr, int pos) {
        SuperExpressionNode node = new SuperExpressionNode(expr);
        node.setPositionTerminal(pos);
        return node;
    }

    public SuperStatementNode superStatement(CallExpressionNode call) {
        return this.superStatement(call, -1);
    }

    public SuperStatementNode superStatement(CallExpressionNode call, int pos) {
        SuperStatementNode node = new SuperStatementNode(call);
        node.setPositionNonterminal(call, pos);
        return node;
    }

    public SwitchStatementNode switchStatement(Node expr, StatementListNode statements) {
        return this.switchStatement(expr, statements, -1);
    }

    public SwitchStatementNode switchStatement(Node expr, StatementListNode statements, int pos) {
        SwitchStatementNode node = new SwitchStatementNode(expr, statements);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public ThisExpressionNode thisExpression(int pos) {
        ThisExpressionNode node = new ThisExpressionNode();
        node.setPositionTerminal(pos);
        return node;
    }

    public ThrowStatementNode throwStatement(Node list, int pos) {
        ThrowStatementNode node = new ThrowStatementNode(list);
        node.setPositionTerminal(pos);
        return node;
    }

    public TryStatementNode tryStatement(StatementListNode tryblock, StatementListNode catchlist, FinallyClauseNode finallyblock) {
        return this.tryStatement(tryblock, catchlist, finallyblock, -1);
    }

    public TryStatementNode tryStatement(StatementListNode tryblock, StatementListNode catchlist, FinallyClauseNode finallyblock, int pos) {
        if (tryblock == null) {
            tryblock = this.statementList(null, this.emptyStatement());
        }
        TryStatementNode node = new TryStatementNode(tryblock, catchlist, finallyblock);
        node.setPositionNonterminal(tryblock, pos);
        return node;
    }

    public FinallyClauseNode finallyClause(StatementListNode block) {
        return this.finallyClause(block, -1);
    }

    public FinallyClauseNode finallyClause(StatementListNode block, int pos) {
        if (block == null) {
            block = this.statementList(null, this.emptyStatement());
        }
        CatchClauseNode catch_clause = this.catchClause(null, this.statementList(null, this.throwStatement(null, 0)));
        FinallyClauseNode node = new FinallyClauseNode(block, catch_clause);
        node.setPositionNonterminal(block, pos);
        return node;
    }

    public TypedIdentifierNode typedIdentifier(Node identifier, Node type) {
        return this.typedIdentifier(identifier, type, -1);
    }

    public TypedIdentifierNode typedIdentifier(Node identifier, Node type, int pos) {
        TypedIdentifierNode node = new TypedIdentifierNode(identifier, type, type != null ? type.pos() : identifier.pos());
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public Node unaryExpression(int op, Node expr) {
        return this.unaryExpression(op, expr, -1);
    }

    public Node unaryExpression(int op, Node expr, int pos) {
        Node node;
        if (op == -69) {
            MemberExpressionNode member = null;
            if (expr.isMemberExpression()) {
                member = expr instanceof MemberExpressionNode ? (MemberExpressionNode)expr : null;
            } else if (expr.isList()) {
                Node item = ((ListNode)expr).items.last();
                MemberExpressionNode memberExpressionNode = member = item instanceof MemberExpressionNode ? (MemberExpressionNode)item : null;
            }
            if (member != null && member.selector.isGetExpression()) {
                GetExpressionNode get = (GetExpressionNode)member.selector;
                member.selector = new DeleteExpressionNode(op, get.expr);
                member.selector.setMode(get.getMode());
                member.selector.setPositionNonterminal(expr, pos);
                node = member.isIndexedMemberExpression() ? this.indexedMemberExpression(member.base, member.selector) : this.memberExpression(member.base, member.selector);
            } else {
                node = new DeleteExpressionNode(op, expr);
                node.setPositionNonterminal(expr, pos);
            }
        } else if (op == -43 || op == -3) {
            MemberExpressionNode member = null;
            while (expr.isList()) {
                ListNode list = (ListNode)expr;
                if (list.size() != 1) {
                    if (op == -43) {
                        return this.error(1107, pos);
                    }
                    return this.error(1108, pos);
                }
                expr = list.items.at(0);
            }
            if (expr.isMemberExpression()) {
                member = (MemberExpressionNode)expr;
            }
            if (member != null && member.selector.isGetExpression()) {
                GetExpressionNode get = (GetExpressionNode)member.selector;
                member.selector = new IncrementNode(op, get.expr, false);
                member.selector.setPositionNonterminal(expr, pos);
                node = member.isIndexedMemberExpression() ? this.indexedMemberExpression(member.base, member.selector) : this.memberExpression(member.base, member.selector);
            } else {
                node = this.error(pos, 1106);
                node.setPositionNonterminal(expr, pos);
            }
        } else if (expr.isLiteralNumber() && (op == -42 || op == -2)) {
            LiteralNumberNode numb = (LiteralNumberNode)expr;
            if (op == -2) {
                numb.negate();
            } else if (this.cx.scriptAssistParsing) {
                numb.value = new StringBuffer().append("+").append(numb.value).toString();
            }
            node = numb;
        } else {
            node = new UnaryExpressionNode(op, expr);
            node.setPositionNonterminal(expr, pos);
        }
        return node;
    }

    public UseDirectiveNode useDirective(AttributeListNode attrs, Node expr) {
        return this.useDirective(attrs, expr, -1);
    }

    public UseDirectiveNode useDirective(AttributeListNode attrs, Node expr, int pos) {
        UseDirectiveNode node = new UseDirectiveNode(this.current_package, attrs, expr);
        node.setPositionNonterminal(expr, pos);
        this.use_stmts = this.statementList(this.use_stmts, node);
        return node;
    }

    public UsePragmaNode usePragma(Node id, Node argument) {
        return this.usePragma(id, argument, -1);
    }

    public UsePragmaNode usePragma(Node id, Node argument, int pos) {
        Node node = null;
        if (id instanceof IdentifierNode && this.cx.statics.es4_numerics) {
            String idval = ((IdentifierNode)id).toIdentifierString();
            if (idval.equals("precision")) {
                node = new UsePrecisionNode(id, argument);
            } else if (idval.equals("rounding")) {
                node = new UseRoundingNode(id, argument);
            } else if (idval.equals("decimal")) {
                node = new UseNumericNode(id, argument, 1);
            } else if (idval.equals("double")) {
                node = new UseNumericNode(id, argument, 2);
            } else if (idval.equals("int")) {
                node = new UseNumericNode(id, argument, 3);
            } else if (idval.equals("uint")) {
                node = new UseNumericNode(id, argument, 4);
            } else if (idval.equals("Number")) {
                node = new UseNumericNode(id, argument, 0);
            }
        }
        if (node == null) {
            node = new UsePragmaNode(id, argument);
        }
        node.setPositionTerminal(pos);
        return node;
    }

    public VariableBindingNode variableBinding(AttributeListNode attrs, int kind, TypedIdentifierNode identifier, Node initializer) {
        return this.variableBinding(attrs, kind, identifier, initializer, -1);
    }

    public VariableBindingNode variableBinding(AttributeListNode attrs, int kind, TypedIdentifierNode identifier, Node initializer, int pos) {
        identifier.identifier = this.qualifiedIdentifier(attrs, identifier.identifier);
        VariableBindingNode node = new VariableBindingNode(this.current_package, attrs, kind, identifier, initializer);
        node.setPositionNonterminal(identifier, pos);
        return node;
    }

    public Node variableDefinition(AttributeListNode attrs, int kind, ListNode list) {
        return this.variableDefinition(attrs, kind, list, -1);
    }

    public Node variableDefinition(AttributeListNode attrs, int kind, ListNode list, int pos) {
        VariableDefinitionNode node = new VariableDefinitionNode(this.current_package, attrs, kind, list, list.pos());
        node.setPositionNonterminal(list, pos);
        return node;
    }

    public WithStatementNode withStatement(Node expr, Node stmt) {
        return this.withStatement(expr, stmt, -1);
    }

    public WithStatementNode withStatement(Node expr, Node stmt, int pos) {
        if (stmt != null) {
            StatementListNode stmtlist;
            StatementListNode statementListNode = stmtlist = stmt instanceof StatementListNode ? (StatementListNode)stmt : null;
            if (stmtlist == null) {
                stmtlist = this.statementList(null, stmt);
                stmt = stmtlist;
            }
        }
        WithStatementNode node = new WithStatementNode(expr, stmt);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public WhileStatementNode whileStatement(Node expr, Node stmt) {
        return this.whileStatement(expr, stmt, -1);
    }

    public WhileStatementNode whileStatement(Node expr, Node stmt, int pos) {
        if (stmt != null) {
            StatementListNode stmtlist;
            StatementListNode statementListNode = stmtlist = stmt instanceof StatementListNode ? (StatementListNode)stmt : null;
            if (stmtlist == null) {
                stmtlist = this.statementList(null, stmt);
                stmt = stmtlist;
            }
        }
        WhileStatementNode node = new WhileStatementNode(expr, stmt);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public InvokeNode invoke(String name, ArgumentListNode args, int pos) {
        InvokeNode node = new InvokeNode(name, args);
        node.setPositionTerminal(pos);
        return node;
    }

    public ErrorNode error(int errCode) {
        return this.error(-1, errCode);
    }

    public ErrorNode error(int pos, int errCode, String arg) {
        ErrorNode node = new ErrorNode(errCode, arg);
        node.setPositionTerminal(pos);
        return node;
    }

    public ErrorNode error(int pos, int errCode) {
        ErrorNode node = new ErrorNode(errCode, "");
        node.setPositionTerminal(pos);
        return node;
    }

    public HasNextNode hasNext(RegisterNode objectRegister, RegisterNode indexRegister, int pos) {
        HasNextNode node = new HasNextNode(objectRegister, indexRegister);
        node.setPositionTerminal(pos);
        return node;
    }

    public LoadRegisterNode loadRegister(RegisterNode reg, TypeValue type, int pos) {
        LoadRegisterNode node = new LoadRegisterNode(reg, type);
        node.setPositionTerminal(pos);
        return node;
    }

    public StoreRegisterNode storeRegister(RegisterNode reg, Node expr, TypeValue type, int pos) {
        StoreRegisterNode node = new StoreRegisterNode(reg, expr, type);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public ToObjectNode toObject(Node expr, int pos) {
        ToObjectNode node = new ToObjectNode(expr);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public Node box(Node expr, TypeValue actual) {
        return this.box(expr, actual, -1);
    }

    public Node box(Node expr, TypeValue actual, int pos) {
        BoxNode node = new BoxNode(expr, actual);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public Node coerce(Node expr, TypeInfo actual, TypeInfo expected, boolean is_explicit) {
        return this.coerce(expr, actual, expected, is_explicit, -1);
    }

    public Node coerce(Node expr, TypeInfo actual, TypeInfo expected, boolean is_explicit, int pos) {
        if (expr instanceof CoerceNode) {
            CoerceNode cn = (CoerceNode)expr;
            if (cn.actual == actual && cn.expected == expected && (cn.is_explicit || !is_explicit)) {
                return expr;
            }
        }
        CoerceNode node = new CoerceNode(expr, actual, expected, is_explicit);
        node.setPositionNonterminal(expr, pos);
        return node;
    }

    public MetaDataNode metaData(LiteralArrayNode data, int pos) {
        MetaDataNode node = new MetaDataNode(data);
        node.setPositionTerminal(pos);
        return node;
    }

    public DocCommentNode docComment(LiteralArrayNode data, int pos) {
        DocCommentNode node = new DocCommentNode(data);
        node.setPositionTerminal(pos);
        return node;
    }

    public CommentNode comment(String val, int ctype, int pos) {
        CommentNode node = new CommentNode(val, ctype);
        node.setPositionTerminal(pos);
        return node;
    }

    public DefaultXMLNamespaceNode defaultXMLNamespace(Node expr, int pos) {
        DefaultXMLNamespaceNode node = new DefaultXMLNamespaceNode(expr);
        node.setPositionTerminal(pos);
        this.dxns = node;
        this.has_dxns = true;
        return node;
    }

    RegisterNode register(int pos) {
        RegisterNode node = new RegisterNode();
        node.setPositionTerminal(pos);
        return node;
    }

    Node filterOperator(Node expr1, Node expr2, int pos) {
        if (this.cx.scriptAssistParsing) {
            MemberExpressionNode result = this.memberExpression(expr1, this.getExpression(expr2));
            return result;
        }
        RegisterNode var_reg = this.register(pos);
        RegisterNode tmp_reg = this.register(pos);
        RegisterNode ndx_reg = this.register(pos);
        RegisterNode obj_reg = this.register(pos);
        InvokeNode checkFilter = this.invoke("[[CheckFilterOperand]]", this.argumentList(null, expr1), pos);
        Node untypedExpr = this.coerce(checkFilter, null, this.cx.noType().getDefaultTypeInfo(), true, pos);
        ListNode init = this.list(this.list(this.list(null, this.storeRegister(ndx_reg, this.literalNumber("0", pos), this.cx.intType(), pos)), this.storeRegister(obj_reg, untypedExpr, this.cx.noType(), pos)), this.storeRegister(tmp_reg, this.literalXML(this.list(null, this.literalString("", pos)), true, pos), this.cx.noType(), pos));
        HasNextNode test = this.hasNext(obj_reg, ndx_reg, pos);
        ExpressionStatementNode incr = this.expressionStatement(this.storeRegister(var_reg, this.memberExpression(this.loadRegister(obj_reg, this.cx.noType(), pos), this.invoke("[[NextValue]]", this.argumentList(null, this.loadRegister(ndx_reg, this.cx.intType(), pos)), pos)), this.cx.noType(), pos));
        incr.isVarStatement(true);
        SetExpressionNode setx = this.setExpression(this.loadRegister(ndx_reg, this.cx.intType(), pos), this.argumentList(null, this.loadRegister(var_reg, this.cx.noType(), pos)), false);
        setx.setMode(-133);
        StatementListNode stmt2 = this.statementList(null, this.expressionStatement(this.memberExpression(this.loadRegister(tmp_reg, this.cx.noType(), pos), setx, pos), pos), pos);
        StatementListNode stmt = this.statementList(null, incr);
        stmt = this.statementList(stmt, this.withStatement(this.loadRegister(var_reg, this.cx.noType(), pos), this.ifStatement(this.list(null, expr2), stmt2, null)));
        Node node = this.forStatement(init, test, null, stmt, false, pos);
        node = this.statementList(this.statementList(this.statementList(null, tmp_reg, pos), node), this.loadRegister(tmp_reg, this.cx.noType(), pos));
        return node;
    }

    public Context getContext() {
        return this.cx;
    }

    public void setContext(Context cx) {
        this.cx = cx;
    }

    public static void main(String[] args) {
        ContextStatics statics = new ContextStatics();
        Context cx = new Context(statics);
        NodeFactory nodeFactory = new NodeFactory(cx);
        nodeFactory.identifier("a");
        nodeFactory.qualifiedIdentifier(nodeFactory.identifier("public"), nodeFactory.identifier("b"));
        nodeFactory.literalNull();
        nodeFactory.literalBoolean(true);
        nodeFactory.literalArray(nodeFactory.argumentList(null, nodeFactory.literalNumber("one")));
        nodeFactory.literalField(nodeFactory.identifier("a"), nodeFactory.literalBoolean(true));
        nodeFactory.literalNumber("3.1415");
        nodeFactory.literalObject(nodeFactory.argumentList(null, nodeFactory.literalField(nodeFactory.identifier("a"), nodeFactory.literalBoolean(true))));
    }

    static {
        $assertionsDisabled = true;
        ARGUMENTS = "arguments".intern();
    }
}

