/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CommentNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.Scanner;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.Token;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UsePragmaNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntList;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public final class Parser {
    private static final boolean debug = false;
    private static final String PUBLIC = "public".intern();
    private static final String PRIVATE = "private".intern();
    private static final String PROTECTED = "protected".intern();
    private static final String ASTERISK = "*".intern();
    private static final String DEFAULT = "default".intern();
    private static final String AS3 = "AS3".intern();
    private static final String CONFIG = "CONFIG".intern();
    private static final String GET = "get".intern();
    private static final String NAMESPACE = "namespace".intern();
    private static final String SET = "set".intern();
    private static final String VEC = "vec".intern();
    private static final String VECTOR = "Vector".intern();
    private static final String __AS3__ = "__AS3__".intern();
    private static final int abbrevIfElse_mode = -71;
    private static final int abbrevDoWhile_mode = -115;
    private static final int abbrevFunction_mode = -78;
    private static final int abbrev_mode = -135;
    private static final int full_mode = -136;
    private static final int allowIn_mode = -137;
    private static final int noIn_mode = -138;
    private static final int catch_parameter_error = 1;
    private static final int syntax_xml_error = 2;
    private static final int syntax_error = 7;
    private static final int expression_syntax_error = 8;
    private static final int syntax_eos_error = 9;
    private static final int[] xmlid_tokens = new int[]{-117, -59, -60, -61, -62, -63, -64, -65, -66, -67, -68, -69, -70, -71, -72, -73, -74, -75, -76, -77, -78, -79, -80, -81, -82, -83, -84, -85, -86, -87, -88, -89, -90, -91, -92, -93, -94, -95, -96, -97, -98, -99, -100, -101, -102, -103, -104, -105, -106, -107, -108, -109, -110, -111, -112, -113, -114, -115, -116};
    static final int xmlid_tokens_count = xmlid_tokens.length;
    private int lastToken;
    private int nexttoken;
    private int thisToken;
    private Context ctx;
    private NodeFactory nodeFactory;
    private boolean create_doc_info;
    private boolean save_comment_nodes;
    public Scanner scanner;
    private String encoding;
    public ObjectList<Node> comments = new ObjectList();
    public IntList block_kind_stack = new IntList();
    public String current_class_name = null;
    private boolean within_package;
    private boolean parsing_include = false;
    private ObjectList<HashSet<String>> config_namespaces = new ObjectList();
    boolean is_xmllist = false;

    Node error(int errCode) {
        return this.error(7, errCode, "", "", -1);
    }

    private Node error(int kind, int errCode) {
        return this.error(kind, errCode, "", "", -1);
    }

    private Node error(int kind, int errCode, String arg1) {
        return this.error(kind, errCode, arg1, "", -1);
    }

    private Node error(int kind, int errCode, String arg1, String arg2) {
        return this.error(kind, errCode, arg1, arg2, -1);
    }

    private Node error(int kind, int errCode, String arg1, String arg2, int pos) {
        int column;
        int lineno;
        String origin = this.scanner.input.origin;
        StringBuffer out = new StringBuffer();
        if (ContextStatics.useSanityStyleErrors) {
            out.append("code=" + errCode + "; arg1=" + arg1 + "; arg2=" + arg2);
        } else {
            String msg = this.ctx.shellErrorString(errCode);
            int nextLoc = Context.replaceStringArg(out, msg, 0, arg1);
            if ((nextLoc = Context.replaceStringArg(out, msg, nextLoc, arg2)) != -1) {
                out.append(msg.substring(nextLoc, msg.length()));
            }
        }
        if (pos < 0) {
            lineno = this.scanner.input.markLn + 1;
            column = this.scanner.input.markCol;
            pos = this.scanner.input.positionOfMark();
        } else {
            lineno = this.scanner.input.getLnNum(pos);
            column = this.scanner.input.getColPos(pos);
        }
        if (kind == 7 || kind == 9) {
            this.ctx.localizedError(origin, lineno, column, out.toString(), this.scanner.input.getLineText(pos), errCode);
        } else {
            this.ctx.localizedError(origin, lineno, column, out.toString(), "", errCode);
        }
        return null;
    }

    private void skiperror() {
        this.skiperror(7);
    }

    private void skiperror(int kind) {
        block14: {
            if (kind < 0) {
                while (true) {
                    if (this.nexttoken == kind) {
                        if (kind == -40) {
                            this.block_kind_stack.clear();
                            for (int size = this.block_kind_stack.size(); size > 0; --size) {
                                this.block_kind_stack.add(-134);
                            }
                        }
                        break block14;
                    }
                    if (this.nexttoken == -1 || this.nexttoken == -26 && kind != -40) break block14;
                    if (this.nexttoken == -35 && kind != -40) {
                        this.scanner.retract();
                        break block14;
                    }
                    if (this.nexttoken == -40) {
                        this.scanner.retract();
                        break block14;
                    }
                    this.nexttoken = this.getNextToken();
                }
            }
            switch (kind) {
                case 1: {
                    do {
                        this.nexttoken = this.getNextToken();
                    } while (this.nexttoken != -14 && this.nexttoken != -1);
                    break;
                }
                case 2: 
                case 9: {
                    do {
                        this.nexttoken = this.getNextToken();
                    } while (this.nexttoken != -1);
                    break;
                }
                default: {
                    while (this.nexttoken != -13 && this.nexttoken != -14 && this.nexttoken != -35 && this.nexttoken != -40 && this.nexttoken != -29 && this.nexttoken != -30 && this.nexttoken != -17 && this.nexttoken != -26 && this.nexttoken != -1) {
                        this.nexttoken = this.getNextToken();
                    }
                    break block0;
                }
            }
        }
        this.lastToken = -134;
    }

    private void init(Context cx, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.ctx = cx;
        this.lastToken = -133;
        this.nexttoken = -133;
        this.thisToken = -133;
        this.create_doc_info = emit_doc_info;
        this.within_package = false;
        this.save_comment_nodes = save_comment_nodes;
        this.nodeFactory = cx.getNodeFactory();
        this.nodeFactory.createDefaultDocComments(emit_doc_info);
        if (block_kind_stack != null) {
            this.block_kind_stack.addAll(block_kind_stack);
        } else {
            this.block_kind_stack.add(-133);
        }
        cx.parser = this;
        cx.setOrigin(origin);
    }

    public Parser(Context cx, InputStream in, String origin) {
        this(cx, in, origin, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding) {
        this.init(cx, origin, false, false, null);
        this.scanner = new Scanner(cx, in, encoding, origin);
        this.encoding = encoding;
    }

    public Parser(Context cx, InputStream in, String origin, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, null, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, encoding, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.init(cx, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.scanner = new Scanner(cx, in, encoding, origin);
        this.encoding = encoding;
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack, boolean is_include) {
        this(cx, in, origin, encoding, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.parsing_include = is_include;
    }

    public Parser(Context cx, String in, String origin) {
        this.init(cx, origin, false, false, null);
        this.scanner = new Scanner(cx, in, origin);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.init(cx, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.scanner = new Scanner(cx, in, origin);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack, boolean is_include) {
        this(cx, in, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.parsing_include = is_include;
    }

    public Parser(Context cx, InputBuffer inputBuffer, String origin) {
        this.init(cx, origin, false, false, null);
        this.scanner = new Scanner(cx, inputBuffer);
    }

    public boolean newline() {
        if (this.nexttoken == -133) {
            this.nexttoken = this.getNextToken();
        }
        return this.scanner.followsLineTerminator();
    }

    public int match(int expectedTokenClass) {
        int result = -134;
        if (!this.lookahead(expectedTokenClass)) {
            if (!this.lookahead(-134)) {
                if (expectedTokenClass == -1) {
                    if (this.ctx.errorCount() == 0) {
                        this.error(7, 1087);
                    }
                    this.skiperror(expectedTokenClass);
                    result = this.nexttoken;
                    this.nexttoken = -133;
                } else if (this.nexttoken == -1) {
                    this.error(9, 1084, Token.getTokenClassName(expectedTokenClass), this.scanner.getTokenText(this.nexttoken));
                    this.skiperror(expectedTokenClass);
                    result = this.nexttoken;
                } else {
                    this.error(9, 1084, Token.getTokenClassName(expectedTokenClass), this.scanner.getTokenText(this.nexttoken));
                    this.skiperror(expectedTokenClass);
                    result = this.nexttoken;
                    this.nexttoken = -133;
                }
            } else {
                result = this.nexttoken;
                this.nexttoken = -133;
            }
        } else if (expectedTokenClass != this.scanner.getTokenClass(this.nexttoken)) {
            result = this.thisToken;
        } else {
            result = this.nexttoken;
            this.lastToken = this.nexttoken;
            this.nexttoken = -133;
        }
        return result;
    }

    int match(int[] expectedTokenClasses, int count) {
        int result = -134;
        if (!this.lookahead(expectedTokenClasses, count)) {
            if (!this.lookahead(-134)) {
                this.error(7, 1084, Token.getTokenClassName(expectedTokenClasses[0]), this.scanner.getTokenText(this.nexttoken));
                this.skiperror(expectedTokenClasses[0]);
            }
            result = this.nexttoken;
            this.nexttoken = -133;
        } else {
            result = this.nexttoken;
            this.lastToken = this.nexttoken;
            this.nexttoken = -133;
        }
        return result;
    }

    public boolean lookaheadSemicolon(int mode) {
        boolean result = false;
        if (this.lookahead(-26) || this.lookahead(-1) || this.lookahead(-40) || this.lookahead(mode) || this.scanner.followsLineTerminator()) {
            result = true;
        }
        return result;
    }

    public boolean lookaheadNoninsertableSemicolon(int mode) {
        boolean result = false;
        if (this.lookahead(-1) || this.lookahead(-40) || this.lookahead(mode)) {
            result = true;
        }
        return result;
    }

    public int matchSemicolon(int mode) {
        int result = -134;
        if (this.lookahead(-26)) {
            result = this.match(-26);
        } else if (this.scanner.followsLineTerminator() || this.lookahead(-1) || this.lookahead(-40)) {
            result = -26;
        } else if ((mode == -71 || mode == -115) && this.lookahead(mode)) {
            result = -26;
        } else if (!this.lookahead(-134)) {
            if (mode == -78) {
                this.error(7, 1158);
                this.skiperror(-35);
            } else {
                this.error(7, 1086, this.scanner.getTokenText(this.nexttoken));
                this.skiperror(-26);
            }
        }
        return result;
    }

    public int matchNoninsertableSemicolon(int mode) {
        int result = -134;
        if (this.lookahead(-26)) {
            result = this.match(-26);
        } else if (this.lookahead(-1) || this.lookahead(-40)) {
            result = -26;
        } else if ((mode == -71 || mode == -115) && this.lookahead(mode)) {
            result = -26;
        } else {
            this.error(7, 1086, this.scanner.getTokenText(this.nexttoken));
            this.skiperror(-26);
        }
        return result;
    }

    public boolean lookahead(int expectedTokenClass) {
        if (this.nexttoken == -133) {
            this.nexttoken = this.getNextToken();
            if (this.nexttoken == -134) {
                // empty if block
            }
        }
        if (expectedTokenClass != this.scanner.getTokenClass(this.nexttoken)) {
            return false;
        }
        this.thisToken = expectedTokenClass;
        return true;
    }

    int getNextToken() {
        int tok = this.scanner.nexttoken(true);
        int tok_type = this.scanner.getTokenClass(tok);
        while (tok_type == -131 || tok_type == -130 || tok_type == -129) {
            if (this.save_comment_nodes && (!this.ctx.scriptAssistParsing || tok_type != -129)) {
                CommentNode newComment = this.nodeFactory.comment(this.scanner.getTokenText(tok), tok_type, this.ctx.input.positionOfMark());
                this.comments.push_back(newComment);
            }
            if (tok_type == -129 && this.create_doc_info) break;
            tok = this.scanner.nexttoken(false);
            tok_type = this.scanner.getTokenClass(tok);
        }
        return tok;
    }

    boolean lookahead(int[] expectedTokenClasses, int count) {
        if (this.nexttoken == -133) {
            this.nexttoken = this.getNextToken();
            if (this.nexttoken == -134) {
                // empty if block
            }
        }
        int tokenclass = this.scanner.getTokenClass(this.nexttoken);
        for (int i = 0; i < count; ++i) {
            if (expectedTokenClasses[i] != tokenclass) continue;
            this.thisToken = tokenclass;
            return true;
        }
        return false;
    }

    public IdentifierNode parseIdentifier() {
        IdentifierNode result = null;
        if (this.lookahead(-79)) {
            this.match(-79);
            result = this.nodeFactory.identifier(GET, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-99)) {
            this.match(-99);
            result = this.nodeFactory.identifier(SET, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-89)) {
            this.match(-89);
            result = this.nodeFactory.identifier(NAMESPACE, false, this.ctx.input.positionOfMark());
        } else {
            result = this.nodeFactory.identifier(this.scanner.getTokenText(this.match(-117)), this.ctx.input.positionOfMark());
        }
        return result;
    }

    public IdentifierNode parsePropertyIdentifier() {
        IdentifierNode result = null;
        if (this.lookahead(-68)) {
            this.match(-68);
            result = this.nodeFactory.identifier(DEFAULT, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-79)) {
            this.match(-79);
            result = this.nodeFactory.identifier(GET, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-99)) {
            this.match(-99);
            result = this.nodeFactory.identifier(SET, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-89)) {
            this.match(-89);
            result = this.nodeFactory.identifier(NAMESPACE, false, this.ctx.input.positionOfMark());
        } else if (Features.HAS_WILDCARDSELECTOR && this.lookahead(-15)) {
            this.match(-15);
            result = this.nodeFactory.identifier(ASTERISK, false, this.ctx.input.positionOfMark());
        } else {
            int pos = this.ctx.input.positionOfMark();
            String id = this.scanner.getTokenText(this.match(-117));
            result = this.nodeFactory.identifier(id, pos);
        }
        return result;
    }

    public IdentifierNode parseQualifier() {
        IdentifierNode result;
        if (this.lookahead(-97)) {
            this.match(-97);
            result = this.nodeFactory.identifier(PUBLIC, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-95)) {
            this.match(-95);
            result = this.nodeFactory.identifier(PRIVATE, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-96)) {
            this.match(-96);
            result = this.nodeFactory.identifier(PROTECTED, false, this.ctx.input.positionOfMark());
        } else {
            result = this.parsePropertyIdentifier();
        }
        return result;
    }

    public IdentifierNode parseSimpleQualifiedIdentifier() {
        boolean is_attr;
        IdentifierNode result = null;
        if (Features.HAS_ATTRIBUTEIDENTIFIERS && this.lookahead(-28)) {
            this.match(-28);
            is_attr = true;
        } else {
            is_attr = false;
        }
        if (is_attr && this.lookahead(-29)) {
            MemberExpressionNode men = this.parseBrackets(null);
            GetExpressionNode gen = men.selector instanceof GetExpressionNode ? (GetExpressionNode)men.selector : null;
            result = this.nodeFactory.qualifiedExpression(null, gen.expr, gen.expr.pos());
        } else {
            IdentifierNode first = this.parseQualifier();
            if (Features.HAS_QUALIFIEDIDENTIFIERS && this.lookahead(-25)) {
                this.match(-25);
                MemberExpressionNode temp = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(first));
                if (this.lookahead(-29)) {
                    MemberExpressionNode men = this.parseBrackets(null);
                    GetExpressionNode gen = men.selector instanceof GetExpressionNode ? (GetExpressionNode)men.selector : null;
                    result = this.nodeFactory.qualifiedExpression(temp, gen.expr, gen.expr.pos());
                } else {
                    QualifiedIdentifierNode qualid = this.nodeFactory.qualifiedIdentifier(temp, this.parsePropertyIdentifier());
                    if (this.config_namespaces.last().contains(first.name)) {
                        qualid.is_config_name = true;
                    }
                    result = qualid;
                    result.setOrigTypeToken(-25);
                }
            } else {
                result = first;
            }
        }
        result.setAttr(is_attr);
        return result;
    }

    public IdentifierNode parseExpressionQualifiedIdentifier() {
        boolean is_attr;
        if (Features.HAS_ATTRIBUTEIDENTIFIERS && this.lookahead(-28)) {
            this.match(-28);
            is_attr = true;
        } else {
            is_attr = false;
        }
        Node first = this.parseParenExpression();
        this.match(-25);
        QualifiedIdentifierNode result = this.nodeFactory.qualifiedIdentifier(first, this.parsePropertyIdentifier());
        result.setAttr(is_attr);
        return result;
    }

    public IdentifierNode parseQualifiedIdentifier() {
        IdentifierNode result = Features.HAS_EXPRESSIONQUALIFIEDIDS && this.lookahead(-13) ? this.parseExpressionQualifiedIdentifier() : this.parseSimpleQualifiedIdentifier();
        return result;
    }

    public Node parsePrimaryExpression() {
        Node result;
        if (this.lookahead(-93)) {
            this.match(-93);
            result = this.nodeFactory.literalNull(this.ctx.input.positionOfMark());
        } else if (this.lookahead(-108)) {
            this.match(-108);
            result = this.nodeFactory.literalBoolean(true, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-74)) {
            this.match(-74);
            result = this.nodeFactory.literalBoolean(false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-95)) {
            this.match(-95);
            result = this.nodeFactory.identifier(PRIVATE, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-97)) {
            this.match(-97);
            result = this.nodeFactory.identifier(PUBLIC, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-96)) {
            this.match(-96);
            result = this.nodeFactory.identifier(PROTECTED, false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-118)) {
            result = this.nodeFactory.literalNumber(this.scanner.getTokenText(this.match(-118)), this.ctx.input.positionOfMark());
        } else if (this.lookahead(-120)) {
            boolean[] is_single_quoted = new boolean[1];
            String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
            result = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
        } else if (this.lookahead(-104)) {
            this.match(-104);
            result = this.nodeFactory.thisExpression(this.ctx.input.positionOfMark());
        } else if (Features.HAS_REGULAREXPRESSIONS && this.lookahead(-119)) {
            result = this.nodeFactory.literalRegExp(this.scanner.getTokenText(this.match(-119)), this.ctx.input.positionOfMark());
        } else if (this.lookahead(-13)) {
            result = this.parseParenListExpression();
        } else if (this.lookahead(-29)) {
            result = this.parseArrayLiteral();
        } else if (this.lookahead(-35)) {
            result = this.parseObjectLiteral();
        } else if (this.lookahead(-78)) {
            this.match(-78);
            IdentifierNode first = null;
            if (this.lookahead(-117)) {
                first = this.parseIdentifier();
            }
            result = this.parseFunctionCommon(first);
        } else if (Features.HAS_XMLLITERALS && (this.lookahead(-124) || this.lookahead(-45))) {
            result = this.parseXMLLiteral();
        } else if (this.lookahead(-94)) {
            if (this.within_package) {
                this.error(7, 1037);
                result = this.nodeFactory.error(this.ctx.input.positionOfMark(), 1037);
            } else {
                this.error(7, 1083, this.scanner.getTokenText(this.nexttoken));
                result = this.nodeFactory.error(this.ctx.input.positionOfMark(), 1083);
            }
            this.skiperror(-35);
            this.skiperror(-40);
        } else if (this.lookahead(-63) || this.lookahead(-76) || this.lookahead(-71)) {
            this.error(7, 1083, this.scanner.getTokenText(this.nexttoken));
            this.skiperror(-35);
            this.skiperror(-40);
            result = this.nodeFactory.error(this.ctx.input.positionOfMark(), 1083);
        } else {
            result = this.parseTypeIdentifier();
        }
        return result;
    }

    public LiteralXMLNode parseXMLLiteral() {
        Node first;
        this.is_xmllist = false;
        LiteralXMLNode result = null;
        int pos = this.ctx.input.positionOfMark();
        if (this.lookahead(-124)) {
            first = this.nodeFactory.list(null, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(-124)), pos));
        } else {
            this.scanner.pushState();
            first = this.parseXMLElement();
            this.scanner.popState();
        }
        if (first != null) {
            ListNode list = this.nodeFactory.list(null, first, pos);
            result = this.nodeFactory.literalXML(list, this.is_xmllist, this.ctx.input.positionOfMark());
        }
        return result;
    }

    Node parseXMLElement() {
        Node result;
        boolean is_xmllist = false;
        this.match(-45);
        this.scanner.enterSlashDivContext();
        if (this.lookahead(-53)) {
            is_xmllist = true;
            result = this.nodeFactory.list(null, this.nodeFactory.literalString("", 0));
        } else {
            result = this.nodeFactory.list(null, this.nodeFactory.literalString("<", 0));
            result = this.parseXMLName(result);
            result = this.parseXMLAttributes(result);
        }
        if (this.lookahead(-53)) {
            this.match(-53);
            if (!is_xmllist) {
                result = this.concatXML(result, this.nodeFactory.literalString(">", 0));
            }
            result = this.parseXMLElementContent(result);
            if (this.lookahead(-1)) {
                this.scanner.exitSlashDivContext();
                this.error(1100);
                return this.nodeFactory.error(this.ctx.input.positionOfMark() - 1, 1100);
            }
            this.match(-127);
            if (this.lookahead(-53)) {
                if (!is_xmllist) {
                    this.ctx.error(this.ctx.input.positionOfMark() - 1, 1110);
                }
            } else {
                result = this.concatXML(result, this.nodeFactory.literalString("</", 0));
                result = this.parseXMLName(result);
                result = this.concatXML(result, this.nodeFactory.literalString(">", 0));
            }
            this.match(-53);
        } else {
            this.match(-126);
            result = this.concatXML(result, this.nodeFactory.literalString("/>", 0));
        }
        this.scanner.exitSlashDivContext();
        this.is_xmllist = is_xmllist;
        return result;
    }

    Node concatXML(Node left, Node right) {
        Node tmpLeft = left;
        if (left instanceof ListNode && ((ListNode)left).size() == 1) {
            tmpLeft = ((ListNode)left).items.first();
        }
        if (tmpLeft instanceof LiteralStringNode && right instanceof LiteralStringNode) {
            return this.nodeFactory.literalString(((LiteralStringNode)tmpLeft).value + ((LiteralStringNode)right).value, left.pos());
        }
        if (left instanceof BinaryExpressionNode && right instanceof LiteralStringNode) {
            BinaryExpressionNode leftBinary = (BinaryExpressionNode)left;
            if (leftBinary.op == -42 && leftBinary.rhs instanceof LiteralStringNode) {
                return this.nodeFactory.binaryExpression(-42, leftBinary.lhs, this.nodeFactory.literalString(((LiteralStringNode)leftBinary.rhs).value + ((LiteralStringNode)right).value), leftBinary.pos());
            }
        }
        return this.nodeFactory.binaryExpression(-42, left, right);
    }

    Node parseXMLName(Node first) {
        Node result;
        if (this.lookahead(-35)) {
            this.match(-35);
            this.scanner.pushState();
            result = this.concatXML(first, this.parseListExpression(-137));
            this.match(-40);
            this.scanner.popState();
        } else {
            if (this.lookahead(xmlid_tokens, xmlid_tokens_count)) {
                result = this.concatXML(first, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(xmlid_tokens, xmlid_tokens_count)), this.ctx.input.positionOfMark()));
            } else {
                this.error(7, 1104, "invalid xml name");
                this.skiperror(2);
                result = this.nodeFactory.error(this.ctx.input.positionOfMark(), 1110);
            }
            while (this.lookahead(-18) || this.lookahead(-2) || this.lookahead(-24)) {
                String separator_text;
                if (this.lookahead(-18)) {
                    this.match(-18);
                    separator_text = ".";
                } else if (this.lookahead(-2)) {
                    this.match(-2);
                    separator_text = "-";
                } else {
                    this.match(-24);
                    separator_text = ":";
                }
                if (this.lookahead(xmlid_tokens, xmlid_tokens_count)) {
                    result = this.concatXML(result, this.nodeFactory.literalString(separator_text, 0));
                    result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(xmlid_tokens, xmlid_tokens_count)), this.ctx.input.positionOfMark()));
                    continue;
                }
                this.error(7, 1110);
                this.skiperror(2);
                result = this.nodeFactory.error(this.ctx.input.positionOfMark(), 1110);
            }
        }
        return result;
    }

    Node parseXMLAttributes(Node first) {
        Node result = first;
        while (!(this.lookahead(-53) || this.lookahead(-126) || this.lookahead(-1))) {
            result = this.concatXML(result, this.nodeFactory.literalString(" ", 0));
            result = this.parseXMLAttribute(result);
        }
        return result;
    }

    Node parseXMLAttribute(Node first) {
        Node result = this.parseXMLName(first);
        if (this.lookahead(-49)) {
            this.match(-49);
            Node value = null;
            boolean single_quote = false;
            if (this.lookahead(-120)) {
                boolean[] is_single_quoted = new boolean[1];
                String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
                value = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
                single_quote = is_single_quoted[0];
            } else if (this.lookahead(-35)) {
                this.match(-35);
                this.scanner.pushState();
                ListNode expr = this.parseListExpression(-137);
                value = this.nodeFactory.invoke("[[ToXMLAttrString]]", this.nodeFactory.argumentList(null, expr), 0);
                this.match(-40);
                this.scanner.popState();
            } else {
                this.error(7, 1205);
            }
            result = this.concatXML(result, this.nodeFactory.literalString(single_quote ? "='" : "=\"", 0));
            result = this.concatXML(result, value);
            result = this.concatXML(result, this.nodeFactory.literalString(single_quote ? "'" : "\"", 0));
        }
        return result;
    }

    Node parseXMLElementContent(Node first) {
        Node result = first;
        this.scanner.pushState();
        this.scanner.state = 411;
        while (!this.lookahead(-127) && !this.lookahead(-1)) {
            if (this.lookahead(-35)) {
                this.match(-35);
                this.scanner.pushState();
                Node expr = this.parseListExpression(-137);
                expr = this.nodeFactory.invoke("[[ToXMLString]]", this.nodeFactory.argumentList(null, expr), 0);
                result = this.concatXML(result, expr);
                this.match(-40);
                this.scanner.popState();
            } else if (this.lookahead(-45)) {
                this.scanner.state = 0;
                result = this.concatXML(result, this.parseXMLElement());
            } else if (this.lookahead(-124)) {
                result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(-124)), this.ctx.input.positionOfMark()));
            } else if (this.lookahead(-125)) {
                result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(-125)), this.ctx.input.positionOfMark()));
            } else {
                this.error(7, 1110);
                this.skiperror(-40);
                this.scanner.popState();
                return result;
            }
            this.scanner.state = 411;
        }
        this.scanner.popState();
        return result;
    }

    public Node parseParenExpression() {
        this.scanner.enterSlashRegExpContext();
        this.match(-13);
        int mark = this.scanner.input.positionOfMark();
        Node result = this.parseAssignmentExpression(-137);
        result.setPosition(mark);
        this.match(-14);
        this.scanner.exitSlashRegExpContext();
        return result;
    }

    public ListNode parseParenListExpression() {
        this.scanner.enterSlashRegExpContext();
        this.match(-13);
        ListNode result = this.parseListExpression(-137);
        this.match(-14);
        this.scanner.exitSlashRegExpContext();
        return result;
    }

    public Node parsePrimaryExpressionOrExpressionQualifiedIdentifier() {
        Node result;
        if (this.lookahead(-13)) {
            ListNode first = this.parseParenListExpression();
            if (Features.HAS_EXPRESSIONQUALIFIEDIDS && this.lookahead(-25)) {
                this.match(-25);
                if (first.size() != 1) {
                    result = this.error(1082);
                    this.skiperror(8);
                } else {
                    result = this.nodeFactory.qualifiedIdentifier(first.items.last(), this.parseIdentifier());
                    result = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(result));
                }
            } else {
                result = first;
            }
        } else {
            result = this.parsePrimaryExpression();
        }
        return result;
    }

    public FunctionCommonNode parseFunctionCommon(IdentifierNode first) {
        StatementListNode third = null;
        boolean saved_has_arguments = this.nodeFactory.has_arguments;
        boolean saved_has_rest = this.nodeFactory.has_rest;
        boolean saved_has_dxns = this.nodeFactory.has_dxns;
        this.nodeFactory.has_arguments = false;
        this.nodeFactory.has_rest = false;
        this.nodeFactory.has_dxns = false;
        boolean is_ctor = false;
        if (this.ctx.statics.es4_nullability && this.block_kind_stack.last() == -64 && first != null && first.name.equals(this.current_class_name)) {
            is_ctor = true;
        }
        this.block_kind_stack.add(-78);
        FunctionSignatureNode second = is_ctor ? this.parseConstructorSignature() : this.parseFunctionSignature();
        DefaultXMLNamespaceNode saved_dxns = this.nodeFactory.dxns;
        if (this.lookahead(-35)) {
            third = this.parseBlock();
            if (third == null) {
                third = this.nodeFactory.statementList(null, null);
            }
        } else {
            this.matchSemicolon(-78);
        }
        FunctionCommonNode result = this.nodeFactory.functionCommon(this.ctx, first, second, third, first != null ? first.pos() : second.pos());
        result.default_dxns = this.nodeFactory.has_dxns ? null : saved_dxns;
        this.nodeFactory.has_arguments = saved_has_arguments;
        this.nodeFactory.has_rest = saved_has_rest;
        this.nodeFactory.has_dxns = saved_has_dxns;
        this.block_kind_stack.removeLast();
        return result;
    }

    public Node parseObjectLiteral() {
        int pos = this.ctx.input.positionOfMark();
        this.scanner.enterSlashRegExpContext();
        this.match(-35);
        ArgumentListNode first = this.lookahead(-40) ? null : this.parseFieldListPrime(this.nodeFactory.argumentList(null, this.parseLiteralField()));
        this.match(-40);
        this.scanner.exitSlashRegExpContext();
        LiteralObjectNode result = this.nodeFactory.literalObject(first, pos);
        return result;
    }

    public ArgumentListNode parseFieldListPrime(ArgumentListNode first) {
        ArgumentListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseLiteralField();
            result = this.parseFieldListPrime(this.nodeFactory.argumentList(first, second));
        } else {
            result = first;
        }
        return result;
    }

    public Node parseLiteralField() {
        ListNode l = null;
        Node first = this.parseFieldOrConfigName();
        if (first.isConfigurationName() && !this.lookahead(-24)) {
            l = this.nodeFactory.list(null, first);
            first = this.parseFieldOrConfigName();
        }
        this.match(-24);
        Node second = this.parseAssignmentExpression(-137);
        Node result = this.nodeFactory.literalField(first, second);
        if (l != null) {
            result = this.nodeFactory.list(l, result);
        }
        return result;
    }

    public Node parseFieldOrConfigName() {
        Node result;
        if (Features.HAS_NONIDENTFIELDNAMES && this.lookahead(-120)) {
            boolean[] is_single_quoted = new boolean[1];
            String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
            result = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
        } else if (Features.HAS_NONIDENTFIELDNAMES && this.lookahead(-118)) {
            result = this.nodeFactory.literalNumber(this.scanner.getTokenText(this.match(-118)), this.ctx.input.positionOfMark());
        } else if (Features.HAS_NONIDENTFIELDNAMES && this.lookahead(-13)) {
            result = this.parseParenExpression();
        } else {
            IdentifierNode ident = this.parseIdentifier();
            if (this.config_namespaces.last().contains(ident.name) && this.lookahead(-25)) {
                this.match(-25);
                QualifiedIdentifierNode qualid = this.nodeFactory.qualifiedIdentifier(ident, this.parseIdentifier());
                qualid.is_config_name = true;
                result = qualid;
            } else {
                result = ident;
            }
        }
        return result;
    }

    public LiteralArrayNode parseArrayLiteral() {
        int pos = this.ctx.input.positionOfMark();
        this.scanner.enterSlashRegExpContext();
        this.match(-29);
        ArgumentListNode first = this.lookahead(-30) ? null : this.parseElementListPrime(this.nodeFactory.argumentList(null, this.parseLiteralElement()));
        LiteralArrayNode result = this.nodeFactory.literalArray(first, pos);
        this.match(-30);
        this.scanner.exitSlashRegExpContext();
        return result;
    }

    public ArgumentListNode parseElementListPrime(ArgumentListNode first) {
        while (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseLiteralElement();
            if (second == null) continue;
            first = this.nodeFactory.argumentList(first, second);
        }
        ArgumentListNode result = first;
        return result;
    }

    public Node parseLiteralElement() {
        Node result;
        if (this.lookahead(-17)) {
            result = this.nodeFactory.emptyElement(this.ctx.input.positionOfMark());
        } else if (this.lookahead(-30)) {
            result = null;
        } else {
            Node first = this.parseAssignmentExpression(-137);
            if (first.isConfigurationName() && !this.lookahead(-17) && !this.lookahead(-30)) {
                ListNode list = this.nodeFactory.list(null, first);
                result = this.nodeFactory.list(list, this.parseAssignmentExpression(-137));
            } else {
                result = first;
            }
        }
        return result;
    }

    public Node parseSuperExpression() {
        this.match(-101);
        Node first = null;
        if (this.lookahead(-13)) {
            first = this.parseParenExpression();
        }
        SuperExpressionNode result = this.nodeFactory.superExpression(first, this.scanner.input.positionOfMark() - 5);
        return result;
    }

    public Node parsePostfixExpression() {
        Node first;
        if (this.lookahead(-97) || this.lookahead(-95) || this.lookahead(-96) || this.lookahead(-68) || this.lookahead(-79) || this.lookahead(-99) || this.lookahead(-117) || this.lookahead(-89) || this.lookahead(-15) || this.lookahead(-28)) {
            first = this.parseAttributeExpression();
            if (!this.lookaheadSemicolon(-136) && (this.lookahead(-43) || this.lookahead(-3))) {
                first = this.parsePostfixIncrement(first);
            }
        } else if (this.lookahead(-93) || this.lookahead(-108) || this.lookahead(-74) || this.lookahead(-118) || this.lookahead(-120) || this.lookahead(-104) || this.lookahead(-119) || this.lookahead(-97) || this.lookahead(-95) || this.lookahead(-96) || this.lookahead(-13) || this.lookahead(-29) || this.lookahead(-35) || this.lookahead(-78)) {
            first = this.parsePrimaryExpressionOrExpressionQualifiedIdentifier();
        } else if (this.lookahead(-101)) {
            first = this.parseSuperExpression();
        } else if (this.lookahead(-92)) {
            first = this.parseShortNewExpression();
            first = this.lookahead(-13) ? this.parseArguments(first) : this.nodeFactory.callExpression(first, null);
            first = this.nodeFactory.newExpression(first);
            if (!this.lookaheadSemicolon(-136) && (this.lookahead(-43) || this.lookahead(-3))) {
                first = this.parsePostfixIncrement(first);
            }
        } else {
            first = this.parseFullNewSubexpression();
            if (this.lookahead(-13)) {
                first = this.parseArguments(first);
            }
        }
        Node result = this.parseFullPostfixExpressionPrime(first);
        return result;
    }

    public Node parsePostfixIncrement(Node first) {
        Node result;
        if (this.lookahead(-43)) {
            result = this.nodeFactory.postfixExpression(this.match(-43), first, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-3)) {
            result = this.nodeFactory.postfixExpression(this.match(-3), first, this.ctx.input.positionOfMark());
        } else {
            result = this.error(1080);
            this.skiperror(7);
        }
        return result;
    }

    public Node parseFullPostfixExpressionPrime(Node first) {
        Node result;
        if (this.lookahead(-18) || this.lookahead(-29) || this.lookahead(-21) || Features.HAS_DESCENDOPERATORS && this.lookahead(-19)) {
            first = this.parsePropertyOperator(first);
            result = this.parseFullPostfixExpressionPrime(first);
        } else if (this.lookahead(-13)) {
            first = this.parseArguments(first);
            result = this.parseFullPostfixExpressionPrime(first);
        } else if (!this.lookaheadSemicolon(-136) && (this.lookahead(-43) || this.lookahead(-3))) {
            first = this.parsePostfixIncrement(first);
            result = this.parseFullPostfixExpressionPrime(first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseAttributeExpression() {
        Node result;
        IdentifierNode ident = this.parseSimpleQualifiedIdentifier();
        MemberExpressionNode first = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(ident));
        if (this.lookahead(-18) || this.lookahead(-29) || this.lookahead(-19) || this.lookahead(-13) || this.lookahead(-28)) {
            result = this.parseAttributeExpressionPrime(first);
        } else {
            MemberExpressionNode memb = first instanceof MemberExpressionNode ? first : null;
            result = first;
        }
        return result;
    }

    public Node parseAttributeExpressionPrime(Node first) {
        Node result = this.lookahead(-18) || this.lookahead(-19) || this.lookahead(-29) || this.lookahead(-21) ? this.parseAttributeExpressionPrime(this.parsePropertyOperator(first)) : (this.lookahead(-13) ? this.parseAttributeExpressionPrime(this.parseArguments(first)) : first);
        return result;
    }

    public Node parseFullOrShortNewExpression() {
        this.match(-92);
        Node first = this.lookahead(-101) ? this.parseSuperExpression() : (this.lookahead(-92) ? this.parseShortNewExpression() : this.parseFullNewSubexpression());
        if (this.lookahead(-13)) {
            first = this.parseArguments(first);
        }
        Node result = this.nodeFactory.newExpression(first);
        return result;
    }

    public Node parseFullNewExpression() {
        this.match(-92);
        Node first = this.parseFullNewSubexpression();
        Node result = this.nodeFactory.newExpression(this.parseArguments(first));
        return result;
    }

    public Node parseFullNewSubexpression() {
        Node result;
        if (this.lookahead(-92)) {
            Node first = this.parseFullNewExpression();
            result = this.parseFullNewSubexpressionPrime(first);
        } else if (this.lookahead(-101)) {
            Node first = this.parseSuperExpression();
            first = this.parsePropertyOperator(first);
            result = this.parseFullNewSubexpressionPrime(first);
        } else if (this.lookahead(-13)) {
            Node first = this.parsePrimaryExpressionOrExpressionQualifiedIdentifier();
            result = this.parseFullNewSubexpressionPrime(first);
        } else if (this.lookahead(-97) || this.lookahead(-95) || this.lookahead(-96) || this.lookahead(-68) || this.lookahead(-79) || this.lookahead(-99) || this.lookahead(-89) || this.lookahead(-15) || this.lookahead(-117) || this.lookahead(-28)) {
            MemberExpressionNode first = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.parseQualifiedIdentifier()));
            result = this.parseFullNewSubexpressionPrime(first);
        } else {
            Node first = this.parsePrimaryExpression();
            result = this.parseFullNewSubexpressionPrime(first);
        }
        return result;
    }

    public Node parseFullNewSubexpressionPrime(Node first) {
        Node result;
        if (this.lookahead(-18) || this.lookahead(-29) || this.lookahead(-21) || Features.HAS_DESCENDOPERATORS && this.lookahead(-19) || this.lookahead(-28)) {
            first = this.parsePropertyOperator(first);
            result = this.parseFullNewSubexpressionPrime(first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseShortNewExpression() {
        this.match(-92);
        Node result = this.parseShortNewSubexpression();
        return result;
    }

    public Node parseShortNewSubexpression() {
        Node result;
        if (this.lookahead(-92)) {
            result = this.parseShortNewExpression();
            if (this.lookahead(-13)) {
                result = this.parseArguments(result);
            }
            result = this.nodeFactory.newExpression(result);
        } else {
            result = this.parseFullNewSubexpression();
        }
        return result;
    }

    public Node parsePropertyOperator(Node first) {
        Node result;
        if (this.lookahead(-18)) {
            this.match(-18);
            if (this.lookahead(-13)) {
                this.scanner.enterSlashRegExpContext();
                this.match(-13);
                result = this.nodeFactory.filterOperator(first, this.parseListExpression(-137), first.pos() - 1);
                this.match(-14);
                this.scanner.exitSlashRegExpContext();
            } else {
                result = this.nodeFactory.memberExpression(first, this.nodeFactory.getExpression(this.parseQualifiedIdentifier()));
            }
        } else if (this.lookahead(-29)) {
            result = this.parseBrackets(first);
        } else if (this.lookahead(-19)) {
            this.match(-19);
            GetExpressionNode selector = this.nodeFactory.getExpression(this.parseQualifiedIdentifier());
            selector.setMode(-19);
            result = this.nodeFactory.memberExpression(first, selector);
        } else if (this.lookahead(-21)) {
            this.match(-21);
            result = this.nodeFactory.applyTypeExpr(first, this.parseTypeExpressionList(), this.ctx.input.positionOfMark());
            if (this.lookahead(-57)) {
                this.nexttoken = -55;
            } else if (this.lookahead(-55)) {
                this.nexttoken = -53;
            } else {
                this.match(-53);
            }
        } else {
            result = null;
        }
        return result;
    }

    public MemberExpressionNode parseBrackets(Node first) {
        ArgumentListNode second;
        this.match(-29);
        if (this.lookahead(-30)) {
            this.error(1099);
            second = null;
        } else {
            second = this.parseArgumentsWithRest(-137);
        }
        this.match(-30);
        MemberExpressionNode result = this.nodeFactory.indexedMemberExpression(first, this.nodeFactory.getExpression(second));
        return result;
    }

    public Node parseArguments(Node first) {
        this.scanner.enterSlashRegExpContext();
        this.match(-13);
        ArgumentListNode second = this.lookahead(-14) ? null : this.parseArgumentsWithRest(-137);
        this.match(-14);
        this.scanner.exitSlashRegExpContext();
        Node result = this.nodeFactory.callExpression(first, second);
        return result;
    }

    public ArgumentListNode parseArgumentsWithRest(int mode) {
        Node first = this.lookahead(-20) ? this.parseRestExpression() : this.parseAssignmentExpression(mode);
        ArgumentListNode result = this.parseArgumentsWithRestPrime(mode, this.nodeFactory.argumentList(null, first));
        return result;
    }

    public ArgumentListNode parseArgumentsWithRestPrime(int mode, ArgumentListNode first) {
        ArgumentListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            if (this.lookahead(-20)) {
                result = this.nodeFactory.argumentList(first, this.parseRestExpression());
            } else {
                Node second = this.parseAssignmentExpression(mode);
                result = this.parseArgumentsWithRestPrime(mode, this.nodeFactory.argumentList(first, second));
            }
        } else {
            result = first;
        }
        return result;
    }

    public Node parseRestExpression() {
        this.match(-20);
        RestExpressionNode result = this.nodeFactory.restExpression(this.parseAssignmentExpression(-137));
        return result;
    }

    public Node parseUnaryExpression() {
        Node result = null;
        if (this.lookahead(-69)) {
            this.match(-69);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-69, this.parsePostfixExpression(), pos);
        } else if (this.lookahead(-113)) {
            this.match(-113);
            if (this.lookahead(-17) || this.lookahead(-26) || this.lookahead(-14)) {
                int pos = this.scanner.input.positionOfMark();
                result = this.nodeFactory.unaryExpression(-113, this.nodeFactory.literalNumber("0", pos), pos);
            } else {
                int pos = this.scanner.input.positionOfMark();
                result = this.nodeFactory.unaryExpression(-113, this.parseUnaryExpression(), pos);
            }
        } else if (this.lookahead(-110)) {
            this.match(-110);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-110, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-43)) {
            this.match(-43);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-43, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-3)) {
            this.match(-3);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-3, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-42)) {
            this.match(-42);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-42, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-2)) {
            this.match(-2);
            int pos = this.scanner.input.positionOfMark();
            result = this.lookahead(-121) ? this.nodeFactory.unaryExpression(-2, this.nodeFactory.literalNumber(this.scanner.getTokenText(this.match(-121)), this.ctx.input.positionOfMark()), this.scanner.input.positionOfMark()) : this.nodeFactory.unaryExpression(-2, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-41)) {
            this.match(-41);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-41, this.parseUnaryExpression(), pos);
        } else if (this.lookahead(-4)) {
            this.match(-4);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.unaryExpression(-4, this.parseUnaryExpression(), pos);
        } else {
            result = this.parsePostfixExpression();
        }
        return result;
    }

    public Node parseMultiplicativeExpression() {
        Node first = null;
        this.lookahead(-22);
        this.scanner.enterSlashDivContext();
        first = this.parseUnaryExpression();
        this.scanner.exitSlashDivContext();
        Node result = this.parseMultiplicativeExpressionPrime(first);
        return result;
    }

    public Node parseMultiplicativeExpressionPrime(Node first) {
        Node result;
        if (this.lookahead(-15)) {
            this.match(-15);
            this.lookahead(-22);
            this.scanner.enterSlashDivContext();
            first = this.nodeFactory.binaryExpression(-15, first, this.parseUnaryExpression());
            this.scanner.exitSlashDivContext();
            result = this.parseMultiplicativeExpressionPrime(first);
        } else if (this.lookahead(-22)) {
            this.match(-22);
            this.lookahead(-22);
            this.scanner.enterSlashDivContext();
            first = this.nodeFactory.binaryExpression(-22, first, this.parseUnaryExpression());
            this.scanner.exitSlashDivContext();
            result = this.parseMultiplicativeExpressionPrime(first);
        } else if (this.lookahead(-7)) {
            this.match(-7);
            this.lookahead(-22);
            this.scanner.enterSlashDivContext();
            first = this.nodeFactory.binaryExpression(-7, first, this.parseUnaryExpression());
            this.scanner.exitSlashDivContext();
            result = this.parseMultiplicativeExpressionPrime(first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseAdditiveExpression() {
        Node first = this.parseMultiplicativeExpression();
        Node result = this.parseAdditiveExpressionPrime(first);
        return result;
    }

    public Node parseAdditiveExpressionPrime(Node first) {
        Node result;
        if (this.lookahead(-42)) {
            this.match(-42);
            first = this.nodeFactory.binaryExpression(-42, first, this.parseMultiplicativeExpression());
            result = this.parseAdditiveExpressionPrime(first);
        } else if (this.lookahead(-2)) {
            this.match(-2);
            first = this.nodeFactory.binaryExpression(-2, first, this.parseMultiplicativeExpression());
            result = this.parseAdditiveExpressionPrime(first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseShiftExpression() {
        Node first = this.parseAdditiveExpression();
        Node result = this.parseShiftExpressionPrime(first);
        return result;
    }

    public Node parseShiftExpressionPrime(Node first) {
        Node result;
        if (this.lookahead(-46)) {
            this.match(-46);
            first = this.nodeFactory.binaryExpression(-46, first, this.parseAdditiveExpression());
            result = this.parseShiftExpressionPrime(first);
        } else if (this.lookahead(-55)) {
            this.match(-55);
            first = this.nodeFactory.binaryExpression(-55, first, this.parseAdditiveExpression());
            result = this.parseShiftExpressionPrime(first);
        } else if (this.lookahead(-57)) {
            this.match(-57);
            first = this.nodeFactory.binaryExpression(-57, first, this.parseAdditiveExpression());
            result = this.parseShiftExpressionPrime(first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseRelationalExpression(int mode) {
        Node first = this.parseShiftExpression();
        Node result = this.parseRelationalExpressionPrime(mode, first);
        return result;
    }

    public Node parseRelationalExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-45)) {
            this.match(-45);
            first = this.nodeFactory.binaryExpression(-45, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-53)) {
            this.match(-53);
            first = this.nodeFactory.binaryExpression(-53, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-48)) {
            this.match(-48);
            first = this.nodeFactory.binaryExpression(-48, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-54)) {
            this.match(-54);
            first = this.nodeFactory.binaryExpression(-54, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-88)) {
            this.match(-88);
            first = this.nodeFactory.binaryExpression(-88, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-60)) {
            this.match(-60);
            first = this.nodeFactory.binaryExpression(-60, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (this.lookahead(-86)) {
            this.match(-86);
            first = this.nodeFactory.binaryExpression(-86, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else if (mode == -137 && this.lookahead(-84)) {
            this.match(-84);
            first = this.nodeFactory.binaryExpression(-84, first, this.parseShiftExpression());
            result = this.parseRelationalExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseEqualityExpression(int mode) {
        Node first = this.parseRelationalExpression(mode);
        Node result = this.parseEqualityExpressionPrime(mode, first);
        return result;
    }

    public Node parseEqualityExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-51)) {
            this.match(-51);
            first = this.nodeFactory.binaryExpression(-51, first, this.parseRelationalExpression(mode));
            result = this.parseEqualityExpressionPrime(mode, first);
        } else if (this.lookahead(-5)) {
            this.match(-5);
            first = this.nodeFactory.binaryExpression(-5, first, this.parseRelationalExpression(mode));
            result = this.parseEqualityExpressionPrime(mode, first);
        } else if (this.lookahead(-52)) {
            this.match(-52);
            first = this.nodeFactory.binaryExpression(-52, first, this.parseRelationalExpression(mode));
            result = this.parseEqualityExpressionPrime(mode, first);
        } else if (Features.HAS_STRICTNOTEQUALS && this.lookahead(-6)) {
            this.match(-6);
            first = this.nodeFactory.binaryExpression(-6, first, this.parseRelationalExpression(mode));
            result = this.parseEqualityExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseBitwiseAndExpression(int mode) {
        Node first = this.parseEqualityExpression(mode);
        Node result = this.parseBitwiseAndExpressionPrime(mode, first);
        return result;
    }

    public Node parseBitwiseAndExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-9)) {
            this.match(-9);
            first = this.nodeFactory.binaryExpression(-9, first, this.parseEqualityExpression(mode));
            result = this.parseBitwiseAndExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseBitwiseXorExpression(int mode) {
        Node first = this.parseBitwiseAndExpression(mode);
        Node result = this.parseBitwiseXorExpressionPrime(mode, first);
        return result;
    }

    public Node parseBitwiseXorExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-31)) {
            this.match(-31);
            first = this.nodeFactory.binaryExpression(-31, first, this.parseBitwiseAndExpression(mode));
            result = this.parseBitwiseXorExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseBitwiseOrExpression(int mode) {
        Node first = this.parseBitwiseXorExpression(mode);
        Node result = this.parseBitwiseOrExpressionPrime(mode, first);
        return result;
    }

    public Node parseBitwiseOrExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-36)) {
            this.match(-36);
            first = this.nodeFactory.binaryExpression(-36, first, this.parseBitwiseXorExpression(mode));
            result = this.parseBitwiseOrExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseLogicalAndExpression(int mode) {
        Node first = this.parseBitwiseOrExpression(mode);
        Node result = this.parseLogicalAndExpressionPrime(mode, first);
        return result;
    }

    public Node parseLogicalAndExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-10)) {
            this.match(-10);
            first = this.nodeFactory.binaryExpression(-10, first, this.parseBitwiseOrExpression(mode));
            result = this.parseLogicalAndExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseLogicalXorExpression(int mode) {
        Node first = this.parseLogicalAndExpression(mode);
        Node result = this.parseLogicalXorExpressionPrime(mode, first);
        return result;
    }

    public Node parseLogicalXorExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-32)) {
            this.match(-32);
            first = this.nodeFactory.binaryExpression(-32, first, this.parseLogicalAndExpression(mode));
            result = this.parseLogicalXorExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseLogicalOrExpression(int mode) {
        Node first = this.parseLogicalXorExpression(mode);
        Node result = this.parseLogicalOrExpressionPrime(mode, first);
        return result;
    }

    public Node parseLogicalOrExpressionPrime(int mode, Node first) {
        Node result;
        if (this.lookahead(-37)) {
            this.match(-37);
            first = this.nodeFactory.binaryExpression(-37, first, this.parseLogicalXorExpression(mode));
            result = this.parseLogicalOrExpressionPrime(mode, first);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseConditionalExpression(int mode) {
        Node result;
        Node first = this.parseLogicalOrExpression(mode);
        if (this.lookahead(-27)) {
            this.match(-27);
            Node second = this.parseAssignmentExpression(mode);
            this.match(-24);
            Node third = this.parseAssignmentExpression(mode);
            result = this.nodeFactory.conditionalExpression(first, second, third);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseNonAssignmentExpression(int mode) {
        Node result;
        Node first = this.parseLogicalOrExpression(mode);
        if (this.lookahead(-27)) {
            this.match(-27);
            Node second = this.parseNonAssignmentExpression(mode);
            this.match(-24);
            Node third = this.parseNonAssignmentExpression(mode);
            result = this.nodeFactory.conditionalExpression(first, second, third);
        } else {
            result = first;
        }
        return result;
    }

    public Node parseAssignmentExpression(int mode) {
        Node first = this.parseConditionalExpression(mode);
        Node result = this.parseAssignmentExpressionSuffix(mode, first);
        return result;
    }

    public Node parseAssignmentExpressionSuffix(int mode, Node first) {
        Node result;
        int second = -134;
        if (this.lookahead(-49) ? (second = this.match(-49)) != -134 : (this.lookahead(-16) ? (second = this.match(-16)) != -134 : (this.lookahead(-23) ? (second = this.match(-23)) != -134 : (this.lookahead(-8) ? (second = this.match(-8)) != -134 : (this.lookahead(-44) ? (second = this.match(-44)) != -134 : (this.lookahead(-50) ? (second = this.match(-50)) != -134 : (this.lookahead(-47) ? (second = this.match(-47)) != -134 : (this.lookahead(-56) ? (second = this.match(-56)) != -134 : (this.lookahead(-58) ? (second = this.match(-58)) != -134 : (this.lookahead(-12) ? (second = this.match(-12)) != -134 : (this.lookahead(-34) ? (second = this.match(-34)) != -134 : this.lookahead(-39) && (second = this.match(-39)) != -134))))))))))) {
            Node third = this.parseAssignmentExpression(mode);
            result = this.nodeFactory.assignmentExpression(first, second, third);
        } else if (Features.HAS_LOGICALASSIGNMENT && this.lookahead(-11) ? (second = this.match(-11)) != -134 : (this.lookahead(-33) ? (second = this.match(-33)) != -134 : this.lookahead(-38) && (second = this.match(-38)) != -134)) {
            Node third = this.parseAssignmentExpression(mode);
            result = this.nodeFactory.assignmentExpression(first, second, third);
        } else {
            result = first;
        }
        return result;
    }

    public ListNode parseListExpression(int mode) {
        Node first = this.parseAssignmentExpression(mode);
        ListNode result = this.parseListExpressionPrime(mode, this.nodeFactory.list(null, first));
        return result;
    }

    public ListNode parseListExpressionPrime(int mode, ListNode first) {
        ListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseAssignmentExpression(mode);
            result = this.parseListExpressionPrime(mode, this.nodeFactory.list(first, second));
        } else {
            result = first;
        }
        return result;
    }

    public IdentifierNode parseNonAttributeQualifiedExpression() {
        IdentifierNode result = this.lookahead(-13) ? this.parseExpressionQualifiedIdentifier() : this.parseSimpleQualifiedIdentifier();
        return result;
    }

    public Node parseTypeName() {
        Node first = this.parseTypeIdentifier();
        return first;
    }

    public ListNode parseTypeNameList() {
        ListNode type_list = null;
        type_list = this.nodeFactory.list(type_list, this.parseTypeName());
        while (this.lookahead(-17)) {
            this.match(-17);
            type_list = this.nodeFactory.list(type_list, this.parseTypeName());
        }
        return type_list;
    }

    public Node parseSimpleTypeIdentifier() {
        IdentifierNode first = this.parseNonAttributeQualifiedExpression();
        MemberExpressionNode result = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression((Node)first, first.pos()), first.pos());
        while (this.lookahead(-18)) {
            this.match(-18);
            result = this.nodeFactory.memberExpression(result, this.nodeFactory.getExpression(this.parseNonAttributeQualifiedExpression()));
        }
        return result;
    }

    public Node parseTypeIdentifier() {
        Node result;
        Node first = this.parseSimpleTypeIdentifier();
        if (this.lookahead(-21)) {
            this.match(-21);
            result = this.nodeFactory.applyTypeExpr(first, this.parseTypeExpressionList(), this.ctx.input.positionOfMark());
            if (this.lookahead(-57)) {
                this.nexttoken = -55;
            } else if (this.lookahead(-55)) {
                this.nexttoken = -53;
            } else {
                this.match(-53);
            }
        }
        result = first;
        return result;
    }

    public Node parseTypeExpression(int mode) {
        TypeExpressionNode result;
        if (this.ctx.dialect(7) && this.thisToken == -117 && this.scanner.getTokenText(this.nexttoken).equals("Object")) {
            this.match(-117);
            result = null;
        } else {
            Node first = this.parseTypeIdentifier();
            boolean is_nullable = true;
            boolean is_explicit = false;
            if (this.lookahead(-4)) {
                this.match(-4);
                is_nullable = false;
                is_explicit = true;
            } else if (this.lookahead(-27)) {
                this.match(-27);
                is_nullable = true;
                is_explicit = true;
            }
            result = this.nodeFactory.typeExpression(first, is_nullable, is_explicit, -1);
        }
        return result;
    }

    public Node parseStatement(int mode) {
        Node result;
        if (this.lookahead(-101)) {
            result = this.parseSuperStatement(mode);
        } else if (this.lookahead(-35)) {
            StatementListNode sln = this.parseBlock();
            result = sln;
        } else if (this.lookahead(-29) || this.lookahead(-122) || this.lookahead(-129)) {
            result = this.parseMetaData();
        } else if (this.lookahead(-81)) {
            result = this.parseIfStatement(mode);
        } else if (this.lookahead(-102)) {
            result = this.parseSwitchStatement();
        } else if (this.lookahead(-70)) {
            result = this.parseDoStatement();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-115)) {
            result = this.parseWhileStatement(mode);
        } else if (this.lookahead(-77)) {
            result = this.parseForStatement(mode);
        } else if (this.lookahead(-116)) {
            result = this.parseWithStatement(mode);
        } else if (this.lookahead(-66)) {
            result = this.parseContinueStatement();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-61)) {
            result = this.parseBreakStatement();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-98)) {
            result = this.parseReturnStatement();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-105)) {
            result = this.parseThrowStatement();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-109)) {
            result = this.parseTryStatement();
        } else {
            result = this.parseLabeledOrExpressionStatement(mode);
            if (!result.isLabeledStatement()) {
                this.matchSemicolon(mode);
            }
        }
        return result;
    }

    public Node parseSubstatement(int mode) {
        Node result;
        if (this.lookahead(-26)) {
            this.match(-26);
            result = this.nodeFactory.emptyStatement();
        } else if (this.lookahead(-112)) {
            result = this.parseVariableDefinition(null, mode);
            this.matchSemicolon(mode);
        } else {
            result = this.parseAnnotatedSubstatementsOrStatement(mode);
        }
        return result;
    }

    public Node parseSuperStatement(int mode) {
        Node result;
        this.match(-101);
        Node first = this.nodeFactory.superExpression(null, this.ctx.input.positionOfMark());
        if (this.lookahead(-13)) {
            CallExpressionNode call;
            Node n = this.parseArguments(first);
            CallExpressionNode callExpressionNode = call = n instanceof CallExpressionNode ? (CallExpressionNode)n : null;
            if (call == null) {
                this.ctx.internalError("Internal error in parseSuperStatement()");
            }
            if (this.lookaheadSemicolon(mode)) {
                result = this.nodeFactory.superStatement(call);
                this.matchSemicolon(mode);
            } else {
                if (call == null || call.args == null || call.args.size() != 1) {
                    this.error(1079);
                } else {
                    Node se;
                    Node node = se = first instanceof SuperExpressionNode ? first : null;
                    if (se != null) {
                        ((SuperExpressionNode)se).expr = (Node)call.args.items.get(0);
                    } else {
                        this.ctx.internalError("internal error in super expression");
                    }
                }
                first = this.parseFullPostfixExpressionPrime(first);
                result = this.nodeFactory.expressionStatement(this.parseListExpressionPrime(mode, this.nodeFactory.list(null, first)));
                this.matchSemicolon(mode);
            }
        } else {
            first = this.parseFullPostfixExpressionPrime(first);
            if (this.lookahead(-49)) {
                first = this.parseAssignmentExpressionSuffix(mode, first);
            }
            result = this.nodeFactory.expressionStatement(this.parseListExpressionPrime(mode, this.nodeFactory.list(null, first)));
            this.matchSemicolon(mode);
        }
        return result;
    }

    public Node parseLabeledOrExpressionStatement(int mode) {
        Node result;
        ListNode first = this.parseListExpression(-137);
        if (this.lookahead(-24)) {
            if (!first.isLabel()) {
                this.error(1078);
            }
            this.match(-24);
            result = this.nodeFactory.labeledStatement(first, this.parseSubstatement(mode));
        } else {
            result = this.nodeFactory.expressionStatement(first);
        }
        return result;
    }

    public StatementListNode parseBlock() {
        return this.parseBlock(null);
    }

    public StatementListNode parseBlock(AttributeListNode first) {
        this.match(-35);
        StatementListNode result = this.parseDirectives(first, null);
        this.match(-40);
        return result;
    }

    public MetaDataNode parseMetaData() {
        MetaDataNode result;
        int pos = this.scanner.input.positionOfMark();
        if (this.lookahead(-129)) {
            ListNode list = this.nodeFactory.list(null, this.nodeFactory.literalString(this.scanner.getTokenText(this.match(-129)), this.ctx.input.positionOfMark()));
            LiteralXMLNode first = this.nodeFactory.literalXML(list, false, this.ctx.input.positionOfMark());
            MemberExpressionNode x = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(first), pos);
            result = this.nodeFactory.docComment(this.nodeFactory.literalArray(this.nodeFactory.argumentList(null, x), pos), pos);
        } else {
            result = this.lookahead(-122) ? this.nodeFactory.metaData(this.nodeFactory.literalArray(this.nodeFactory.argumentList(null, this.parseXMLLiteral())), pos) : this.nodeFactory.metaData(this.parseArrayLiteral(), pos);
        }
        return result;
    }

    public Node parseIfStatement(int mode) {
        Node third = null;
        this.match(-81);
        ListNode first = this.parseParenListExpression();
        Node second = this.parseSubstatement(-71);
        if (this.lookahead(-71)) {
            this.match(-71);
            third = this.parseSubstatement(mode);
        }
        Node result = this.nodeFactory.ifStatement(first, second, third);
        return result;
    }

    public Node parseSwitchStatement() {
        this.match(-102);
        ListNode first = this.parseParenListExpression();
        this.match(-35);
        StatementListNode second = this.parseCaseStatements();
        this.match(-40);
        SwitchStatementNode result = this.nodeFactory.switchStatement(first, second);
        return result;
    }

    public Node parseCaseStatement(int mode) {
        Node result = this.lookahead(-62) || this.lookahead(-68) ? this.parseCaseLabel() : this.parseDirective(null, mode);
        return result;
    }

    public Node parseCaseLabel() {
        CaseLabelNode result;
        if (this.lookahead(-62)) {
            this.match(-62);
            result = this.nodeFactory.caseLabel(this.parseListExpression(-137), this.ctx.input.positionOfMark());
        } else if (this.lookahead(-68)) {
            this.match(-68);
            result = this.nodeFactory.caseLabel(null, this.ctx.input.positionOfMark());
        } else {
            this.error(1077);
            this.skiperror(-40);
            result = null;
        }
        this.match(-24);
        return result;
    }

    public StatementListNode parseCaseStatements() {
        StatementListNode result;
        if (!this.lookahead(-40) && !this.lookahead(-1)) {
            Node first = this.parseCaseLabel();
            result = !this.lookahead(-40) && !this.lookahead(-1) ? this.parseCaseStatementsPrefix(this.nodeFactory.statementList(null, first)) : this.nodeFactory.statementList(null, first);
        } else {
            result = null;
        }
        return result;
    }

    public StatementListNode parseCaseStatementsPrefix(StatementListNode first) {
        StatementListNode result = null;
        if (!this.lookahead(-40) && !this.lookahead(-1)) {
            first = this.nodeFactory.statementList(first, this.parseCaseStatement(-136));
            while (!this.lookahead(-40) && !this.lookahead(-1)) {
                first = this.nodeFactory.statementList(first, this.parseCaseStatement(-136));
            }
            result = first;
        }
        return result;
    }

    public Node parseDoStatement() {
        this.match(-70);
        Node first = this.parseSubstatement(-115);
        this.match(-115);
        DoStatementNode result = this.nodeFactory.doStatement(first, this.parseParenListExpression());
        return result;
    }

    public Node parseWhileStatement(int mode) {
        this.match(-115);
        ListNode first = this.parseParenListExpression();
        Node second = this.parseSubstatement(mode);
        WhileStatementNode result = this.nodeFactory.whileStatement(first, second);
        return result;
    }

    public Node parseForStatement(int mode) {
        Node result;
        boolean is_each = false;
        this.match(-77);
        if (this.lookahead(-117)) {
            String id = this.scanner.getTokenText(this.match(-117));
            if (!id.equals("each")) {
                this.error(7, 1076);
            }
            is_each = true;
        }
        this.match(-13);
        Node first = this.lookahead(-26) ? null : (this.lookahead(-65) || this.lookahead(-112) ? this.parseVariableDefinition(null, -138) : (is_each ? this.nodeFactory.list(null, this.parsePostfixExpression()) : this.parseListExpression(-138)));
        if (this.lookahead(-84)) {
            if (first instanceof VariableDefinitionNode && ((VariableDefinitionNode)first).list.size() > 1) {
                this.error(7, 1200);
            } else if (first instanceof ListNode && ((ListNode)first).size() > 1) {
                this.error(7, 1200);
            }
            this.match(-84);
            ListNode second = this.parseListExpression(-137);
            this.match(-14);
            int pos = this.ctx.input.positionOfMark();
            result = this.nodeFactory.forInStatement(is_each, first, second, this.parseSubstatement(mode), pos);
        } else if (this.lookahead(-24)) {
            this.match(-84);
            this.skiperror(-35);
            result = this.parseSubstatement(mode);
        } else {
            if (is_each) {
                this.error(7, 1075);
            }
            this.match(-26);
            ListNode second = this.lookahead(-26) ? null : this.parseListExpression(-137);
            this.match(-26);
            ListNode third = this.lookahead(-14) ? null : this.parseListExpression(-137);
            this.match(-14);
            int pos = this.ctx.input.positionOfMark();
            result = this.nodeFactory.forStatement(first, second, third, this.parseSubstatement(mode), false, pos);
        }
        return result;
    }

    public Node parseWithStatement(int mode) {
        this.match(-116);
        ListNode first = this.parseParenListExpression();
        WithStatementNode result = this.nodeFactory.withStatement(first, this.parseSubstatement(mode));
        return result;
    }

    public Node parseContinueStatement() {
        IdentifierNode first = null;
        this.match(-66);
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseIdentifier();
        }
        ContinueStatementNode result = this.nodeFactory.continueStatement(first, this.ctx.input.positionOfMark());
        return result;
    }

    public Node parseBreakStatement() {
        IdentifierNode first = null;
        this.match(-61);
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseIdentifier();
        }
        BreakStatementNode result = this.nodeFactory.breakStatement(first, this.ctx.input.positionOfMark());
        return result;
    }

    public Node parseReturnStatement() {
        ListNode first = null;
        this.match(-98);
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseListExpression(-137);
        }
        ReturnStatementNode result = this.nodeFactory.returnStatement(first, this.ctx.input.positionOfMark());
        return result;
    }

    public Node parseThrowStatement() {
        ThrowStatementNode result;
        this.match(-105);
        this.lookahead(-133);
        if (this.newline()) {
            this.error(7, 1196, "", "", this.ctx.input.positionOfMark() - 8);
            result = this.nodeFactory.throwStatement(null, this.ctx.input.positionOfMark());
        } else {
            result = this.nodeFactory.throwStatement(this.parseListExpression(-137), this.ctx.input.positionOfMark());
        }
        return result;
    }

    public Node parseTryStatement() {
        TryStatementNode result;
        this.match(-109);
        StatementListNode first = this.parseBlock();
        if (this.lookahead(-63)) {
            StatementListNode second = this.parseCatchClauses();
            result = this.lookahead(-76) ? this.nodeFactory.tryStatement(first, second, this.parseFinallyClause()) : this.nodeFactory.tryStatement(first, second, null);
        } else if (this.lookahead(-76)) {
            StatementListNode catchClause = this.nodeFactory.statementList(null, this.nodeFactory.catchClause(null, this.nodeFactory.statementList(null, this.nodeFactory.throwStatement(null, 0))));
            result = this.nodeFactory.tryStatement(first, catchClause, this.parseFinallyClause());
        } else {
            this.error(1073);
            this.skiperror(-26);
            result = null;
        }
        return result;
    }

    public StatementListNode parseCatchClauses() {
        StatementListNode result = this.nodeFactory.statementList(null, this.parseCatchClause());
        while (this.lookahead(-63)) {
            result = this.nodeFactory.statementList(result, this.parseCatchClause());
        }
        return result;
    }

    public Node parseCatchClause() {
        this.match(-63);
        this.match(-13);
        ParameterNode first = this.parseParameter();
        this.match(-14);
        CatchClauseNode result = this.nodeFactory.catchClause(first, this.parseBlock());
        return result;
    }

    public FinallyClauseNode parseFinallyClause() {
        this.match(-76);
        FinallyClauseNode result = this.nodeFactory.finallyClause(this.parseBlock());
        return result;
    }

    public Node parseDirective(AttributeListNode first, int mode) {
        Node result = null;
        try {
            if (this.lookahead(-26)) {
                this.matchNoninsertableSemicolon(mode);
                result = this.nodeFactory.emptyStatement();
            } else if (this.lookahead(-112) || this.lookahead(-65) || this.lookahead(-78) || this.lookahead(-64) || this.lookahead(-89) || this.lookahead(-83) || this.lookahead(-85) || this.lookahead(-111) || Features.HAS_INTERFACEDEFINITIONS && this.lookahead(-87)) {
                result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
            } else if (this.lookahead(-68)) {
                this.match(-68);
                String id = this.scanner.getTokenText(this.match(-117));
                if (!id.equals("xml") && this.lookahead(-89)) {
                    this.error(1072);
                }
                this.match(-89);
                this.match(-49);
                result = this.nodeFactory.defaultXMLNamespace(this.parseNonAssignmentExpression(-137), 0);
            } else {
                result = this.parseAnnotatedDirectiveOrStatement(mode);
            }
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public Node parseAnnotatedDirectiveOrStatement(int mode) {
        Node result = null;
        if (this.lookahead(-101) || this.lookahead(-35) || this.lookahead(-81) || this.lookahead(-102) || this.lookahead(-70) || this.lookahead(-115) || this.lookahead(-77) || this.lookahead(-116) || this.lookahead(-66) || this.lookahead(-61) || this.lookahead(-98) || this.lookahead(-105) || this.lookahead(-109) || this.lookahead(-29) || this.lookahead(-129)) {
            result = this.parseStatement(mode);
        } else {
            Node temp;
            if (Features.HAS_SQUAREBRACKETATTRS && this.lookahead(-29)) {
                this.match(-29);
                temp = this.parseAssignmentExpression(-137);
                this.match(-30);
            } else {
                temp = this.parseLabeledOrExpressionStatement(mode);
            }
            String attributeString = this.scanner.getTokenText(this.lastToken);
            String directiveString = this.scanner.getTokenText(this.nexttoken);
            if (!temp.isLabeledStatement()) {
                if (this.lookaheadSemicolon(mode) && !temp.isConfigurationName()) {
                    boolean is_attribute_keyword;
                    ExpressionStatementNode estmt;
                    this.matchSemicolon(mode);
                    result = temp;
                    ExpressionStatementNode expressionStatementNode = estmt = temp instanceof ExpressionStatementNode ? (ExpressionStatementNode)temp : null;
                    if (estmt != null) {
                        temp = estmt.expr;
                    }
                    if (is_attribute_keyword = this.checkAttribute(this.block_kind_stack.last(), temp)) {
                        this.error(7, 1071, attributeString, directiveString);
                    }
                } else if (temp.isAttribute()) {
                    ExpressionStatementNode estmt;
                    ExpressionStatementNode expressionStatementNode = estmt = temp instanceof ExpressionStatementNode ? (ExpressionStatementNode)temp : null;
                    if (estmt != null) {
                        temp = estmt.expr;
                    }
                    boolean is_attribute_keyword = this.checkAttribute(this.block_kind_stack.last(), temp);
                    AttributeListNode first = this.lookahead(-108) || this.lookahead(-74) || this.lookahead(-95) || this.lookahead(-97) || this.lookahead(-96) || this.lookahead(-117) ? this.nodeFactory.attributeList(temp, this.parseAttributes()) : this.nodeFactory.attributeList(temp, null);
                    if (this.lookahead(-112) || this.lookahead(-65) || this.lookahead(-78) || this.lookahead(-64) || this.lookahead(-89) || this.lookahead(-83) || this.lookahead(-111) || this.lookahead(-87) || this.lookahead(-129)) {
                        result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
                    } else if (temp.isConfigurationName() && this.lookahead(-35)) {
                        result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
                    } else if (this.lookahead(-94)) {
                        this.error(1198);
                        result = this.parsePackageDefinition();
                    } else if (is_attribute_keyword || first.size() > 1) {
                        this.error(7, 1071, attributeString, directiveString);
                        this.skiperror(-26);
                    }
                }
            } else {
                result = temp;
            }
        }
        return result;
    }

    public Node parseAnnotatedSubstatementsOrStatement(int mode) {
        Node result = null;
        if (this.lookahead(-101) || this.lookahead(-35) || this.lookahead(-81) || this.lookahead(-102) || this.lookahead(-70) || this.lookahead(-115) || this.lookahead(-77) || this.lookahead(-116) || this.lookahead(-66) || this.lookahead(-61) || this.lookahead(-98) || this.lookahead(-105) || this.lookahead(-109) || this.lookahead(-29) || this.lookahead(-129)) {
            result = this.parseStatement(mode);
        } else {
            Node temp = this.parseLabeledOrExpressionStatement(mode);
            if (!temp.isLabeledStatement()) {
                if (this.lookaheadSemicolon(mode)) {
                    this.matchSemicolon(mode);
                    result = temp;
                } else if (temp.isAttribute()) {
                    this.error(7, 1008);
                } else {
                    this.match(-26);
                    this.skiperror(-26);
                }
            } else {
                result = temp;
            }
        }
        return result;
    }

    public StatementListNode parseSubstatements(AttributeListNode first, StatementListNode second) {
        StatementListNode result = null;
        while (!this.lookahead(-40) && !this.lookahead(-1)) {
            Node third = this.parseSubstatement(-135);
            second = this.nodeFactory.statementList(second, third);
        }
        result = second;
        return result;
    }

    public Node parseAnnotatableDirectiveOrPragmaOrInclude(AttributeListNode first, int mode) {
        Node result = null;
        if (this.lookahead(-65) || this.lookahead(-112)) {
            result = this.parseVariableDefinition(first, mode);
            this.matchSemicolon(mode);
        } else if (this.lookahead(-78)) {
            result = this.parseFunctionDefinition(first);
        } else if (this.lookahead(-64)) {
            result = this.parseClassDefinition(first, mode);
        } else if (this.lookahead(-87)) {
            result = this.parseInterfaceDefinition(first, mode);
        } else if (this.lookahead(-89)) {
            result = this.parseNamespaceDefinition(first);
            this.matchSemicolon(mode);
        } else if (this.lookahead(-83)) {
            result = this.parseImportDirective(first);
            this.matchSemicolon(mode);
        } else if (this.lookahead(-111)) {
            result = this.parseUseDirectiveOrPragma(first);
            this.matchSemicolon(mode);
        } else if (this.lookahead(-85)) {
            result = this.parseIncludeDirective();
            this.matchSemicolon(mode);
        } else if (this.lookahead(-35)) {
            StatementListNode stmts = this.parseBlock();
            stmts.config_attrs = first;
            result = stmts;
            this.matchSemicolon(mode);
        } else {
            this.error(1069);
            this.skiperror(-26);
        }
        return result;
    }

    public StatementListNode parseDirectives(AttributeListNode first, StatementListNode second) {
        Node third;
        StatementListNode result = null;
        while (!this.lookahead(-40) && !this.lookahead(-1) && (third = this.parseDirective(first, -135)) != null) {
            if (third instanceof StatementListNode) {
                StatementListNode sln = (StatementListNode)third;
                if (sln.config_attrs == null && !sln.has_pragma) {
                    if (second == null) {
                        second = sln;
                        continue;
                    }
                    second.items.addAll(sln.items);
                    continue;
                }
                second = this.nodeFactory.statementList(second, third);
                continue;
            }
            if (third instanceof PragmaNode) {
                if (second != null) {
                    for (int i = 0; i < second.items.size(); ++i) {
                        Node kid = second.items.at(i);
                        if (kid instanceof PragmaNode) continue;
                        this.error(7, 1213);
                        break;
                    }
                }
                second = this.nodeFactory.statementList(second, third);
                second.has_pragma = true;
                continue;
            }
            second = this.nodeFactory.statementList(second, third);
        }
        result = second;
        return result;
    }

    public Node parseUseDirectiveOrPragma(AttributeListNode first) {
        Node result = null;
        this.match(-111);
        if (this.lookahead(-89)) {
            this.match(-89);
            result = this.nodeFactory.useDirective(first, this.parseNonAssignmentExpression(-137));
        } else if (this.lookahead(-85)) {
            result = this.parseIncludeDirective();
        } else if (this.ctx.statics.es4_numerics) {
            result = this.nodeFactory.pragma(this.parsePragmaItems(-137), this.ctx.input.positionOfMark());
        } else {
            this.error(1043);
        }
        return result;
    }

    public Node parsePragmaItem(int mode) {
        Node argument;
        IdentifierNode id = this.parseIdentifier();
        if (this.lookahead(-17) || this.lookaheadSemicolon(mode)) {
            argument = null;
        } else if (this.lookahead(-108)) {
            this.match(-108);
            argument = this.nodeFactory.literalBoolean(true, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-74)) {
            this.match(-74);
            argument = this.nodeFactory.literalBoolean(false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-118)) {
            argument = this.nodeFactory.literalNumber(this.scanner.getTokenText(this.match(-118)), this.ctx.input.positionOfMark());
        } else if (this.lookahead(-120)) {
            boolean[] is_single_quoted = new boolean[1];
            String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
            argument = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
        } else {
            argument = this.parseIdentifier();
        }
        UsePragmaNode result = this.nodeFactory.usePragma(id, argument, this.ctx.input.positionOfMark());
        return result;
    }

    public ListNode parsePragmaItems(int mode) {
        ListNode result = null;
        Node first = this.parsePragmaItem(mode);
        result = this.parsePragmaItemsPrime(this.nodeFactory.list(null, first), mode);
        return result;
    }

    public ListNode parsePragmaItemsPrime(ListNode first, int mode) {
        ListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parsePragmaItem(mode);
            result = this.parsePragmaItemsPrime(this.nodeFactory.list(first, second), mode);
        } else {
            result = first;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node parseIncludeDirective() {
        IncludeDirectiveNode result;
        this.match(-85);
        boolean[] is_single_quoted = new boolean[1];
        String filespec = this.scanner.getStringTokenText(this.match(-120), is_single_quoted).trim();
        CompilerHandler.FileInclude incl = null;
        if (this.ctx.handler != null) {
            incl = this.ctx.handler.findFileInclude(this.ctx.path(), filespec);
        }
        InputStream in = null;
        String text = null;
        String fixed_filespec = null;
        String parentPath = null;
        if (incl == null) {
            File inc_file = new File(filespec = filespec.replace('/', File.separatorChar));
            fixed_filespec = inc_file.isAbsolute() ? inc_file.getAbsolutePath() : (this.ctx.path() == null ? "" : this.ctx.path()) + File.separator + filespec;
            try {
                fixed_filespec = new File(fixed_filespec).getCanonicalPath();
            }
            catch (IOException ex) {
                fixed_filespec = new File(fixed_filespec).getAbsolutePath();
            }
            parentPath = fixed_filespec.substring(0, fixed_filespec.lastIndexOf(File.separator));
            if (!this.ctx.scriptAssistParsing) {
                try {
                    in = new BufferedInputStream(new FileInputStream(fixed_filespec));
                }
                catch (FileNotFoundException ex) {
                    this.error(7, 1068, fixed_filespec);
                    return null;
                }
            }
        } else {
            fixed_filespec = incl.fixed_filespec;
            parentPath = incl.parentPath;
            in = incl.in;
            text = incl.text;
        }
        if (this.ctx.statics.includePaths.contains(fixed_filespec)) {
            this.error(7, 1112, fixed_filespec);
            try {
                in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        this.ctx.statics.includePaths.push_back(fixed_filespec);
        String oldCtxPathSpec = this.ctx.path();
        this.ctx.setPath(parentPath);
        LiteralStringNode first = this.nodeFactory.literalString(fixed_filespec, this.ctx.input.positionOfMark(), is_single_quoted[0]);
        ProgramNode second = null;
        if (!this.ctx.scriptAssistParsing) {
            Context cx = new Context(this.ctx.statics);
            try {
                Parser p = null;
                if (in != null) {
                    p = new Parser(cx, in, fixed_filespec, this.encoding, this.create_doc_info, this.save_comment_nodes, this.block_kind_stack, true);
                    p.config_namespaces = this.config_namespaces;
                    second = p.parseProgram();
                } else {
                    p = new Parser(cx, text, fixed_filespec, this.create_doc_info, this.save_comment_nodes, this.block_kind_stack, true);
                    p.config_namespaces = this.config_namespaces;
                    second = p.parseProgram();
                }
            }
            finally {
                this.ctx.setPath(oldCtxPathSpec);
                this.ctx.statics.includePaths.removeLast();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
            result = this.nodeFactory.includeDirective(cx, first, second);
        } else {
            result = this.nodeFactory.includeDirective(this.ctx, first, second);
        }
        return result;
    }

    private boolean checkAttribute(int block_kind, Node node) {
        if (this.block_kind_stack.last() != -134 && this.block_kind_stack.last() != -64 && this.block_kind_stack.last() != -87) {
            if (node.hasAttribute("private")) {
                this.ctx.error(node.pos() - 1, 1013);
            } else if (node.hasAttribute("protected")) {
                this.ctx.error(node.pos() - 1, 1150);
            } else if (node.hasAttribute("static")) {
                this.ctx.error(node.pos() - 1, 1012);
            } else if (this.block_kind_stack.last() != -94 && this.block_kind_stack.last() != -133 && node.hasAttribute("internal")) {
                this.ctx.error(node.pos() - 1, 1115);
            } else if (this.block_kind_stack.last() != -94 && node.hasAttribute("public")) {
                this.ctx.error(node.pos() - 1, 1114);
            }
        }
        if (node.hasAttribute("prototype")) {
            this.ctx.error(node.pos() - 1, 1194);
        }
        return node.hasAttribute("static") || node.hasAttribute("public") || node.hasAttribute("private") || node.hasAttribute("protected") || node.hasAttribute("internal") || node.hasAttribute("native") || node.hasAttribute("final") || node.hasAttribute("override") || node.hasAttribute("prototype");
    }

    public AttributeListNode parseAttributes() {
        Node first = this.parseAttribute();
        this.checkAttribute(this.block_kind_stack.last(), first);
        AttributeListNode second = null;
        if (this.lookahead(-117) || this.lookahead(-95) || this.lookahead(-96) || this.lookahead(-97) || this.lookahead(-74) || this.lookahead(-108)) {
            second = this.parseAttributes();
        }
        AttributeListNode result = this.nodeFactory.attributeList(first, second);
        return result;
    }

    public Node parseAttribute() {
        Node result;
        if (this.lookahead(-108)) {
            this.match(-108);
            result = this.nodeFactory.literalBoolean(true, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-74)) {
            this.match(-74);
            result = this.nodeFactory.literalBoolean(false, this.ctx.input.positionOfMark());
        } else if (this.lookahead(-95)) {
            this.match(-95);
            result = this.nodeFactory.identifier(PRIVATE, false, this.ctx.input.positionOfMark());
            if (this.lookahead(-25)) {
                this.match(-25);
                result = this.nodeFactory.qualifiedIdentifier(result, this.parseIdentifier());
            }
        } else if (this.lookahead(-96)) {
            this.match(-96);
            result = this.nodeFactory.identifier(PROTECTED, false, this.ctx.input.positionOfMark());
            if (this.lookahead(-25)) {
                this.match(-25);
                result = this.nodeFactory.qualifiedIdentifier(result, this.parseIdentifier());
            }
        } else if (this.lookahead(-97)) {
            this.match(-97);
            result = this.nodeFactory.identifier(PUBLIC, false, this.ctx.input.positionOfMark());
            if (this.lookahead(-25)) {
                this.match(-25);
                result = this.nodeFactory.qualifiedIdentifier(result, this.parseIdentifier());
            }
        } else {
            result = this.lookahead(-29) ? this.parseArrayLiteral() : this.parseSimpleTypeIdentifier();
        }
        return result;
    }

    public Node parseImportDirective(AttributeListNode first) {
        PackageNameNode third = null;
        int stmtPos = this.scanner.input.positionOfMark();
        this.match(-83);
        PackageNameNode second = this.parsePackageName(true);
        if (this.lookahead(-49)) {
            third = this.parsePackageName(true);
        }
        ImportDirectiveNode result = this.nodeFactory.importDirective(first, second, third, stmtPos, this.ctx);
        return result;
    }

    public Node parseVariableDefinition(AttributeListNode first, int mode) {
        int second = this.lookahead(-65) ? this.match(-65) : (this.lookahead(-112) ? this.match(-112) : -112);
        ListNode third = this.parseVariableBindingList(first, second, mode);
        Node result = this.nodeFactory.variableDefinition(first, second, third);
        return result;
    }

    public ListNode parseVariableBindingList(AttributeListNode attrs, int kind, int mode) {
        Node first = this.parseVariableBinding(attrs, kind, mode);
        ListNode result = this.parseVariableBindingListPrime(attrs, kind, mode, this.nodeFactory.list(null, first));
        return result;
    }

    public ListNode parseVariableBindingListPrime(AttributeListNode attrs, int kind, int mode, ListNode first) {
        ListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseVariableBinding(attrs, kind, mode);
            result = this.parseVariableBindingListPrime(attrs, kind, mode, this.nodeFactory.list(first, second));
        } else {
            result = first;
        }
        return result;
    }

    public Node parseVariableBinding(AttributeListNode attrs, int kind, int mode) {
        TypedIdentifierNode first = this.parseTypedIdentifier(mode);
        Node second = this.parseVariableInitialization(mode);
        VariableBindingNode result = this.nodeFactory.variableBinding(attrs, kind, first, second);
        return result;
    }

    public Node parseVariableInitialization(int mode) {
        Node result;
        if (this.lookahead(-49)) {
            this.match(-49);
            Node first = this.parseAssignmentExpression(mode);
            result = this.lookahead(-17) || this.lookaheadSemicolon(mode) ? first : (this.ctx.scriptAssistParsing && (this.lookahead(-17) || this.lookaheadSemicolon(mode) || this.lookahead(-84)) ? first : null);
        } else {
            result = null;
        }
        return result;
    }

    public TypedIdentifierNode parseTypedIdentifier(int mode) {
        boolean no_anno;
        Node second;
        IdentifierNode first = this.parseIdentifier();
        if (this.lookahead(-24)) {
            this.match(-24);
            if (this.lookahead(-15)) {
                this.match(-15);
                second = this.ctx.scriptAssistParsing ? this.nodeFactory.identifier(ASTERISK, false) : null;
            } else if (this.lookahead(-16)) {
                this.nexttoken = -49;
                second = null;
            } else {
                second = this.errorIfNextTokenIsKeywordInsteadOfTypeExpression() ? null : this.parseTypeExpression(mode);
            }
            no_anno = false;
        } else {
            second = null;
            no_anno = true;
        }
        TypedIdentifierNode result = this.nodeFactory.typedIdentifier(first, second);
        result.no_anno = no_anno;
        return result;
    }

    public Node parseSimpleVariableDefinition() {
        this.match(-112);
        ListNode result = this.parseUntypedVariableBindingList();
        return result;
    }

    public ListNode parseUntypedVariableBindingList() {
        ListNode first = this.nodeFactory.list(null, this.parseUntypedVariableBinding());
        while (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseUntypedVariableBinding();
            first = this.nodeFactory.list(first, second);
        }
        ListNode result = first;
        return result;
    }

    public Node parseUntypedVariableBinding() {
        IdentifierNode first = this.parseIdentifier();
        Node second = this.parseVariableInitialization(-137);
        VariableBindingNode result = this.nodeFactory.variableBinding(null, -112, this.nodeFactory.typedIdentifier(first, null), second);
        return result;
    }

    public Node parseFunctionDefinition(AttributeListNode first) {
        this.match(-78);
        FunctionNameNode second = this.parseFunctionName();
        FunctionCommonNode third = this.parseFunctionCommon(second.identifier);
        FunctionDefinitionNode result = this.nodeFactory.functionDefinition(this.ctx, first, second, third);
        return result;
    }

    public FunctionNameNode parseFunctionName() {
        FunctionNameNode result;
        if (this.lookahead(-79)) {
            this.match(-79);
            result = this.lookahead(-13) ? this.nodeFactory.functionName(-133, this.nodeFactory.identifier(GET, false, this.ctx.input.positionOfMark())) : this.nodeFactory.functionName(-79, this.parseIdentifier());
        } else if (this.lookahead(-99)) {
            this.match(-99);
            result = this.lookahead(-13) ? this.nodeFactory.functionName(-133, this.nodeFactory.identifier(SET, false, this.ctx.input.positionOfMark())) : this.nodeFactory.functionName(-99, this.parseIdentifier());
        } else {
            result = this.nodeFactory.functionName(-133, this.parseIdentifier());
        }
        return result;
    }

    public FunctionSignatureNode parseFunctionSignature() {
        boolean[] no_anno = new boolean[1];
        boolean[] void_anno = new boolean[1];
        this.match(-13);
        ParameterListNode first = this.parseParameters();
        this.match(-14);
        Node second = this.parseResultSignature(no_anno, void_anno);
        FunctionSignatureNode result = this.nodeFactory.functionSignature(first, second, this.ctx.input.positionOfMark());
        result.no_anno = no_anno[0];
        result.void_anno = void_anno[0];
        return result;
    }

    public FunctionSignatureNode parseConstructorSignature() {
        FunctionSignatureNode result;
        boolean[] no_anno = new boolean[1];
        boolean[] void_anno = new boolean[1];
        this.match(-13);
        ParameterListNode first = this.parseParameters();
        this.match(-14);
        ListNode second = this.parseConstructorInitializer(no_anno, void_anno);
        if (void_anno[0]) {
            result = this.nodeFactory.functionSignature(first, null, this.ctx.input.positionOfMark());
            result.no_anno = false;
            result.void_anno = true;
        } else {
            result = this.nodeFactory.constructorSignature(first, second, this.ctx.input.positionOfMark());
            result.no_anno = true;
            result.void_anno = false;
        }
        return result;
    }

    public ListNode parseConstructorInitializer(boolean[] no_anno, boolean[] void_anno) {
        ListNode result = null;
        no_anno[0] = true;
        void_anno[0] = false;
        if (this.lookahead(-24)) {
            this.match(-24);
            if (this.lookahead(-113)) {
                this.match(-113);
                no_anno[0] = false;
                void_anno[0] = true;
                return null;
            }
            result = this.parseInitializerList();
            if (this.lookahead(-101)) {
                result = this.nodeFactory.list(result, this.parseSuperInitializer());
            }
        } else {
            result = null;
        }
        return result;
    }

    public Node parseSuperInitializer() {
        CallExpressionNode call;
        this.match(-101);
        SuperStatementNode result = null;
        SuperExpressionNode first = this.nodeFactory.superExpression(null, this.ctx.input.positionOfMark());
        Node n = this.parseArguments(first);
        CallExpressionNode callExpressionNode = call = n instanceof CallExpressionNode ? (CallExpressionNode)n : null;
        if (call == null) {
            this.ctx.internalError("Internal error in parseSuperInitializer()");
        }
        result = this.nodeFactory.superStatement(call);
        return result;
    }

    public ListNode parseInitializerList() {
        ListNode result = null;
        if (this.lookahead(-101)) {
            result = null;
        } else {
            Node first = this.parseInitializer();
            result = this.parseInitializerListPrime(this.nodeFactory.list(null, first));
        }
        return result;
    }

    public ListNode parseInitializerListPrime(ListNode first) {
        ListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            if (this.lookahead(-101)) {
                result = first;
            } else {
                Node second = this.parseInitializer();
                result = this.parseInitializerListPrime(this.nodeFactory.list(first, second));
            }
        } else {
            result = first;
        }
        return result;
    }

    public Node parseInitializer() {
        Node result = null;
        IdentifierNode first = this.parseIdentifier();
        Node second = null;
        if (this.lookahead(-49)) {
            second = this.parseVariableInitialization(-137);
        } else {
            this.ctx.error(first.pos() - 1, 1069);
        }
        result = this.nodeFactory.assignmentExpression(first, -49, second);
        return result;
    }

    public ParameterListNode parseParameters() {
        ParameterListNode result = this.lookahead(-14) ? null : this.parseNonemptyParameters(null);
        return result;
    }

    public ParameterListNode parseNonemptyParameters(ParameterListNode first) {
        ParameterListNode result;
        if (this.lookahead(-20)) {
            result = this.nodeFactory.parameterList(first, this.parseRestParameter());
        } else {
            ParameterNode second = this.parseParameter();
            if (this.lookahead(-17)) {
                this.match(-17);
                result = this.parseNonemptyParameters(this.nodeFactory.parameterList(first, second));
            } else if (this.lookahead(-49)) {
                this.match(-49);
                second.init = this.parseNonAssignmentExpression(-137);
                if (this.lookahead(-17)) {
                    this.match(-17);
                    result = this.parseNonemptyParameters(this.nodeFactory.parameterList(first, second));
                } else {
                    result = this.nodeFactory.parameterList(first, second);
                }
            } else {
                result = this.nodeFactory.parameterList(first, second);
            }
        }
        return result;
    }

    public ParameterNode parseRestParameter() {
        this.match(-20);
        ParameterNode first = this.lookahead(-65) || this.lookahead(-117) || this.lookahead(-79) || this.lookahead(-99) ? this.parseParameter() : null;
        RestParameterNode result = this.nodeFactory.restParameter(first, this.ctx.input.positionOfMark());
        return result;
    }

    public ParameterNode parseParameter() {
        Node third;
        boolean no_anno = false;
        int first = Features.HAS_CONSTPARAMETERS && this.lookahead(-65) ? this.match(-65) : -112;
        IdentifierNode second = this.parseIdentifier();
        if (this.lookahead(-24)) {
            this.match(-24);
            if (this.lookahead(-15)) {
                this.match(-15);
                second.setOrigTypeToken(-15);
                third = null;
            } else if (this.lookahead(-16)) {
                this.nexttoken = -49;
                second.setOrigTypeToken(-16);
                third = null;
            } else {
                third = this.errorIfNextTokenIsKeywordInsteadOfTypeExpression() ? null : this.parseTypeExpression(-137);
            }
        } else {
            third = null;
            no_anno = true;
        }
        ParameterNode result = this.nodeFactory.parameter(first, second, third);
        result.no_anno = no_anno;
        return result;
    }

    public Node parseResultSignature(boolean[] no_anno, boolean[] void_anno) {
        Node result;
        no_anno[0] = false;
        void_anno[0] = false;
        if (this.lookahead(-24)) {
            this.match(-24);
            if (this.lookahead(-15)) {
                this.match(-15);
                result = this.ctx.scriptAssistParsing ? this.nodeFactory.identifier(ASTERISK, false, this.ctx.input.positionOfMark()) : null;
            } else if (this.lookahead(-16)) {
                this.nexttoken = -49;
                result = null;
            } else if (this.lookahead(-113)) {
                this.match(-113);
                result = null;
                void_anno[0] = true;
            } else {
                this.errorIfNextTokenIsKeywordInsteadOfTypeExpression();
                result = this.parseTypeExpression(-137);
            }
        } else {
            result = null;
            no_anno[0] = true;
        }
        return result;
    }

    private boolean errorIfNextTokenIsKeywordInsteadOfTypeExpression() {
        if (this.lookahead(-113)) {
            this.error(7, 1135, this.scanner.getTokenText(this.nexttoken));
            this.match(-113);
            return true;
        }
        if (this.lookahead(xmlid_tokens, xmlid_tokens_count) && this.thisToken != -117) {
            this.error(7, 1135, this.scanner.getTokenText(this.nexttoken));
            this.match(xmlid_tokens, xmlid_tokens_count);
            return true;
        }
        if (this.ctx.dialect(8) && this.thisToken == -117 && this.scanner.getTokenText(this.nexttoken).equals("Object")) {
            this.error(7, 1179);
            return true;
        }
        return false;
    }

    public Node parseClassDefinition(AttributeListNode attrs, int mode) {
        this.match(-64);
        if (this.block_kind_stack.last() != -94 && this.block_kind_stack.last() != -133) {
            this.error(7, 1131);
        }
        this.block_kind_stack.add(-64);
        ClassNameNode first = this.parseClassName();
        String temp_class_name = this.current_class_name;
        this.current_class_name = first.ident.name;
        if (first.pkgname != null) {
            this.nodeFactory.startPackage(this.ctx, null, first.pkgname);
        }
        this.nodeFactory.StartClassDefs();
        InheritanceNode second = this.parseInheritance();
        StatementListNode third = this.parseBlock();
        ClassDefinitionNode result = this.nodeFactory.classDefinition(this.ctx, attrs, first.ident, second, third, first.non_nullable);
        this.block_kind_stack.removeLast();
        this.current_class_name = temp_class_name;
        if (first.pkgname != null) {
            this.nodeFactory.finishPackage(this.ctx, null);
        }
        return result;
    }

    public ClassNameNode parseClassName() {
        IdentifierNode first = this.parseIdentifier();
        ClassNameNode result = Features.HAS_COMPOUNDCLASSNAMES ? this.parseClassNamePrime(first) : this.nodeFactory.className(null, first);
        if (this.ctx.statics.es4_nullability) {
            if (this.lookahead(-4)) {
                this.match(-4);
                result.non_nullable = true;
            } else if (this.lookahead(-27)) {
                this.match(-27);
            }
        }
        return result;
    }

    public ClassNameNode parseClassNamePrime(IdentifierNode second) {
        PackageIdentifiersNode first = null;
        while (this.lookahead(-18)) {
            this.match(-18);
            first = this.nodeFactory.packageIdentifiers(first, second, true);
            second = this.parseIdentifier();
        }
        PackageNameNode pkgname = first != null ? this.nodeFactory.packageName(first) : null;
        ClassNameNode result = this.nodeFactory.className(pkgname, second);
        return result;
    }

    public InheritanceNode parseInheritance() {
        ListNode second;
        Node first;
        InheritanceNode result = null;
        if (this.lookahead(-73)) {
            this.match(-73);
            first = this.parseTypeName();
        } else {
            first = null;
        }
        if (this.lookahead(-82)) {
            this.match(-82);
            second = this.parseTypeNameList();
        } else {
            second = null;
        }
        if (first != null || second != null) {
            result = this.nodeFactory.inheritance(first, second);
        }
        return result;
    }

    public ListNode parseTypeExpressionList() {
        Node first = this.parseTypeExpression(-137);
        ListNode result = this.parseTypeExpressionListPrime(this.nodeFactory.list(null, first));
        return result;
    }

    public ListNode parseTypeExpressionListPrime(ListNode first) {
        ListNode result;
        if (this.lookahead(-17)) {
            this.match(-17);
            Node second = this.parseTypeExpression(-137);
            result = this.parseTypeExpressionListPrime(this.nodeFactory.list(first, second));
        } else {
            result = first;
        }
        return result;
    }

    public ListNode parseExtendsList() {
        ListNode result;
        if (this.lookahead(-73)) {
            this.match(-73);
            result = this.parseTypeNameList();
        } else {
            result = null;
        }
        return result;
    }

    public Node parseInterfaceDefinition(AttributeListNode attrs, int mode) {
        this.match(-87);
        this.block_kind_stack.add(-87);
        ClassNameNode first = this.parseClassName();
        if (first.pkgname != null) {
            this.nodeFactory.startPackage(this.ctx, null, first.pkgname);
        }
        ListNode second = this.parseExtendsList();
        StatementListNode third = this.parseBlock();
        InterfaceDefinitionNode result = this.nodeFactory.interfaceDefinition(this.ctx, attrs, first.ident, second, third);
        this.block_kind_stack.removeLast();
        if (first.pkgname != null) {
            this.nodeFactory.finishPackage(this.ctx, null);
        }
        return result;
    }

    public NamespaceDefinitionNode parseNamespaceDefinition(AttributeListNode first) {
        if (first != null && first.items.size() == 1 && first.hasAttribute("config")) {
            first = null;
            return this.parseConfigNamespaceDefinition(first);
        }
        IdentifierNode second = null;
        Node third = null;
        this.match(-89);
        second = this.parseIdentifier();
        if (this.lookahead(-49)) {
            this.match(-49);
            if (this.ctx.statics.es4_nullability) {
                if (this.lookahead(-120)) {
                    boolean[] is_single_quoted = new boolean[1];
                    String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
                    third = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
                } else {
                    third = this.parseSimpleTypeIdentifier();
                }
            } else {
                third = this.parseAssignmentExpression(-137);
            }
        }
        NamespaceDefinitionNode result = this.nodeFactory.namespaceDefinition(first, second, third);
        return result;
    }

    public NamespaceDefinitionNode parseConfigNamespaceDefinition(AttributeListNode first) {
        this.match(-89);
        IdentifierNode second = this.parseIdentifier();
        NamespaceDefinitionNode result = this.nodeFactory.configNamespaceDefinition(first, second, -1);
        this.config_namespaces.last().add(result.name.name);
        return result;
    }

    private UseDirectiveNode generateAs3UseDirective(Context ctx) {
        IdentifierNode as3Identifier = this.nodeFactory.identifier(AS3, false);
        Namespaces namespaces = new Namespaces();
        NamespaceValue namespaceValue = new NamespaceValue();
        namespaces.add(namespaceValue);
        ReferenceValue referenceValue = new ReferenceValue(ctx, null, AS3, namespaces);
        referenceValue.setIsAttributeIdentifier(false);
        as3Identifier.ref = referenceValue;
        return this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(as3Identifier)));
    }

    public PackageDefinitionNode parsePackageDefinition() {
        PackageDefinitionNode result;
        if (this.within_package) {
            this.error(1037);
        }
        this.within_package = true;
        this.nodeFactory.dxns = null;
        this.block_kind_stack.add(-94);
        this.match(-94);
        HashSet conf_ns = new HashSet(this.config_namespaces.last().size());
        conf_ns.addAll(this.config_namespaces.last());
        this.config_namespaces.push_back(conf_ns);
        if (this.lookahead(-35)) {
            result = this.nodeFactory.startPackage(this.ctx, null, null);
            UseDirectiveNode udn = this.generateAs3UseDirective(this.ctx);
            ObjectList<UseDirectiveNode> udns = null;
            if (!this.ctx.statics.use_namespaces.isEmpty()) {
                udns = new ObjectList<UseDirectiveNode>();
                Iterator i$ = this.ctx.statics.use_namespaces.iterator();
                while (i$.hasNext()) {
                    String useName = (String)i$.next();
                    udns.add(this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.nodeFactory.identifier(useName)))));
                }
            }
            ImportDirectiveNode idn = null;
            if (this.ctx.statics.es4_vectors) {
                PackageIdentifiersNode pin = this.nodeFactory.packageIdentifiers(null, this.nodeFactory.identifier(__AS3__, false), true);
                pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VEC, false), true);
                pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VECTOR, false), true);
                idn = this.nodeFactory.importDirective(null, this.nodeFactory.packageName(pin), null, this.ctx);
            }
            result = this.nodeFactory.finishPackage(this.ctx, this.parseBlock());
            if (this.ctx.dialect(10) && result != null) {
                result.statements.items.add(1, udn);
            }
            if (this.ctx.statics.es4_vectors && result != null) {
                result.statements.items.add(1, idn);
            }
            if (udns != null && result != null) {
                Iterator i$ = udns.iterator();
                while (i$.hasNext()) {
                    UseDirectiveNode usenode = (UseDirectiveNode)i$.next();
                    result.statements.items.add(1, usenode);
                }
            }
        } else {
            PackageNameNode first = this.parsePackageName(false);
            result = this.nodeFactory.startPackage(this.ctx, null, first);
            UseDirectiveNode udn = this.generateAs3UseDirective(this.ctx);
            ObjectList<UseDirectiveNode> udns = null;
            if (!this.ctx.statics.use_namespaces.isEmpty()) {
                udns = new ObjectList<UseDirectiveNode>();
                Iterator i$ = this.ctx.statics.use_namespaces.iterator();
                while (i$.hasNext()) {
                    String useName = (String)i$.next();
                    udns.add(this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.nodeFactory.identifier(useName)))));
                }
            }
            ImportDirectiveNode idn = null;
            if (this.ctx.statics.es4_vectors) {
                PackageIdentifiersNode pin = this.nodeFactory.packageIdentifiers(null, this.nodeFactory.identifier(__AS3__, false), true);
                pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VEC, false), true);
                pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VECTOR, false), true);
                idn = this.nodeFactory.importDirective(null, this.nodeFactory.packageName(pin), null, this.ctx);
            }
            result = this.nodeFactory.finishPackage(this.ctx, this.parseBlock());
            if (this.ctx.dialect(10) && result != null) {
                result.statements.items.add(1, udn);
            }
            if (udns != null && result != null) {
                Iterator i$ = udns.iterator();
                while (i$.hasNext()) {
                    UseDirectiveNode usenode = (UseDirectiveNode)i$.next();
                    result.statements.items.add(1, usenode);
                }
            }
            if (this.ctx.statics.es4_vectors && result != null) {
                result.statements.items.add(1, idn);
            }
        }
        this.block_kind_stack.removeLast();
        this.config_namespaces.pop_back();
        this.within_package = false;
        return result;
    }

    private StatementListNode parseConfigValues() {
        StatementListNode configs = null;
        String config_code = this.ctx.getConfigVarCode();
        if (config_code != null) {
            Scanner orig = this.scanner;
            InputBuffer input = this.ctx.input;
            int orig_lastToken = this.lastToken;
            int orig_nextToken = this.nexttoken;
            int orig_thisToken = this.thisToken;
            this.scanner = new Scanner(this.ctx, config_code, "");
            this.scanner.input.report_pos = false;
            configs = this.parseDirectives(null, null);
            this.scanner = orig;
            this.ctx.input = input;
            this.lastToken = orig_lastToken;
            this.nexttoken = orig_nextToken;
            this.thisToken = orig_thisToken;
        }
        return configs;
    }

    public PackageNameNode parsePackageName(boolean isDefinition) {
        PackageNameNode result;
        if (this.lookahead(-120)) {
            boolean[] is_single_quoted = new boolean[1];
            String enclosedText = this.scanner.getStringTokenText(this.match(-120), is_single_quoted);
            LiteralStringNode first = this.nodeFactory.literalString(enclosedText, this.ctx.input.positionOfMark(), is_single_quoted[0]);
            result = this.nodeFactory.packageName(first);
        } else {
            PackageIdentifiersNode first = this.nodeFactory.packageIdentifiers(null, this.parseIdentifier(), isDefinition);
            result = this.parsePackageNamePrime(first, isDefinition);
        }
        return result;
    }

    public PackageNameNode parsePackageNamePrime(PackageIdentifiersNode first, boolean isDefinition) {
        while (this.lookahead(-18)) {
            this.match(-18);
            first = this.nodeFactory.packageIdentifiers(first, this.parsePropertyIdentifier(), isDefinition);
        }
        PackageNameNode result = this.nodeFactory.packageName(first);
        return result;
    }

    public ProgramNode parseProgram() {
        StatementListNode first = null;
        StatementListNode second = null;
        StatementListNode configs = null;
        if (!this.parsing_include) {
            this.config_namespaces.push_back(new HashSet());
            this.config_namespaces.last().add(CONFIG);
            configs = this.parseConfigValues();
        }
        while (this.lookahead(-94) || this.lookahead(-129)) {
            MetaDataNode meta = null;
            if (this.lookahead(-129) || this.lookahead(-29) || this.lookahead(-122)) {
                meta = this.parseMetaData();
                second = this.nodeFactory.statementList(second, meta);
            }
            if (!this.lookahead(-94)) continue;
            PackageDefinitionNode pkgdef = this.parsePackageDefinition();
            first = this.nodeFactory.statementList(first, pkgdef);
            if (meta != null) {
                meta.def = pkgdef;
                pkgdef.addMetaDataNode(meta);
            }
            if (pkgdef == null) continue;
            second = this.nodeFactory.statementList(second, pkgdef.statements);
        }
        second = this.parseDirectives(null, second);
        if (this.ctx.dialect(10) && !this.parsing_include && second != null) {
            UseDirectiveNode udn = this.generateAs3UseDirective(this.ctx);
            second.items.add(0, udn);
        }
        if (!this.ctx.statics.use_namespaces.isEmpty() && !this.parsing_include && second != null) {
            Iterator i$ = this.ctx.statics.use_namespaces.iterator();
            while (i$.hasNext()) {
                String useName = (String)i$.next();
                UseDirectiveNode udn2 = this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.nodeFactory.identifier(useName))));
                second.items.add(0, udn2);
            }
        }
        if (this.ctx.statics.es4_vectors && !this.parsing_include && second != null) {
            PackageIdentifiersNode pin = this.nodeFactory.packageIdentifiers(null, this.nodeFactory.identifier(__AS3__, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VEC, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VECTOR, false), true);
            ImportDirectiveNode idn = this.nodeFactory.importDirective(null, this.nodeFactory.packageName(pin), null, this.ctx);
            second.items.add(0, idn);
        }
        ProgramNode result = this.nodeFactory.program(this.ctx, second, this.ctx.input.positionOfMark());
        this.match(-1);
        if (this.ctx.scriptAssistParsing) {
            ListIterator it = this.comments.listIterator();
            while (it.hasNext()) {
                this.ctx.comments.add((Node)it.next());
            }
        }
        this.clearUnusedBuffers();
        if (!this.parsing_include) {
            if (result != null) {
                if (configs != null) {
                    result.statements.items.addAll(0, configs.items);
                }
                NamespaceDefinitionNode configdef = this.nodeFactory.configNamespaceDefinition(null, this.nodeFactory.identifier(CONFIG, false), -1);
                result.statements.items.add(0, configdef);
            }
            this.config_namespaces.pop_back();
        }
        return result;
    }

    private void clearUnusedBuffers() {
        this.comments.clear();
        this.scanner.clearUnusedBuffers();
        this.scanner = null;
        this.comments = null;
    }
}

