/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util.graph;

import java.util.Iterator;
import java.util.LinkedList;
import macromedia.asc.util.graph.Graph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

public final class Algorithms {
    public static void topologicalSort(Graph g, Visitor visitor) {
        int[] inDegree = new int[g.getVertices().size()];
        Vertex[] vertices = new Vertex[inDegree.length];
        Iterator i = g.getVertices().iterator();
        while (i.hasNext()) {
            Vertex v;
            vertices[v.id] = v = i.next();
            inDegree[v.id] = v.inDegrees();
        }
        LinkedList queue = new LinkedList();
        int length = vertices.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (inDegree[i2] != 0) continue;
            queue.add(vertices[i2]);
        }
        while (!queue.isEmpty()) {
            Vertex v = (Vertex)queue.removeFirst();
            if (visitor != null) {
                visitor.visit(v);
            }
            if (v.getSuccessors() == null) continue;
            Iterator i3 = v.getSuccessors().iterator();
            while (i3.hasNext()) {
                Vertex head = i3.next();
                int n = head.id;
                inDegree[n] = inDegree[n] - 1;
                if (inDegree[head.id] != 0) continue;
                queue.add(head);
            }
        }
    }
}

