/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.servlet;

import com.amazon.ask.Skill;
import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.ResponseEnvelope;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.servlet.util.ServletUtils;
import com.amazon.ask.servlet.verifiers.ServletRequest;
import com.amazon.ask.servlet.verifiers.SkillRequestSignatureVerifier;
import com.amazon.ask.servlet.verifiers.SkillRequestTimestampVerifier;
import com.amazon.ask.servlet.verifiers.SkillServletVerifier;
import com.amazon.ask.util.JacksonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkillServlet.class);
    private static final long serialVersionUID = 3257254794185762002L;
    private final transient Skill skill;
    private final transient List<SkillServletVerifier> verifiers;
    private final transient Serializer serializer = new JacksonSerializer();

    public SkillServlet(Skill skill) {
        Long timestampToleranceProperty;
        ArrayList<SkillServletVerifier> defaultVerifiers = new ArrayList<SkillServletVerifier>();
        if (!ServletUtils.isRequestSignatureCheckSystemPropertyDisabled().booleanValue()) {
            defaultVerifiers.add(new SkillRequestSignatureVerifier());
        }
        defaultVerifiers.add(new SkillRequestTimestampVerifier((timestampToleranceProperty = ServletUtils.getTimeStampToleranceSystemProperty()) != null ? timestampToleranceProperty : 30000L));
        this.skill = skill;
        this.verifiers = defaultVerifiers;
    }

    SkillServlet(Skill skill, List<SkillServletVerifier> verifiers) {
        this.skill = skill;
        this.verifiers = verifiers;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block16: {
            byte[] serializedRequestEnvelope = IOUtils.toByteArray((InputStream)request.getInputStream());
            try {
                RequestEnvelope deserializedRequestEnvelope = (RequestEnvelope)this.serializer.deserialize(IOUtils.toString((byte[])serializedRequestEnvelope, (String)"UTF-8"), RequestEnvelope.class);
                ServletRequest alexaHttpRequest = new ServletRequest(request, serializedRequestEnvelope, deserializedRequestEnvelope);
                for (SkillServletVerifier verifier : this.verifiers) {
                    verifier.verify(alexaHttpRequest);
                }
                ResponseEnvelope skillResponse = this.skill.invoke(deserializedRequestEnvelope);
                response.setContentType("application/json");
                response.setStatus(200);
                if (skillResponse == null) break block16;
                byte[] serializedResponse = this.serializer.serialize((Object)skillResponse).getBytes(StandardCharsets.UTF_8);
                try (ServletOutputStream out = response.getOutputStream();){
                    response.setContentLength(serializedResponse.length);
                    out.write(serializedResponse);
                }
            }
            catch (SecurityException ex) {
                int statusCode = 400;
                LOGGER.error("Incoming request failed verification {}", (Object)statusCode, (Object)ex);
                response.sendError(statusCode, ex.getMessage());
            }
            catch (AskSdkException ex) {
                int statusCode = 500;
                LOGGER.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
                response.sendError(statusCode, ex.getMessage());
            }
        }
    }

    public void setProxy(Proxy proxy) {
        if (this.verifiers.removeIf(verifier -> verifier instanceof SkillRequestSignatureVerifier)) {
            this.verifiers.add(new SkillRequestSignatureVerifier(proxy));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("Skill servlet is not serializable");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("Skill servlet is not serializable");
    }
}

