/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.lite;

import com.amazon.ion.ContainedValueException;
import com.amazon.ion.IonSequence;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.impl._Private_CurriedValueFactory;
import com.amazon.ion.impl._Private_IonValue;
import com.amazon.ion.impl.lite.ContainerlessContext;
import com.amazon.ion.impl.lite.IonContainerLite;
import com.amazon.ion.impl.lite.IonContext;
import com.amazon.ion.impl.lite.IonValueLite;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IonSequenceLite
extends IonContainerLite
implements IonSequence {
    protected static final IonValueLite[] EMPTY_VALUE_ARRAY = new IonValueLite[0];

    IonSequenceLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonSequenceLite(IonSequenceLite existing, IonContext context) {
        super(existing, context, false);
    }

    IonSequenceLite(ContainerlessContext context, Collection<? extends IonValue> elements) throws ContainedValueException, NullPointerException, IllegalArgumentException {
        this(context, elements == null);
        assert (this._children == null);
        if (elements != null) {
            this._children = new IonValueLite[elements.size()];
            for (IonValueLite ionValueLite : elements) {
                super.add(ionValueLite);
            }
        }
    }

    @Override
    public abstract IonSequenceLite clone();

    protected int sequenceHashCode(int seed, _Private_IonValue.SymbolTableProvider symbolTableProvider) {
        int prime = 8191;
        int result = seed;
        if (!this.isNullValue()) {
            for (IonValue v : this) {
                IonValueLite vLite = (IonValueLite)v;
                result = 8191 * result + vLite.hashCode(symbolTableProvider);
                result ^= result << 29 ^ result >> 3;
            }
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    @Override
    public boolean add(IonValue element) throws ContainedValueException, NullPointerException {
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends IonValue> c) {
        this.checkForLock();
        if (c == null) {
            throw new NullPointerException();
        }
        boolean changed = false;
        for (IonValue ionValue : c) {
            changed = this.add(ionValue) || changed;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends IonValue> c) {
        this.checkForLock();
        if (c == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        boolean changed = false;
        for (IonValue ionValue : c) {
            this.add(index++, ionValue);
            changed = true;
        }
        if (changed) {
            this.patch_elements_helper(index);
        }
        return changed;
    }

    @Override
    public ValueFactory add() {
        return new _Private_CurriedValueFactory(this.getSystem()){

            protected void handle(IonValue newValue) {
                IonSequenceLite.this.add(newValue);
            }
        };
    }

    @Override
    public void add(int index, IonValue element) throws ContainedValueException, NullPointerException {
        this.add(index, (IonValueLite)element);
    }

    @Override
    public ValueFactory add(final int index) {
        return new _Private_CurriedValueFactory(this.getSystem()){

            protected void handle(IonValue newValue) {
                IonSequenceLite.this.add(index, newValue);
                IonSequenceLite.this.patch_elements_helper(index + 1);
            }
        };
    }

    @Override
    public IonValue set(int index, IonValue element) {
        this.checkForLock();
        IonValueLite concrete = (IonValueLite)element;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.validateNewChild(element);
        assert (this._children != null);
        concrete._context = this.getContextForIndex(element, index);
        IonValueLite removed = this.set_child(index, concrete);
        concrete._elementid(index);
        removed.detachFromContainer();
        return removed;
    }

    @Override
    public IonValue remove(int index) {
        this.checkForLock();
        if (index < 0 || index >= this.get_child_count()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        IonValueLite v = this.get_child(index);
        assert (v._elementid() == index);
        this.remove_child(index);
        this.patch_elements_helper(index);
        return v;
    }

    @Override
    public boolean remove(Object o) {
        this.checkForLock();
        int idx = this.lastIndexOf(o);
        if (idx < 0) {
            return false;
        }
        assert (o instanceof IonValueLite);
        assert (((IonValueLite)o)._elementid() == idx);
        this.remove_child(idx);
        this.patch_elements_helper(idx);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        this.checkForLock();
        for (Object o : c) {
            int idx = this.lastIndexOf(o);
            if (idx < 0) continue;
            assert (o == this.get_child(idx));
            this.remove_child(idx);
            this.patch_elements_helper(idx);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        IonValue v;
        this.checkForLock();
        if (this.get_child_count() < 1) {
            return false;
        }
        IdentityHashMap<IonValue, IonValue> keepers = new IdentityHashMap<IonValue, IonValue>();
        for (Object o : c) {
            v = (IonValue)o;
            if (this != v.getContainer()) continue;
            keepers.put(v, v);
        }
        boolean changed = false;
        int ii = this.get_child_count();
        while (ii > 0) {
            if (keepers.containsKey(v = this.get_child(--ii))) continue;
            this.remove(v);
            this.patch_elements_helper(ii);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof IonValue)) {
            throw new ClassCastException();
        }
        return ((IonValue)o).getContainer() == this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        _Private_IonValue v = (_Private_IonValue)o;
        if (this != v.getContainer()) {
            return -1;
        }
        return v.getElementId();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public List<IonValue> subList(int fromIndex, int toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public IonValue[] toArray() {
        if (this.get_child_count() < 1) {
            return EMPTY_VALUE_ARRAY;
        }
        IonValue[] array = new IonValue[this.get_child_count()];
        System.arraycopy(this._children, 0, array, 0, this.get_child_count());
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.get_child_count();
        if (a.length < size) {
            Class<?> type = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(type, size);
        }
        if (size > 0) {
            System.arraycopy(this._children, 0, a, 0, size);
        }
        if (size < a.length) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public <T extends IonValue> T[] extract(Class<T> type) {
        this.checkForLock();
        if (this.isNullValue()) {
            return null;
        }
        IonValue[] array = (IonValue[])Array.newInstance(type, this.size());
        this.toArray(array);
        this.clear();
        return array;
    }

    @Override
    void writeBodyTo(IonWriter writer, _Private_IonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        IonType type = this.getType();
        if (this.isNullValue()) {
            writer.writeNull(type);
        } else {
            writer.stepIn(type);
            this.writeChildren(writer, this, symbolTableProvider);
            writer.stepOut();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubListView
    implements List<IonValue> {
        private final int fromIndex;
        private int size;
        private int structuralModificationCount;

        private SubListView(List<IonValue> parent, int fromIndex, int toIndex) {
            this.fromIndex = this.toTopLevelFromIndex(parent, fromIndex);
            this.size = toIndex - fromIndex;
            this.structuralModificationCount = IonSequenceLite.this.structuralModificationCount;
        }

        @Override
        public int size() {
            this.checkForParentModification();
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            this.checkForParentModification();
            return this.size == 0;
        }

        @Override
        public IonValue get(int index) {
            this.checkForParentModification();
            this.rangeCheck(index);
            return IonSequenceLite.this.get(this.toParentIndex(index));
        }

        @Override
        public IonValue set(int index, IonValue element) {
            this.checkForParentModification();
            this.rangeCheck(index);
            return IonSequenceLite.this.set(this.toParentIndex(index), element);
        }

        @Override
        public boolean contains(Object o) {
            this.checkForParentModification();
            return this.indexOf(o) != -1;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        public IonValue[] toArray() {
            this.checkForParentModification();
            if (this.size < 1) {
                return EMPTY_VALUE_ARRAY;
            }
            return this.toArray(new IonValue[this.size]);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            this.checkForParentModification();
            if (array.length < this.size) {
                Class<?> type = array.getClass().getComponentType();
                array = (Object[])Array.newInstance(type, this.size);
            }
            if (this.size > 0) {
                System.arraycopy(IonSequenceLite.this._children, this.fromIndex, array, 0, this.size);
            }
            if (this.size < array.length) {
                array[this.size] = null;
            }
            return array;
        }

        @Override
        public boolean add(IonValue ionValue) {
            this.checkForParentModification();
            int parentIndex = this.toParentIndex(this.size);
            if (parentIndex == IonSequenceLite.this.size()) {
                IonSequenceLite.this.add(ionValue);
            } else {
                IonSequenceLite.this.add(parentIndex, ionValue);
            }
            this.structuralModificationCount = IonSequenceLite.this.structuralModificationCount;
            ++this.size;
            return true;
        }

        @Override
        public void add(int index, IonValue ionValue) {
            this.checkForParentModification();
            this.rangeCheck(index);
            IonSequenceLite.this.add(this.toParentIndex(index), ionValue);
            this.structuralModificationCount = IonSequenceLite.this.structuralModificationCount;
            ++this.size;
        }

        @Override
        public boolean addAll(Collection<? extends IonValue> c) {
            for (IonValue ionValue : c) {
                this.add(ionValue);
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends IonValue> c) {
            int i = index;
            for (IonValue ionValue : c) {
                this.add(i, ionValue);
                ++i;
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.size < 1) {
                return false;
            }
            IdentityHashMap toRetain = new IdentityHashMap();
            for (Object o : c) {
                toRetain.put(o, null);
            }
            ArrayList<IonValue> toRemove = new ArrayList<IonValue>(this.size - c.size());
            for (int i = 0; i < this.size; ++i) {
                IonValue ionValue = this.get(i);
                if (toRetain.containsKey(ionValue)) continue;
                toRemove.add(ionValue);
            }
            return this.removeAll(toRemove);
        }

        @Override
        public void clear() {
            this.checkForParentModification();
            int parentIndex = this.toParentIndex(0);
            for (int i = 0; i < this.size; ++i) {
                IonSequenceLite.this.remove(parentIndex);
            }
            this.size = 0;
            this.structuralModificationCount = IonSequenceLite.this.structuralModificationCount;
        }

        @Override
        public IonValue remove(int index) {
            this.checkForParentModification();
            this.rangeCheck(index);
            IonValue removed = IonSequenceLite.this.remove(this.toParentIndex(index));
            this.structuralModificationCount = IonSequenceLite.this.structuralModificationCount;
            --this.size;
            return removed;
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object o : c) {
                if (!this.remove(o)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public int indexOf(Object o) {
            this.checkForParentModification();
            int parentIndex = IonSequenceLite.this.indexOf(o);
            int index = this.fromParentIndex(parentIndex);
            if (parentIndex < 0 || index < 0 || index >= this.size) {
                return -1;
            }
            return index;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public Iterator<IonValue> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<IonValue> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<IonValue> listIterator(final int index) {
            this.checkForParentModification();
            return new ListIterator<IonValue>(){
                private int lastReturnedIndex;
                private int nextIndex;
                {
                    this.lastReturnedIndex = index;
                    this.nextIndex = index;
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex < SubListView.this.size();
                }

                @Override
                public IonValue next() {
                    this.lastReturnedIndex = this.nextIndex++;
                    return SubListView.this.get(this.lastReturnedIndex);
                }

                @Override
                public boolean hasPrevious() {
                    return this.nextIndex > 0;
                }

                @Override
                public IonValue previous() {
                    this.lastReturnedIndex = --this.nextIndex;
                    return SubListView.this.get(this.lastReturnedIndex);
                }

                @Override
                public int nextIndex() {
                    return this.nextIndex;
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(IonValue ionValue) {
                    SubListView.this.set(this.lastReturnedIndex, ionValue);
                }

                @Override
                public void add(IonValue ionValue) {
                    SubListView.this.add(this.lastReturnedIndex, ionValue);
                }
            };
        }

        @Override
        public List<IonValue> subList(int fromIndex, int toIndex) {
            this.checkForParentModification();
            return new SubListView(this, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }

        private int toParentIndex(int index) {
            return index + this.fromIndex;
        }

        private int fromParentIndex(int index) {
            return index - this.fromIndex;
        }

        private int toTopLevelFromIndex(List<IonValue> parent, int fromIndex) {
            if (parent instanceof SubListView) {
                return fromIndex + ((SubListView)parent).fromIndex;
            }
            return fromIndex;
        }

        private void checkForParentModification() {
            if (this.structuralModificationCount != IonSequenceLite.this.structuralModificationCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

