/*
 * Decompiled with CFR 0.152.
 */
package com.antwerkz.issues;

import com.antwerkz.issues.IssuesGeneratorKt;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.PagedIterable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 32\u00020\u0001:\u00013B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010.\u001a\u00020\u0003H\u0002J\b\u0010/\u001a\u00020$H\u0002J\u0006\u00100\u001a\u00020$J\u001a\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\b0\u0014H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R-\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\b0\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0019\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0019\u001a\u0004\b!\u0010\fR\u001b\u0010#\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0019\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0019\u001a\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000e\u00a8\u00064"}, d2={"Lcom/antwerkz/issues/IssuesGenerator;", "", "repositoryName", "", "version", "docsUrl", "javadocUrl", "assets", "", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAssets", "()Ljava/util/List;", "getDocsUrl", "()Ljava/lang/String;", "github", "Lorg/kohsuke/github/GitHub;", "getGithub", "()Lorg/kohsuke/github/GitHub;", "issues", "", "Lorg/kohsuke/github/GHIssue;", "getIssues", "()Ljava/util/Map;", "issues$delegate", "Lkotlin/Lazy;", "getJavadocUrl", "milestone", "Lorg/kohsuke/github/GHMilestone;", "getMilestone", "()Lorg/kohsuke/github/GHMilestone;", "milestone$delegate", "pullRequests", "getPullRequests", "pullRequests$delegate", "release", "Lorg/kohsuke/github/GHRelease;", "getRelease", "()Lorg/kohsuke/github/GHRelease;", "release$delegate", "repository", "Lorg/kohsuke/github/GHRepository;", "getRepository", "()Lorg/kohsuke/github/GHRepository;", "repository$delegate", "getVersion", "draftContent", "findRelease", "generate", "groupIssues", "listPRs", "Companion", "issues-maven-plugin"})
public final class IssuesGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String docsUrl;
    @Nullable
    private final String javadocUrl;
    @NotNull
    private final List<File> assets;
    @NotNull
    private final GitHub github;
    @NotNull
    private final String version;
    @NotNull
    private final Lazy repository$delegate;
    @NotNull
    private final Lazy milestone$delegate;
    @NotNull
    private final Lazy release$delegate;
    @NotNull
    private final Lazy issues$delegate;
    @NotNull
    private final Lazy pullRequests$delegate;
    @NotNull
    private static final List<String> excludedLabels;

    public IssuesGenerator(@NotNull String repositoryName, @NotNull String version, @Nullable String docsUrl, @Nullable String javadocUrl, @NotNull List<? extends File> assets) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        this.docsUrl = docsUrl;
        this.javadocUrl = javadocUrl;
        this.assets = assets;
        GitHub gitHub = GitHubBuilder.fromEnvironment().build();
        Intrinsics.checkNotNullExpressionValue((Object)gitHub, (String)"fromEnvironment().build()");
        this.github = gitHub;
        this.version = StringsKt.replace$default((String)version, (String)"-SNAPSHOT", (String)"", (boolean)false, (int)4, null);
        this.repository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GHRepository>(this, repositoryName){
            final /* synthetic */ IssuesGenerator this$0;
            final /* synthetic */ String $repositoryName;
            {
                this.this$0 = $receiver;
                this.$repositoryName = $repositoryName;
                super(0);
            }

            public final GHRepository invoke() {
                return this.this$0.getGithub().getRepository(this.$repositoryName);
            }
        }));
        this.milestone$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GHMilestone>(this){
            final /* synthetic */ IssuesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GHMilestone invoke() {
                return IssuesGeneratorKt.findMilestone(this.this$0.getRepository(), this.this$0.getVersion());
            }
        }));
        this.release$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GHRelease>(this){
            final /* synthetic */ IssuesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GHRelease invoke() {
                return IssuesGenerator.access$findRelease(this.this$0);
            }
        }));
        this.issues$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends List<? extends GHIssue>>>(this){
            final /* synthetic */ IssuesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, List<GHIssue>> invoke() {
                return IssuesGenerator.access$groupIssues(this.this$0);
            }
        }));
        this.pullRequests$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends GHIssue>>(this){
            final /* synthetic */ IssuesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<GHIssue> invoke() {
                return IssuesGenerator.access$listPRs(this.this$0);
            }
        }));
    }

    public /* synthetic */ IssuesGenerator(String string, String string2, String string3, String string4, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, string4, list);
    }

    @Nullable
    public final String getDocsUrl() {
        return this.docsUrl;
    }

    @Nullable
    public final String getJavadocUrl() {
        return this.javadocUrl;
    }

    @NotNull
    public final List<File> getAssets() {
        return this.assets;
    }

    @NotNull
    public final GitHub getGithub() {
        return this.github;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final GHRepository getRepository() {
        Lazy lazy = this.repository$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-repository>(...)");
        return (GHRepository)object;
    }

    @NotNull
    public final GHMilestone getMilestone() {
        Lazy lazy = this.milestone$delegate;
        return (GHMilestone)lazy.getValue();
    }

    @NotNull
    public final GHRelease getRelease() {
        Lazy lazy = this.release$delegate;
        return (GHRelease)lazy.getValue();
    }

    @NotNull
    public final Map<String, List<GHIssue>> getIssues() {
        Lazy lazy = this.issues$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<GHIssue> getPullRequests() {
        Lazy lazy = this.pullRequests$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final GHRelease generate() {
        if (this.getRelease().isDraft()) {
            Object it;
            GHRelease generated = this.getRelease().update().body(this.draftContent()).update();
            PagedIterable pagedIterable = this.getRelease().listAssets();
            Intrinsics.checkNotNullExpressionValue((Object)pagedIterable, (String)"release.listAssets()");
            Iterable $this$forEach$iv = (Iterable)pagedIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GHAsset)element$iv;
                boolean bl = false;
                System.out.println((Object)("Removing " + it.getName()));
                it.delete();
            }
            $this$forEach$iv = CollectionsKt.distinct((Iterable)this.assets);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                boolean bl = false;
                System.out.println((Object)("Uploading " + it));
                this.getRelease().uploadAsset((File)it, "application/java-archive");
            }
            Intrinsics.checkNotNullExpressionValue((Object)generated, (String)"generated");
            return generated;
        }
        throw new IllegalStateException("Milestone " + this.getRelease().getName() + " is already closed.");
    }

    /*
     * WARNING - void declaration
     */
    private final String draftContent() {
        String generated = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
        String notes = null;
        notes = StringsKt.trimIndent((String)("\n                ## Version " + this.version + " (" + generated + ")\n                \n                ### Notes\n                " + this.getMilestone().getDescription() + "\n                \n                ### Downloads\n                Binaries can be found on maven central.\n                "));
        if (this.docsUrl != null || this.javadocUrl != null) {
            notes = notes + "\n### Documentation\n";
            if (this.docsUrl != null) {
                notes = notes + "Full documentation can be found at " + this.docsUrl + ". ";
            }
            if (this.javadocUrl != null) {
                notes = notes + "Javadoc can be found at " + this.javadocUrl + ". ";
            }
        }
        if (!this.getIssues().isEmpty()) {
            Object object;
            void $this$associateTo$iv$iv;
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = this.getIssues().values();
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            int $i$f$mapTo = 0;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.size());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl = false;
                accumulator$iv = acc + i;
            }
            int count = ((Number)accumulator$iv).intValue();
            notes = notes + "\n### " + count + " Issues Resolved\n";
            PagedIterable pagedIterable = this.getRepository().listLabels();
            Intrinsics.checkNotNullExpressionValue((Object)pagedIterable, (String)"repository.listLabels()");
            Iterable $this$associate$iv = (Iterable)pagedIterable;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable i = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object = destination$iv$iv2;
                GHLabel it = (GHLabel)element$iv$iv;
                boolean bl = false;
                it = TuplesKt.to((Object)it.getName(), (Object)it.getColor());
                object.put(it.getFirst(), it.getSecond());
            }
            Map labels = destination$iv$iv2;
            Map<String, List<GHIssue>> $this$forEach$iv = this.getIssues();
            boolean $i$f$forEach = false;
            for (Map.Entry<String, List<GHIssue>> element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry<String, List<GHIssue>> entry = element$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                List issues2 = (List)entry.getValue();
                StringBuilder stringBuilder = new StringBuilder().append(notes).append("#### ![](https://placehold.it/15/").append((String)labels.get(key)).append("/000000?text=+) ");
                object = key;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string = ((String)object).toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(locale)");
                notes = stringBuilder.append(string).append('\n').toString();
                Iterable $this$forEach$iv2 = issues2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GHIssue issue = (GHIssue)element$iv2;
                    boolean bl2 = false;
                    notes = notes + "* [#" + issue.getNumber() + "](" + issue.getHtmlUrl() + "): " + issue.getTitle() + '\n';
                }
                notes = notes + '\n';
            }
        }
        if (!((Collection)this.getPullRequests()).isEmpty()) {
            notes = notes + "\n### " + this.getPullRequests().size() + " Pull Requests merged\n";
            Iterable $this$forEach$iv = this.getPullRequests();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GHIssue pr = (GHIssue)element$iv;
                boolean bl = false;
                notes = notes + "* [#" + pr.getNumber() + "](" + pr.getHtmlUrl() + "): " + pr.getTitle() + '\n';
            }
        }
        return notes;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<GHIssue>> groupIssues() {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        GHLabel it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        GHIssue it2;
        Iterable $this$filterTo$iv$iv;
        List list = this.getRepository().getIssues(GHIssueState.CLOSED, this.getMilestone());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"repository.getIssues(CLOSED, milestone)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (GHIssue)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isPullRequest())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GHIssue issue = (GHIssue)element$iv$iv;
            boolean bl = false;
            Collection collection2 = issue.getLabels();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"issue.labels");
            $this$map$iv = collection2;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GHLabel gHLabel = (GHLabel)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            if (!CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)excludedLabels).isEmpty()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            it2 = (GHIssue)element$iv$iv;
            boolean bl = false;
            if (it2.getLabels().isEmpty()) {
                list2 = CollectionsKt.listOf((Object)TuplesKt.to((Object)"uncategorized", (Object)it2));
            } else {
                Collection collection3 = it2.getLabels();
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"it.labels");
                $this$map$iv = collection3;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void label;
                    it = (GHLabel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(TuplesKt.to((Object)label.getName(), (Object)it2));
                }
                list2 = (List)destination$iv$iv;
            }
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it3;
            Object object2;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-IssuesGenerator$groupIssues$62 = false;
            key$iv$iv = (String)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-IssuesGenerator$groupIssues$62 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((GHIssue)it3.getSecond());
        }
        Object $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it4;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl4 = false;
            Iterable $this$sortedBy$iv = (Iterable)it4.getValue();
            boolean $i$f$sortedBy = false;
            List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GHIssue issue = (GHIssue)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(issue.getNumber());
                    issue = (GHIssue)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(issue.getNumber()));
                }
            });
            object.put(k, list3);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv2);
    }

    private final List<GHIssue> listPRs() {
        GHIssue it;
        Iterable $this$filterTo$iv$iv;
        List list = this.getRepository().getIssues(GHIssueState.CLOSED, this.getMilestone());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"repository.getIssues(CLOSED, milestone)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GHIssue)element$iv$iv;
            boolean bl = false;
            if (!it.isPullRequest()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GHIssue)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getLabels();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.labels");
            if (!CollectionsKt.intersect((Iterable)collection, (Iterable)excludedLabels).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GHRelease findRelease() {
        return IssuesGeneratorKt.findReleaseByName(this.getRepository(), "Version " + this.version);
    }

    public static final /* synthetic */ GHRelease access$findRelease(IssuesGenerator $this) {
        return $this.findRelease();
    }

    public static final /* synthetic */ Map access$groupIssues(IssuesGenerator $this) {
        return $this.groupIssues();
    }

    public static final /* synthetic */ List access$listPRs(IssuesGenerator $this) {
        return $this.listPRs();
    }

    static {
        Object[] objectArray = new String[]{"wontfix", "invalid"};
        excludedLabels = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/antwerkz/issues/IssuesGenerator$Companion;", "", "()V", "excludedLabels", "", "", "getExcludedLabels", "()Ljava/util/List;", "issues-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getExcludedLabels() {
            return excludedLabels;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

