/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ForkCommandParameters
extends AbstractCommandParameters {
    private final String defaultBranch;
    private final Repository fork;

    private ForkCommandParameters(Builder builder) {
        this.defaultBranch = builder.defaultBranch;
        this.fork = builder.fork;
    }

    @Nonnull
    public Repository getFork() {
        return this.fork;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public static class Builder {
        private final Repository fork;
        private String defaultBranch;

        public Builder(@Nonnull Repository fork) {
            this.fork = Objects.requireNonNull(fork, "fork");
        }

        @Nonnull
        public ForkCommandParameters build() {
            return new ForkCommandParameters(this);
        }

        @Nonnull
        public Builder defaultBranch(@Nullable String value) {
            this.defaultBranch = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

