/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public interface Directory
extends Serializable,
Attributes {
    public static final String CACHE_ENABLED = "com.atlassian.crowd.directory.sync.cache.enabled";

    public Long getId();

    public String getName();

    public boolean isActive();

    public String getEncryptionType();

    public Map<String, String> getAttributes();

    public Set<OperationType> getAllowedOperations();

    public String getDescription();

    public DirectoryType getType();

    public String getImplementationClass();

    public Date getCreatedDate();

    public Date getUpdatedDate();

    default public boolean isPersistable() {
        return true;
    }

    default public boolean cachesAllUsers() {
        return Directory.cachesUsers(this, true);
    }

    default public boolean cachesAnyUsers() {
        return Directory.cachesUsers(this, false);
    }

    private static boolean cachesUsers(Directory directory, boolean fullyCached) {
        return switch (directory.getType()) {
            default -> throw new MatchException(null, null);
            case DirectoryType.CUSTOM, DirectoryType.UNKNOWN -> false;
            case DirectoryType.INTERNAL, DirectoryType.AZURE_AD -> true;
            case DirectoryType.CROWD, DirectoryType.CONNECTOR -> Boolean.parseBoolean(directory.getAttributes().get(CACHE_ENABLED));
            case DirectoryType.DELEGATING -> !fullyCached;
        };
    }
}

