/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.backdoor;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertCriteria;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.CallbackResult;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.PageCallback;
import com.atlassian.diagnostics.PageRequest;
import com.atlassian.diagnostics.PageSummary;
import com.atlassian.diagnostics.Severity;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

public class DataService {
    private static final AlertTrigger[] TRIGGERS = new AlertTrigger[]{new AlertTrigger.Builder().plugin("System", null).module("PluginSystemLifecycle.class").build(), new AlertTrigger.Builder().plugin("com.atlassian.plugin1", "1.2.3").build(), new AlertTrigger.Builder().plugin("com.atlassian.plugin2", "2.3.1").module("SomeClass.class").build(), new AlertTrigger.Builder().plugin("com.atlassian.plugin2", "2.3.5").module("SomeClass.class").build(), new AlertTrigger.Builder().plugin("com.atlassian.plugin3", "1.0.0").module("SomeClass.class").build(), new AlertTrigger.Builder().plugin("com.atlassian.plugin4", "1.0.0").module("SomeClass.class").build()};
    private final MonitoringService monitoringService;
    private ComponentMonitor monitorIt1;
    private ComponentMonitor monitorIt2;
    private ComponentMonitor monitorIt3;
    private Map<String, Issue> issues;

    public DataService(MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
        this.issues = new HashMap<String, Issue>();
        this.monitorIt1 = this.initMonitor("IT1");
        this.monitorIt2 = this.initMonitor("IT2");
        this.monitorIt3 = this.initMonitor("IT3");
    }

    public synchronized Instant createTestData() {
        PageCallback<Alert, Alert> callback = new PageCallback<Alert, Alert>(){
            private Alert latest;

            @Override
            public CallbackResult onItem(Alert item) {
                this.latest = item;
                return CallbackResult.DONE;
            }

            @Override
            public Alert onEnd(PageSummary summary) {
                return this.latest;
            }
        };
        Alert latest = this.monitoringService.streamAlerts(AlertCriteria.builder().componentIds("IT1", "IT2", "IT3").build(), callback, PageRequest.ofSize(1));
        if (latest != null) {
            return latest.getTimestamp();
        }
        Instant latestTimestamp = Instant.now();
        for (int i = 0; i < 50; ++i) {
            Instant timestamp = latestTimestamp.minusSeconds((49 - i) * 5);
            ImmutableMap details = ImmutableMap.of((Object)"details", (Object)("some-value-" + i));
            this.monitorIt1.alert(new AlertRequest.Builder(this.issues.get("IT1-1001")).timestamp(timestamp).trigger(TRIGGERS[0]).details(() -> DataService.lambda$createTestData$0((Map)details)).build());
            timestamp = latestTimestamp.minusSeconds((49 - i) * 30);
            this.monitorIt2.alert(new AlertRequest.Builder(this.issues.get("IT2-1002")).timestamp(timestamp).trigger(TRIGGERS[1]).details(() -> DataService.lambda$createTestData$1((Map)details)).build());
            timestamp = latestTimestamp.minus(49 - i, ChronoUnit.HOURS);
            this.monitorIt3.alert(new AlertRequest.Builder(this.issues.get("IT3-1003")).timestamp(timestamp).trigger(TRIGGERS[i % 6]).details(() -> DataService.lambda$createTestData$2((Map)details)).build());
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return latestTimestamp;
    }

    private ComponentMonitor initMonitor(String componentId) {
        ComponentMonitor monitor = this.monitoringService.createMonitor(componentId, componentId.toLowerCase() + ".component.name");
        this.issues.put(componentId + "-1001", this.defineIssue(monitor, 1001, Severity.INFO));
        this.issues.put(componentId + "-1002", this.defineIssue(monitor, 1002, Severity.WARNING));
        this.issues.put(componentId + "-1003", this.defineIssue(monitor, 1003, Severity.ERROR));
        this.issues.put(componentId + "-1004", this.defineIssue(monitor, 1004, Severity.ERROR));
        return monitor;
    }

    private Issue defineIssue(ComponentMonitor monitor, int id, Severity severity) {
        String prefix = monitor.getComponent().getId().toLowerCase() + ".issue." + id + ".";
        return monitor.defineIssue(id).severity(severity).summaryI18nKey(prefix + "summary").descriptionI18nKey(prefix + "description").build();
    }

    private static /* synthetic */ Object lambda$createTestData$2(Map details) {
        return details;
    }

    private static /* synthetic */ Object lambda$createTestData$1(Map details) {
        return details;
    }

    private static /* synthetic */ Object lambda$createTestData$0(Map details) {
        return details;
    }
}

