/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.plugins.jira.utils.RecentPlansProvider;
import com.radiantminds.plugins.jira.utils.RecentlyVisitedPlan;
import com.radiantminds.plugins.jira.utils.UserPropertyManagerWrapper;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RecentPlansProviderTest {
    private UserPropertyManagerWrapper userPropertyManagerWrapper;
    private PortfolioPlanPersistence portfolioPlanPersistence;
    private RecentPlansProvider recentPlansProvider;

    @Before
    public void setUp() throws Exception {
        this.userPropertyManagerWrapper = (UserPropertyManagerWrapper)Mockito.mock(UserPropertyManagerWrapper.class);
        this.portfolioPlanPersistence = (PortfolioPlanPersistence)Mockito.mock(PortfolioPlanPersistence.class);
        this.recentPlansProvider = new RecentPlansProvider(this.portfolioPlanPersistence, this.userPropertyManagerWrapper);
    }

    @Test
    public void testMigrateRecentPlans() throws Exception {
        Mockito.when((Object)this.portfolioPlanPersistence.listAllAvailablePlanIds()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"2", "5"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent.json")).thenReturn((Object)Lists.newArrayList());
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"1", "2", "3-2", "4-2", "5", "6-2"}));
        List addResult = this.recentPlansProvider.add(30L);
        Assert.assertEquals((long)6L, (long)addResult.size());
        Assert.assertEquals((long)30L, (long)((RecentlyVisitedPlan)addResult.get(0)).getPlanId());
        Assert.assertEquals((long)2L, (long)((RecentlyVisitedPlan)addResult.get(1)).getPlanId());
        Assert.assertEquals((long)3L, (long)((RecentlyVisitedPlan)addResult.get(2)).getPlanId());
        Assert.assertEquals((long)4L, (long)((RecentlyVisitedPlan)addResult.get(3)).getPlanId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisitedPlan)addResult.get(4)).getPlanId());
        Assert.assertEquals((long)6L, (long)((RecentlyVisitedPlan)addResult.get(5)).getPlanId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(0)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(1)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(2)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(3)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(4)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(5)).getScenarioId());
        Assert.assertEquals((Object)new Integer(1), (Object)((RecentlyVisitedPlan)addResult.get(0)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(1), (Object)((RecentlyVisitedPlan)addResult.get(1)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(2)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(3)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(1), (Object)((RecentlyVisitedPlan)addResult.get(4)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(5)).getJpoVersion());
    }

    @Test
    public void testAddRecentPlan() throws Exception {
        Mockito.when((Object)this.portfolioPlanPersistence.listAllAvailablePlanIds()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"2", "3", "5", "7"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"11", "22", "33", "44", "55", "66"}));
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent.json")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"{\"planId\":1, \"scenarioId\":7 , \"jpoVersion\":2}", "{\"planId\":2,                    \"jpoVersion\":2}", "{\"planId\":3, \"scenarioId\":9 , \"jpoVersion\":2}", "{\"planId\":4,                    \"jpoVersion\":1}", "{\"planId\":5, \"scenarioId\":11, \"jpoVersion\":2}", "{\"planId\":5, \"scenarioId\":11, \"jpoVersion\":1}", "{\"planId\":6, \"scenarioId\":12, \"jpoVersion\":2}"}));
        List addResult = this.recentPlansProvider.add(30L);
        ((UserPropertyManagerWrapper)Mockito.verify((Object)this.userPropertyManagerWrapper)).setStrings((String)Matchers.eq((Object)"com.radiantminds.roadmaps-jira.plans.recent.json"), (Iterable)Matchers.anyCollectionOf(String.class));
        Assert.assertEquals((long)7L, (long)addResult.size());
        Assert.assertEquals((long)30L, (long)((RecentlyVisitedPlan)addResult.get(0)).getPlanId());
        Assert.assertEquals((long)1L, (long)((RecentlyVisitedPlan)addResult.get(1)).getPlanId());
        Assert.assertEquals((long)2L, (long)((RecentlyVisitedPlan)addResult.get(2)).getPlanId());
        Assert.assertEquals((long)3L, (long)((RecentlyVisitedPlan)addResult.get(3)).getPlanId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisitedPlan)addResult.get(4)).getPlanId());
        Assert.assertEquals((long)5L, (long)((RecentlyVisitedPlan)addResult.get(5)).getPlanId());
        Assert.assertEquals((long)6L, (long)((RecentlyVisitedPlan)addResult.get(6)).getPlanId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(0)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)7L), (Object)((RecentlyVisitedPlan)addResult.get(1)).getScenarioId());
        Assert.assertEquals((Object)Optional.absent(), (Object)((RecentlyVisitedPlan)addResult.get(2)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)9L), (Object)((RecentlyVisitedPlan)addResult.get(3)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)11L), (Object)((RecentlyVisitedPlan)addResult.get(4)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)11L), (Object)((RecentlyVisitedPlan)addResult.get(5)).getScenarioId());
        Assert.assertEquals((Object)Optional.of((Object)12L), (Object)((RecentlyVisitedPlan)addResult.get(6)).getScenarioId());
        Assert.assertEquals((Object)new Integer(1), (Object)((RecentlyVisitedPlan)addResult.get(0)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(1)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(2)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(3)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(4)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(1), (Object)((RecentlyVisitedPlan)addResult.get(5)).getJpoVersion());
        Assert.assertEquals((Object)new Integer(2), (Object)((RecentlyVisitedPlan)addResult.get(6)).getJpoVersion());
    }

    @Test
    public void testObsoletePropertyHoldsJson() throws Exception {
        String legacy = "{\"planId\":2,\"jpoVersion\":1,\"timestamp\":1484905678763}";
        Mockito.when((Object)this.userPropertyManagerWrapper.getStrings("com.radiantminds.roadmaps-jira.plans.recent")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{legacy}));
        List result = this.recentPlansProvider.getRecentlyVisitedPlans();
        Assert.assertEquals((Object)new RecentlyVisitedPlan(Long.valueOf(2L), Optional.absent(), Integer.valueOf(1)), result.get(0));
    }
}

