/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.estimatestatistics;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.estimatestatistics.DefaultEstimateStatistics;
import com.atlassian.rm.common.bridges.agile.estimatestatistics.EstimateStatistics;
import com.atlassian.rm.common.bridges.agile.estimatestatistics.EstimateStatisticsServiceBridge;
import com.atlassian.rm.common.bridges.agile.estimatestatistics.EstimateStatisticsType;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.service.UnsafeBundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.estimatestatistics.EstimateStatisticsServiceBridgeCloud")
@SupportedVersions(all=true)
public class EstimateStatisticsServiceBridgeCloud
implements EstimateStatisticsServiceBridge {
    private static final String FIELD_NOT_FOUND_ERROR = "gh.rapid.config.statistics.error.field.not.found";
    private final UnsafeBundleServiceServiceOutcomeHandler serviceOutcomeHandler;

    @Autowired
    public EstimateStatisticsServiceBridgeCloud(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.serviceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", "estimateStatisticServiceImpl");
    }

    @Override
    public EstimateStatistics getEstimateStatistics(long boardId) throws AgileNotAvailableException, AgileServiceOutcomeException {
        RapidView.RapidViewBuilder builder = new RapidView.RapidViewBuilder();
        final RapidView rapidView = builder.id(Long.valueOf(boardId)).build();
        return this.serviceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<EstimateStatisticService, ServiceOutcome, StatisticsField, EstimateStatistics>(){

            @Override
            public ServiceOutcome getServiceOutcome(EstimateStatisticService estimateStatisticService) {
                return estimateStatisticService.getEstimateStatisticStrict(rapidView);
            }

            @Override
            public EstimateStatistics getResult(StatisticsField statisticsField) {
                StatisticsFieldConfig statisticsFieldConfig = statisticsField.getConfig();
                StatisticsFieldConfig.Type statisticsFieldConfigType = statisticsFieldConfig.getType();
                switch (statisticsFieldConfigType) {
                    case JIRA_FIELD: {
                        return new DefaultEstimateStatistics(EstimateStatisticsType.Field, (Optional<String>)Optional.of((Object)statisticsFieldConfig.getFieldId()));
                    }
                    case ISSUE_COUNT: 
                    case ISSUE_COUNT_EXCL_SUBS: {
                        return new DefaultEstimateStatistics(EstimateStatisticsType.IssueCount, (Optional<String>)Optional.absent());
                    }
                }
                return new DefaultEstimateStatistics(EstimateStatisticsType.None, (Optional<String>)Optional.absent());
            }

            @Override
            public EstimateStatistics handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, EstimateStatisticsServiceBridgeCloud.FIELD_NOT_FOUND_ERROR)) {
                    return new DefaultEstimateStatistics(EstimateStatisticsType.None, (Optional<String>)Optional.absent());
                }
                return (EstimateStatistics)super.handleErrors(serviceOutcome);
            }
        });
    }
}

