/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.rank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.rank.BatchAgileRankException;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AgileRankOperationResponse {
    private static final Log LOGGER = Log.with(AgileRankOperationResponse.class);
    public static final AgileRankOperationResponse EMPTY = new AgileRankOperationResponse(Collections.EMPTY_SET);
    private final Set<Long> rankedIds;

    public AgileRankOperationResponse(Set<Long> rankedIds) {
        this.rankedIds = rankedIds;
    }

    public Set<Long> getRankedIds() {
        return this.rankedIds;
    }

    public static AgileRankOperationResponse create(ServiceOutcome<BatchRankChange> outcome, List<Long> ids) throws BatchAgileRankException {
        if (outcome.isInvalid()) {
            LOGGER.error("Agile call returned errors: %s", Joiner.on((String)",").join((Iterable)outcome.getErrors().getErrors()));
            throw new BatchAgileRankException(Sets.newHashSet(), Sets.newHashSet(ids));
        }
        if (!((BatchRankChange)outcome.get()).getErrorCollections().isEmpty()) {
            LOGGER.error("Agile call returned errors: %s", Joiner.on((String)",").withKeyValueSeparator("=").join(((BatchRankChange)outcome.get()).getErrorCollections()));
            throw new BatchAgileRankException(AgileRankOperationResponse.extractIds(((BatchRankChange)outcome.get()).getSuccessfulRankChanges()), ((BatchRankChange)outcome.get()).getErrorCollections().keySet());
        }
        AgileRankOperationResponse response = new AgileRankOperationResponse(AgileRankOperationResponse.extractIds(((BatchRankChange)outcome.get()).getSuccessfulRankChanges()));
        LOGGER.debug("created response: %s", response);
        return response;
    }

    private static Set<Long> extractIds(List<RankChange> rankChanges) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)rankChanges.size());
        for (RankChange rankChange : rankChanges) {
            ids.add(rankChange.getIssueId());
        }
        return ids;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("rankedIds", (Object)Joiner.on((String)",").join(this.rankedIds)).toString();
    }
}

