/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.rank;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.JpoRankService;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankOperationResponse;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.rank.AnonymousRankService")
class AnonymousRankService {
    private static final String RANK_SERVICE_ID = "jpoRankServiceImpl";
    private static final Log LOGGER = Log.with(AnonymousRankService.class);
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;

    @Autowired
    AnonymousRankService(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
    }

    AgileRankOperationResponse rankFirst(List<Long> ids, long domain) throws Exception {
        LOGGER.debug("rank first request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankFirstVirtualIds(ids, domain));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankLast(List<Long> ids, long domain) throws Exception {
        LOGGER.debug("rank last request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankLastVirtualIds(ids, domain));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankBefore(List<Long> ids, long anchorId, long domain) throws Exception {
        LOGGER.debug("rank before anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankBeforeVirtualIds(ids, anchorId, domain));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankAfter(List<Long> ids, long anchorId, long domain) throws Exception {
        LOGGER.debug("rank after anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankAfterVirtualIds(ids, anchorId, domain));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    ImmutableMap<Long, String> getRankValues(Collection<Long> ids, long domain) throws Exception {
        LOGGER.debug("rank value request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.getLexoRankValues(ids, domain));
        return ImmutableMap.copyOf((Map)((Map)outcome.get()));
    }

    ImmutableList<Long> sort(Collection<Long> ids, long domain) throws Exception {
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.sort(ids, domain));
        AnonymousRankService.logErrors(outcome.getErrors().getErrors());
        return ImmutableList.copyOf((Collection)((Collection)outcome.get()));
    }

    private static void logErrors(Collection<ErrorCollection.ErrorItem> errors) {
        if (errors != null && !errors.isEmpty()) {
            LOGGER.error("Agile call returned errors: %s", Joiner.on((String)",").join(errors));
        }
    }

    private BundleServiceAccessor<JpoRankService> getServiceAccessor() {
        return this.bundleServiceAccessorProvider.createUnsafeServiceAccessor("com.pyxis.greenhopper.jira", RANK_SERVICE_ID);
    }
}

