/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.rank;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.JpoRankService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankOperationResponse;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.rank.AuthorizedRankService")
class AuthorizedRankService {
    private static final String RANK_SERVICE_ID = "jpoRankServiceImpl";
    private static final Log LOGGER = Log.with(AuthorizedRankService.class);
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    AuthorizedRankService(BundleServiceAccessorProvider bundleServiceAccessorProvider, JiraAuthenticationContext authenticationContext) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.authenticationContext = authenticationContext;
    }

    AgileRankOperationResponse rankFirst(List<Long> ids, long domain) throws Exception {
        LOGGER.debug("rank first request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankFirst(ids, domain, this.authenticationContext.getUser()));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankLast(List<Long> ids, long domain) throws Exception {
        LOGGER.debug("rank last request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankLast(ids, domain, this.authenticationContext.getUser()));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankBefore(List<Long> ids, long anchorId, long domain) throws Exception {
        LOGGER.debug("rank before anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankBefore(ids, anchorId, domain, this.authenticationContext.getUser()));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    AgileRankOperationResponse rankAfter(List<Long> ids, long anchorId, long domain) throws Exception {
        LOGGER.debug("rank after anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.rankAfter(ids, anchorId, domain, this.authenticationContext.getUser()));
        return AgileRankOperationResponse.create((ServiceOutcome<BatchRankChange>)outcome, ids);
    }

    void delete(long id) throws Exception {
        ServiceOutcome outcome = this.getServiceAccessor().perform(jpoRankService -> jpoRankService.deleteIds((Iterable)Lists.newArrayList((Object[])new Long[]{id}), this.authenticationContext.getUser()));
        AuthorizedRankService.logErrors(outcome.getErrors().getErrors());
    }

    private static void logErrors(Collection<ErrorCollection.ErrorItem> errors) {
        if (errors != null && !errors.isEmpty()) {
            LOGGER.error("Agile call returned errors: %s", Joiner.on((String)",").join(errors));
        }
    }

    private BundleServiceAccessor<JpoRankService> getServiceAccessor() {
        return this.bundleServiceAccessorProvider.createUnsafeServiceAccessor("com.pyxis.greenhopper.jira", RANK_SERVICE_ID);
    }
}

