/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.cache;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.cache.CacheClearingBridge;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.cache.CacheClearingBridgeCloud")
@SupportedVersions(all=true)
class CacheClearingBridgeCloud
implements CacheClearingBridge {
    private static final Log LOGGER = Log.with(CacheClearingBridgeCloud.class);
    private final VCacheFactory factory;

    @Autowired
    CacheClearingBridgeCloud(VCacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public void clearRequestCaches() throws Exception {
        try {
            ComponentAccessor.getPermissionSchemeManager().flushSchemeEntities();
        }
        catch (Throwable t) {
            LOGGER.info("Failed to clear permission scheme manager cache", new Object[0]);
        }
        JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        authenticationContext.getClass().getMethod("clearRequestCache", new Class[0]).invoke((Object)authenticationContext, new Object[0]);
        AbstractVCacheService abstractCacheFactory = (AbstractVCacheService)ComponentAccessor.getComponent(VCacheFactory.class);
        for (String cacheKey : abstractCacheFactory.allRequestCacheDetails().keySet()) {
            this.factory.getRequestCache(cacheKey).removeAll();
        }
    }
}

