/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.user;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridge;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridgeCloud")
@SupportedVersions(all=true)
public class UserSearchServiceBridgeCloud
implements UserSearchServiceBridge {
    private final UserSearchService userSearchService;

    @Autowired
    public UserSearchServiceBridgeCloud(UserSearchService userSearchService) {
        this.userSearchService = userSearchService;
    }

    @Override
    public List<ApplicationUser> findUsersByName(String query, Optional<Integer> maxResults, Collection<String> excludes) {
        final HashSet excludesHash = excludes != null ? Sets.newHashSet(excludes) : Sets.newHashSet();
        UserSearchParams.Builder params = UserSearchParams.builder();
        params.allowEmptyQuery(true).includeActive(true).includeInactive(false);
        if (maxResults.isPresent()) {
            params.maxResults(Integer.valueOf((Integer)maxResults.get() + excludesHash.size()));
        }
        List matchingUsers = this.userSearchService.findUsers(query, params.build());
        if (excludesHash.size() > 0) {
            Iterable nonExcludedUsers = Iterables.filter((Iterable)matchingUsers, (Predicate)new Predicate<ApplicationUser>(){

                public boolean apply(ApplicationUser applicationUser) {
                    return !excludesHash.contains(applicationUser.getKey());
                }
            });
            if (maxResults.isPresent()) {
                return Lists.newArrayList((Iterable)Iterables.limit((Iterable)nonExcludedUsers, (int)((Integer)maxResults.get())));
            }
            return Lists.newArrayList((Iterable)nonExcludedUsers);
        }
        return matchingUsers;
    }
}

