/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.user.UserServiceBridge;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.user.UserServiceBridgeCloud")
@SupportedVersions(all=true)
public class UserServiceBridgeCloud
implements UserServiceBridge {
    private static final Log LOGGER = Log.with(UserServiceBridgeCloud.class);
    private final UserService userService;
    private final UserUtil userUtil;
    private final GroupManager groupManager;

    @Autowired
    public UserServiceBridgeCloud(UserService userService, UserUtil userUtil, GroupManager groupManager) {
        this.userService = userService;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
    }

    @Override
    public ApplicationUser createUserNoNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        ApplicationUser user = this.userService.createUserNoNotification(result);
        ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
        Set defaultGroups = applicationRoleManager.getDefaultGroups(ApplicationKeys.CORE);
        for (Group defaultGroup : defaultGroups) {
            try {
                this.groupManager.addUserToGroup(user, defaultGroup);
            }
            catch (Exception e) {
                LOGGER.warnDebug(e, "Unable to add user to group.", new Object[0]);
            }
        }
        return user;
    }

    @Override
    public UserService.CreateUserValidationResult validateCreateUserForSetup(ApplicationUser loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.userService.validateCreateUserForSetup(loggedInUser, username, password, confirmPassword, email, fullname);
    }

    @Override
    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, String username) {
        return this.userService.validateDeleteUser(loggedInUser, username);
    }

    @Override
    public void removeUser(ApplicationUser loggedInUser, UserService.DeleteUserValidationResult result) {
        this.userService.removeUser(loggedInUser, result);
    }

    @Override
    public void removeUserFromGroup(ApplicationUser user, String group) throws RemoveException, PermissionException {
        Group groupObject = this.groupManager.getGroup(group);
        if (groupObject != null) {
            this.userUtil.removeUserFromGroup(groupObject, user);
        }
    }

    @Override
    public Optional<ApplicationUser> getSomeSysAdmin() {
        Collection sysAdmins = this.userUtil.getJiraSystemAdministrators();
        if (sysAdmins == null || sysAdmins.isEmpty()) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)sysAdmins, null));
    }
}

