/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.BacklogSequencer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.BacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.CausalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IBacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.PossibleEpisodeTracker;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ReleaseDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.TimePlanState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemTrackerImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;

class BacklogStateInitializer {
    private final BacklogSequencer backlogSequencer;

    BacklogStateInitializer() {
        this(new BacklogSequencer());
    }

    BacklogStateInitializer(BacklogSequencer backlogSequencer) {
        this.backlogSequencer = backlogSequencer;
    }

    IBacklogState initialize(IRoadmapProblem problem) {
        IBacklog backlog = problem.getBacklog();
        CausalDependencyState causalState = CausalDependencyState.initialize(backlog.getDependencyDefinition(), ReleaseDependencyDefinition.createInstance(problem.getTimePlan()), problem.getProcessingDefinition().isSyncDependeeStartEnabled());
        TimePlanState temporalState = TimePlanState.initialize(problem.getTimePlan(), backlog.getProcessingItems());
        return new BacklogState(causalState, temporalState, UnstructuredItemTrackerImpl.createInstance(problem.getBacklog().getUnstructuredItems()), this.backlogSequencer.getProcessingItemSequence(problem), problem.getProcessingDefinition().getPlanningHorizon(), PossibleEpisodeTracker.createInstance(problem, temporalState));
    }
}

